﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.MyProfileModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">个人资料</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.artTxtCount.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
	        $('.tc').each(function(){
		        $(this).find('.tt').artTxtCount(
                    $(this).find('.ts'),
                    128,
                    "<span class=\"\">还可输入 <strong>{0}</strong> 个字</span>",
                    "<span class=\"\">已经超出 <strong>{0}</strong> 个字</span>"
                );
	        });
	        $("button[data-loading-text]").btns();

            var options = {
                beforeSubmit: function (formData, jqForm, options) {
                    $("button[data-loading-text]").btns("loading");
                    return true;
                },
                success: function (responseText, statusText) {
                    if (responseText.num == 0) {
                        easyDialog.open({ container: { header: '保存成功', content: '<b>保存成功</b><br>提示信息将于 3 秒后关闭...', yesFn: function () { } }, autoClose: 3000 });
                        return;
                    }
                    easyDialog.open({ container: { header: '提示', content: responseText.description, noFn: true } });
                },
                error: function () {
                    easyDialog.open({ container: { header: '提示', content: "服务器通讯失败", noFn: true } });
                },
                complete: function () {
                    $("button[data-loading-text]").btns("reset");
                },
                url: "<%=Url.Action("My_Profile","Handler") %>",
                type: 'post',
                dataType: 'json'
            };
            $("#post").ajaxForm(options);
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">


<div class="box_panel sp clearfix my_area">
    <%Html.RenderPartial("Menu", "Profile", ViewData);%>
    <div class="content">
        <div class="box_panel list_panel">
            <div class="box_panel_title">编辑个人资料</div>
	        <div class="box_panel_context form_panel_b">
                <form id="post" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                    <dl>
                        <dt>帐号</dt>
                        <dd><%=Model.Username%></dd>
                    </dl>
                    <dl>
                        <dt>昵称</dt>
                        <dd>
                            <%=Html.TextBox("nickname", string.Empty, new { @class = "text" })%>
                        </dd>
                    </dl>
                    <dl>
                        <dt>性别</dt>
                        <dd>
                            <label>
                                <%=Html.RadioButton("gender",1,Model.Gender==1) %>
                                男
                            </label>
                            <label>
                                <%=Html.RadioButton("gender",2,Model.Gender==2) %>
                                女
                            </label>
                            <label>
                                <%=Html.RadioButton("gender",0,Model.Gender==0) %>
                                保密
                            </label>
                        </dd>
                    </dl>
                    <dl>
                        <dt>生日</dt>
                        <dd>
                            <%=Html.TextBox("bday", Model.Birthday, new { @class = "text" })%>
                        </dd>
                    </dl>
                    <dl>
                        <dt>个人网站</dt>
                        <dd>
                            <%=Html.TextBox("site", Model.Site, new { @class = "text" })%>
                        </dd>
                    </dl>
                    <dl>
                        <dt>QQ</dt>
                        <dd>
                            <%=Html.TextBox("qq", Model.QQ, new { @class = "text" })%>
                        </dd>
                    </dl>
                    <dl>
                        <dt>MSN</dt>
                        <dd>
                            <%=Html.TextBox("msn",Model.MSN, new { @class = "text" })%>
                        </dd>
                    </dl>
                    <dl>
                        <dt>来自</dt>
                        <dd>
                            <%=Html.TextBox("address",Model.Address, new { @class = "text" })%>
                        </dd>
                    </dl>
                    <dl>
                        <dt>自我介绍</dt>
                        <dd class="tc">
                            <div class="text_area">
                            <%=Html.TextArea("bio", Model.Bio, new { cols="50",rows="5",@class="tt"})%>
                            </div>
                            <div class="ts"></div>
                        </dd>
                    </dl>
                    <dl>
                        <dt>个性签名</dt>
                        <dd class="tc">
                            <div class="text_area">
                            <%=Html.TextArea("signature", Model.Signature, new { cols = "50", rows = "5", @class = "tt" })%>
                            </div>
                            <div class="ts"></div>
                        </dd>
                    </dl>
                    <div class="control">
                        <button type="submit" name="Ok" class="button skyblue" data-loading-text="保存中...">确认</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



</asp:Content>