﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.HomeMainModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">首页</asp:Content>
<asp:Content ContentPlaceHolderID="RenderPointTop" runat="server">
    <%=RenderPluginPoint("home.top") %>
</asp:Content>
<asp:Content ContentPlaceHolderID="RenderPointBottom" runat="server">
    <%=RenderPluginPoint("home.bottom") %>
</asp:Content>
<asp:Content ContentPlaceHolderID="HeadContent" runat="server">
    <link rel="alternate" type="application/rss+xml" title="RSS订阅" href="<%=Url.SiteAction("RSS","Home") %>" />
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <%=Html.Partial("PageTopAd", Model.Advertisements, null) %>
    <div class="globalInfo sp clearfix">
        <div class="forumInfo">
            <%=Html.Lang("ui.main.today_post_count")%>: <cite><%=Model.Statistic.TodayPost%></cite>,
            <%=Html.Lang("ui.main.yesterday_post_count")%>: <cite><%=Model.Statistic.YesterdayPost%></cite>,
            <%=Html.Lang("ui.main.total_post_count")%>: <em><%=Model.Statistic.TotalPost%></em>,
            <%=Html.Lang("ui.main.total_user_count")%>: <em><%=Model.Statistic.TotalUser%></em>
            <%if (Model.Statistic.LastUserId > 0){%>
                ,
                <%=Html.Lang("ui.main.new_user")%>: <a href="<%=Url.SiteAction("Show", "User", new { uid = Model.Statistic.LastUserId }) %>" title="最新注册的会员"><%=Model.Statistic.LastUserNickname %></a>
            <%} %>
        </div>
        <div class="userInfo">
            <a href="<%=Url.SiteAction("RSS","Home") %>" target="_blank" title="订阅 RSS" class="rss">RSS</a>
            <span class="pipe">|</span>
            <a href="<%=Url.SiteAction("NewList","Topic") %>" title="查看最新的帖子列表"><%=Html.Lang("ui.main.new_topic") %></a>
            <span class="pipe">|</span>
            <a href="<%=Url.SiteAction("DigestList","Topic") %>" title="查看精华帖子列表"><%=Html.Lang("ui.main.digest") %></a>
        </div>
    </div>

    <%=Html.Partial("An", Model.Announcements, null) %>

    <%=RenderPluginPoint("home.board_list_top") %>

    <%for(int main_board_index=0;main_board_index< Model.Boards.Count;main_board_index++){ %>
        <%var MainBoard = Model.Boards[main_board_index]; %>
        <div class="box_panel list_panel sp board_panel">
            <input type="hidden" name="cookie_board_id" value="<%=MainBoard.Id %>" />
            <div class="box_panel_title clearfix">
                <div class="fl">
                    <a href="<%=Url.SiteAction("Show","Board",new{bid=MainBoard.Id}) %>"><%=MainBoard.Name %></a>
                    <%=RenderPluginPoint("home.board_list.board",main_board_index) %>
                </div>
                <div class="fr">
                    <a title="展开/收起" href="javascript:void(0);">
                        <img id="board_<%=MainBoard.Id %>_ci" src="<%=ResolveUrl("../../images/collapsed_no.gif") %>" alt="展开与收起" />
                    </a>
                </div>
            </div>
            <div class="box_panel_context" id="board_<%=MainBoard.Id %>">
                <div class="list_panel_cut">
                    <%=Html.Partial("BoardList", MainBoard, new ViewDataDictionary() {{"main_key","home.board_list.board"},{"main_key_index",main_board_index} })%>
                    
                </div>
            </div>
        </div>
    <%} %>

    <%=RenderPluginPoint("home.board_list_bottom") %>
    

    <%if (Model.OnlineState!=null || Model.Onlines!=null){ %>
        <div class="box_panel box_panel__color_easy sp online_panel">
            <%if(Model.OnlineState!=null){ %>
                <div class="box_panel_title">
                    <a href="<%=Url.SiteAction("OnlineUsers", "User")%>"><%=Html.Lang("ui.online.panel.title") %></a>
                    共 <%=Model.OnlineState.All %> 位用户在线,其中 <%=Model.OnlineState.User %> 位用户(隐身 <%=Model.OnlineState.NS %> 位),游客 <%=Model.OnlineState.All-Model.OnlineState.User %> 位，最高记录是 <%=Model.Statistic.HighestOnline %> 于 <%=Html.ForumTime(Model.Statistic.HighestOnlineDateTime).ToString("yyyy-MM-dd") %>.
                </div>
            <%} %>
            <%if (Model.Onlines != null || Model.OnlineGroups!=null){ %>
                <div class="box_panel_context">
                    <div class="bor">
                        <%if(Model.OnlineGroups!=null && Model.OnlineGroups.Any()){ %>
                            <ul class="group_list">
                                <%foreach (var online_group in Model.OnlineGroups){ %>
                                    <li <%if (!string.IsNullOrEmpty(online_group.Image)){ %>style="background: white url(<%="static/images/online/"+online_group.Image %>) no-repeat scroll 0 50%; "<%} %>><%=online_group.Name%></li>
                                <%} %>
                            </ul>
                        <%} %>
                        <%if(Model.Onlines!=null){ %>
                            <ul class="userlist">
                                <%if (Model.Onlines.Any()){ %>
                                    <%foreach (var online in Model.Onlines){ %>
                                        <%if (online.UserId > 0){ %>
                                            <li <%if (!string.IsNullOrEmpty(online.Image)){ %>style="background:white url(<%="static/images/online/"+online.Image %>) no-repeat scroll 0 50%;"<%} %>>
                                                <a href="<%=Url.SiteAction("Show","User",new{uid=online.UserId}) %>" title="在线会员：<%=online.Username %>">
                                                    <%=Html.InterceptStr(online.Username, 12, "...")%>
                                                </a>
                                            </li>
                                        <%}else{ %>
                                            <li <%if (!string.IsNullOrEmpty(online.Image)){ %>style="background:white url(<%="static/images/online/"+online.Image %>) no-repeat scroll 0 50%;"<%} %>><%=online.Username %></li>
                                        <%} %>
                                    <%} %>
                                <%}else{ %>
                                    <li>无在线用户</li>
                                <%} %>
                            </ul>
                        <%} %>
                    </div>
                </div>
            <%} %>
        </div>
    <%} %>
    <%if (Model.Links!=null){ %>
        <div class="box_panel box_panel__color_easy sp link_panel">
            <div class="box_panel_title"><%=Html.Lang("ui.link.panel.title")%></div>
            <div class="box_panel_context">
                <div class="list_panel_cut">
                    <table>
                        <tbody>
                            <%foreach (var link in Model.MainLinks){ %>
                            <tr>
                                <td class="allList">
                                    <%if (!string.IsNullOrEmpty(link.Logo)){ %>
                                        <a href="<%=link.Url%>" target="_blank"><img src="<%=Url.IsUrl(link.Logo)?link.Logo: ResolveUrl("../../../../static/images/link/" + link.Logo)%>" class="logo" alt="<%=Html.Encode(link.Name) %>" /></a>
                                    <%} %>
                                    <h5>
                                        <a href="<%=link.Url%>" target="_blank">
                                            <%=link.Name%>
                                        </a>
                                    </h5>
                                    <div class="link-description">
                                        <%=link.Description%>
                                    </div>
                                </td>
                            </tr>
                            <%} %>
                            <%if (Model.ImgLinks.Any()) { %>
                            <tr>
                                <td class="imageList">
                                    <ul>
                                    <%foreach (var link in Model.ImgLinks){ %>
                                        <li><a href="<%=link.Url%>" target="_blank" title="<%=Html.AttributeEncode(link.Name) %>"><img src="<%=Url.IsUrl(link.Logo)?link.Logo: ResolveUrl("../../../../static/images/link/" + link.Logo)%>" alt="<%=Html.Encode(link.Name) %>" /></a></li>
                                    <%} %>
                                    </ul>
                                </td>
                            </tr>
                            <%} %>
                            <%if (Model.TextLinks.Any()) { %>
                            <tr>
                                <td class="textList">
                                    <ul>
                                    <%foreach (var link in Model.TextLinks){ %>
                                        <li><a href="<%=link.Url%>" target="_blank"><%=link.Name%></a></li>
                                    <%} %>
                                    </ul>
                                </td>
                            </tr>
                            <%} %>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <%} %>
</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="FootContent" runat="server">
    <script type="text/javascript">
        $(function () {
            $.each($('input[name="cookie_board_id"]'), function (i, n) {
                var id = $(n).val();
                var cookie_name = "jokul.forum.board_" + id + ".oc";
                var c = $.cookie(cookie_name);
                if (c == "hide") {
                    $("#board_" + id)[0].style.display = "none";
                    $("#board_" + id + "_ci")[0].src = "<%=ResolveUrl("../../images/collapsed_yes.gif") %>";
            }
            else {
                $("#board_" + id + "_ci")[0].src = "<%=ResolveUrl("../../images/collapsed_no.gif") %>";
            }
        });

        $(".board_panel .fr a").click(function () {
            var id = $(this).parents(".board_panel").find('input[name="cookie_board_id"]').val();
            var cookie_name = "jokul.forum.board_" + id + ".oc";
            if ($("#board_" + id)[0].style.display == "none") {
                $("#board_" + id + "_ci")[0].src = "<%=ResolveUrl("../../images/collapsed_no.gif") %>";
                $("#board_" + id)[0].style.display = "block";
                $.cookie(cookie_name, null);
            }
            else {
                $("#board_" + id + "_ci")[0].src = "<%=ResolveUrl("../../images/collapsed_yes.gif") %>";
                $("#board_" + id)[0].style.display = "none";
                $.cookie(cookie_name, "hide");
            }
        });
    });
    </script>
</asp:Content>