﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.AccountLoginModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">登录</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function() {
        <%if (Model.VCEnabled) { %>
            function updateseccode() {
                var rand = Math.random();
                $('#VC').val('');
                $('#vcimg').attr("src","<%=Url.Action("ValidateCode", "Handler")%>?key=login&_="+rand);
            }
            updateseccode();
            $('#Username').focus();
        
            $('#vcimg').click(function() {
                updateseccode();
                $('#VC').focus();
            });
            $('#vcimgc').click(function() {
                updateseccode();
                $('#VC').focus();
                return false;
            });
        <%} %>
            $("button[name='Cancel']").click(function () {
                top.location.href="<%=Html.AttributeEncode(Model.Url) %>";
            });
            
            $("#post").bind("submit", function() {
                easyDialog.open({container : {content : '正在登录...'}});
            });
        });

    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <div class="box_panel login_panel">
        <div class="box_panel_title clearfix">
            <div class="fl"><%=Html.Lang("account.login.title")%></div>
            <div class="fr"><a href="<%=Url.Action("Register","Account") %>">没有帐号？立即注册</a></div>
        </div>
        <div class="box_panel_context form_panel_a">
            <form id="post" method="post" action="<%=Html.Encode(Request.Url.AbsolutePath) %>">
                <%=Html.ValidationSummary(false,string.Empty, new { @class = "error_panel" })%>
                <%=Html.HiddenFor(m=>m.Url) %>
                <dl>
                    <dt><%=Html.Lang("account.login.username")%>:</dt>
                    <dd>
                        <input type="text" name="username" size="40" class="text" tabindex="1" value="<%= Html.Encode(Model.Username) %>" />
                        <%= Html.ValidationMessage("username", "*", new { @class = "error_txt" })%>
                    </dd>
                </dl>
                <dl>
                    <dt><%=Html.Lang("account.login.password")%>:</dt>
                    <dd>
                        <input type="password" name="password" size="40" class="text" tabindex="2" value="<%= Html.Encode(Model.Password) %>" />
                        <%= Html.ValidationMessage("password", "*", new { @class = "error_txt" })%>
                    </dd>
                </dl>
                <dl>
                    <dd>
                        <a href="<%=Url.Action( "ResetPassword", "Account")%>" tabindex="5">我忘记密码了</a>
                    </dd>
                </dl>
                <%if (Model.VCEnabled) { %>
                    <dl>
                        <dt><%=Html.Lang("account.login.vc")%>:</dt>
                        <dd>
                            <%= Html.TextBoxFor(m => m.VC, new { size = "4", style = @"text-transform:uppercase;", @class = "vc text", tabindex = "3", value = string.Empty })%>
                            <%= Html.ValidationMessage("vc", "*", new { @class = "error_txt" })%>
                            <div class="description">
                                <%=Html.Lang("account.login.vc_description")%><br />
                                <img id="vcimg" src="<%=ResolveUrl("../../images/loading.gif")%>" alt="Loading" /><br />
                                <a href="#" id="vcimgc" tabindex="6"><%=Html.Lang("account.login.vc_refresh")%></a>
                            </div>
                        </dd>
                    </dl>
                <%} %>
                <dl>
                    <dd>
                        <label>
                            <%=Html.CheckBoxFor(m => m.AutoLogin, new { tabindex = "4"})%>
                            <%=Html.Lang("account.login.auto_login")%>
                        </label>
                    </dd>
                </dl>
                <dl>
                    <dd class="button_panel clearfix">
                        <ul>
                            <li>
                                <button type="submit" name="Ok" value="login" tabindex="7" class="button skyblue" ><%=Html.Lang("account.login.ok")%></button>
                            </li>
                            <li>
                                <button type="button" name="Cancel" value="cancel" tabindex="8" class="button" ><%=Html.Lang("account.login.cancel")%></button>
                            </li>
                        </ul>
                    </dd>
                </dl>
            </form>
        </div>
        <%if (Model.OAuthList.Length>0){ %>
            <div class="box_panel_context form_panel_a button_bar clearfix">
                <ul>
                    <%for (var i = 0; i < Model.OAuthList.Length;i++ ){ %>
                        <li>
                            <a href="<%=Url.Action("OAuthLogin", "Account", new {key=Model.OAuthList[i].Key,url=Model.Url,act="login" })%>">
                                <%if(!string.IsNullOrEmpty(Model.OAuthList[i].Icon)){ %>
                                    <img src="<%=Model.OAuthList[i].Icon %>" alt="<%=Html.Encode(Model.OAuthList[i].Name) %>" title="<%=Html.Encode(Model.OAuthList[i].Name) %>" />
                                <%}else{ %>
                                    <%=Model.OAuthList[i].Name %>
                                <%} %>
                            </a>
                        </li>
                    <%} %>
                </ul>
            </div>
        <%} %>
    </div>
</asp:Content>