﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminUser_Update_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
        <%if (Model.BaseEntity.Id > 0){ %>
            <%=Model.BaseEntity.Username %> 用户编辑
        <%}else{ %>
            创建用户
        <%} %>
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "user"); %>
    <%Html.SetString("menu.b", "user"); %>
</asp:Content>
<asp:Content ContentPlaceHolderID="HeadStyle" runat="server">
    <style type="text/css">
        .gt_ex { display:none;}
    </style>
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
<script type="text/javascript">
    $(document).ready(function () {
    

        function show_group_type(gt){
            $(".gt_ex").hide();
            switch(gt.toString())
            {
                case "0":
                    $(".everyone").show();
                break;
                case "1":
                    $(".admin").show();
                    break;
                case "2":
                    $(".super").show();
                    break;
                case "3":
                    $(".board").show();
                    break;
                case "4":
                    $(".guest").show();
                break;
                case "5":
                    $(".lv").show();
                break;
                case "6":
                    $(".sp").show();
                break;
                case "7":
                    $(".gt_in").show();
                break;
                case "100":
                    $(".founder").show();
                break;
                default:
                    $(".null").show();
                break;
            }
        }
        
        $("select[name=\"group\"]").change(function(){
            var control=$(this);
            var type_value=$(":selected",control).attr("gt");
            show_group_type(type_value);
        }).change();
        
        $("#main_form").ajaxForm({
            beforeSubmit: function (formData, jqForm, options) {
                $('button[name=\"ok\"]').button('loading');

                //                    var title_c = $("form:frist input[name='username']:first");
                //                    if ($.trim(title_c.val()) == '') {
                //                        alert("用户名不可为空");
                //                        title_c.focus();
                //                        return false;
                //                    }

                //                    var passport_c = $("form:frist input[name='password']:first");
                //                    if ($.trim(passport_c.val()) == '') {
                //                        alert("密码不可为空");
                //                        passport_c.focus();
                //                        return false;
                //                    }
                //                    
                //                    var validate_c = $("form:frist input[name='validatecode']");
                //                    if (validate_c.length > 0 && $.trim(validate_c.val()) == '') {
                //                        alert("验证码不可为空");
                //                        validate_c.focus();
                //                        return false;
                //                    }


                return true;
            },
            success: function (data, statusText) {
                if (data.error) {
                    $.jokul.alert(data.description);
                    $('button[name=\"ok\"]').button('reset');
                    return;
                }
                window.location.href = "<%=Url.Action("List") %>";
            },
            error: function () {
                $.jokul.alert("服务器通讯失败");
                $('button[name=\"ok\"]').button('reset');
            },
            url: "<%=Url.Action("User_Update","Handler") %>",
            type: 'post',
            dataType: 'json'
        });
        $("button[name='cancel']").click(function () {
            history.go(-1);
            return false;
        });
        

        $('#tab a').click(function (e) {
            e.preventDefault();
            $(this).tab('show');
        })
    });
</script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

        <div class="area">
            <ul id="tab" class="nav nav-tabs">
                <li class="active"><a href="#base_tab">帐号信息</a></li>
                <li><a href="#rate">用户资料</a></li>
            </ul>
        </div>

            <form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post" class="form-horizontal form-jokul-horizontal">
            <%= Html.ValidationSummary(false, "出现如下问题：", new { @class = "error" })%>
        <div class="tab-content area area-form">
                <%=Html.Hidden("id",Model.BaseEntity.Id) %>
                <div id="base_tab" class="tab-pane active">
                    <%if (Model.BaseEntity.Id > 0){ %>
                        <div class="control-group">
                            <label class="control-label">
                                帐号Id</label>
                            <div class="controls">
                                <%=Model.BaseEntity.Id%>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">
                                帐号</label>
                            <div class="controls">
                                <%=Model.BaseEntity.Username%>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">
                                进级积分</label>
                            <div class="controls">
                                <%=Model.BaseEntity.Credit.ToString("0.##")%>
                                分
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">
                                帖子数</label>
                            <div class="controls">
                                主题:<%=Model.BaseEntity.TopicCount%>
                                ,
                                精华:<%=Model.BaseEntity.PostDigestCount%>
                                ,
                                回复:<%=Model.BaseEntity.PostCount-Model.BaseEntity.TopicCount%>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">
                                注册IP,时间</label>
                            <div class="controls">
                                <%=Model.BaseEntity.CreateIp%> (<%=Html.ForumTime(Model.BaseEntity.CreateDateTime)%>)
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">
                                最后IP,时间</label>
                            <div class="controls">
                                <%=Model.BaseEntity.LastIp%>(<%=Html.ForumTime(Model.BaseEntity.LastDateTime)%>)
                            </div>
                        </div>
                    <%}else{ %>
                        <div class="control-group">
                            <label class="control-label">
                                帐号</label>
                            <div class="controls">
                                <%=Html.TextBox("username") %>
                            </div>
                        </div>
                    <%} %>
                    <div class="control-group">
                        <label class="control-label">
                            分组</label>
                        <div class="controls">
                            <%if (Model.Group.Type == (int)EGroupType.Founder || Model.Group.Type == (int)EGroupType.BoardUser){ %>
                                <%=Html.Hidden("group", Model.BaseEntity.GroupId, new { gt=Model.Group.Type})%>
                                <%=Model.Group.Name %>
                            <%}else{ %>
                                <select name="group">
                                    <option>请选择</option>
                                    <%foreach(var g in Model.Groups){ %>
                                        <option value="<%=g.Id %>" gt="<%=g.Type %>"<%=Model.GroupId==g.Id?" selected=\"selected\"":"" %>><%=g.Name %></option>
                                    <%} %>
                                </select>
                            <%} %>
                        </div>
                    </div>
                    <div class="control-group gt_ex gt_in">
                        <label class="control-label">
                            用户验证方式</label>
                        <div class="controls">
                            <label class="radio">
                                <%=Html.RadioButton("verify", (int)EUserVerify.None, Model.BaseEntity.Verify == (int)EUserVerify.None)%>
                                无
                            </label>
                            <label class="radio">
                                <%=Html.RadioButton("verify", (int)EUserVerify.Admin, Model.BaseEntity.Verify == (int)EUserVerify.Admin)%>
                                人工方式
                            </label>
                        </div>
                    </div>
                </div>
                <div id="rate" class="tab-pane">
                    <div class="control-group">
                        <label class="control-label">
                            联系Email</label>
                        <div class="controls">
                            <%=Html.TextBox("email", Model.BaseEntity.Email, new { size = "50", @class = "text" })%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            昵称</label>
                        <div class="controls">
                            <%=Html.TextBox("Nickname", "", new { size = "50", @class = "text" })%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            性别</label>
                        <div class="controls">
                            <label class="radio">
                                <%=Html.RadioButton("Gender", 0, Model.Extended.Gender == 0)%>
                                未公开
                            </label>
                            <label class="radio">
                                <%=Html.RadioButton("Gender", 0, Model.Extended.Gender > 0)%>
                                男
                            </label>
                            <label class="radio">
                                <%=Html.RadioButton("Gender", 0, Model.Extended.Gender < 0)%>
                                女
                            </label>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            出生日期</label>
                        <div class="controls">
                            <%=Html.TextBox("Birthday", Model.Extended.Birthday, new { size = "50", @class = "text" })%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            地址</label>
                        <div class="controls">
                            <%=Html.TextBox("address", Model.Extended.Address, new { size = "50", @class = "text" })%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            QQ</label>
                        <div class="controls">
                            <%=Html.TextBox("qq", Model.Extended.QQ, new { size = "50", @class = "text" })%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            MSN</label>
                        <div class="controls">
                            <%=Html.TextBox("msn", Model.Extended.MSN, new { size = "50", @class = "text" })%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            个人主页</label>
                        <div class="controls">
                            <%=Html.TextBox("site", Model.Extended.Site, new { size="50",@class="text"})%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            介绍</label>
                        <div class="controls">
                            <%=Html.TextArea("bio", Model.Extended.Bio, new { @class = "editor text", cols = "100", rows = "5" })%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            签名</label>
                        <div class="controls">
                            <%=Html.TextArea("Signature", Model.Extended.Signature, new {@class="editor text", cols="100",rows="5"})%>
                        </div>
                    </div>
                </div>
            <div class="control-group">
                <div class="controls">
                    <button type="submit" name="ok" value="save" class="btn btn-primary" data-loading-text="请稍候..." disabled="disabled" data-cw="保存">加载中...</button>
                    <button type="button" name="cancel" value="cancel" class="btn">返回</button>
                </div>
            </div>
        </div>
            </form>

</asp:Content>
