﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminTopic_UnauditedSearch_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    审核主题
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "topic"); %>
    <%Html.SetString("menu.b", "topic.unaudited"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
    <script type="text/javascript">
        function page(p) {
            $("#form_page input[name='page']").val(p);
            $("#form_page").submit();
        }
        $(document).ready(function () {
            var options = {
                beforeSubmit: function(formData, jqForm, options) {
                    return true;
                },
                success: function(data, statusText) {
                    if (data.error)
                    {
                        alert(data.description);
                        return;
                    }
                    page(<%=Model.PageIndex %>);
                },
                error: function() {
                    alert("服务器通讯失败.");
                },
                url: "<%=Url.Action("Topic_UnauditedSearch_Batch","Handler") %>",
                type: 'post',
                dataType: 'json'
            };
            $("#form_search_list").ajaxForm(options);
        });
    </script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

            <form id="form_page" method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                <%=Html.Hidden("_", DateTime.Now.Ticks.ToString())%>
                <%=Html.Hidden("action", "search")%>
                <%=Html.Hidden("page",Model.PageIndex) %>

                <%=Html.Hidden("topicId",Model.TopicId) %>
                <%=Html.Hidden("title",Model.Title) %>
                <%=Html.Hidden("titleCheck",Model.TitleCheck) %>
                <%=Html.Hidden("boardId",Model.BoardId) %>
                <%=Html.Hidden("audit",Model.Audit) %>
            </form>
            <div id="div_search" class="panel panel-form area">
                <form method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" class="form-horizontal form-jokul-horizontal">
                    <input type="hidden" name="action" value="search" />
                    <%=Html.Hidden("page",0) %>
                    <div class="control-group">
                        <label class="control-label">
                            <%=Html.LabelFor(m => m.UserId)%>
                        </label>
                        <div class="controls">
                            <%=Html.TextBoxFor(m => m.UserId, new { @class = "text" })%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            <%=Html.LabelFor(m => m.Username)%>
                        </label>
                        <div class="controls">
                            <%=Html.TextBoxFor(m => m.Username, new { @class="text"})%>
                            <label class="checkbox inline">
                            <%=Html.CheckBoxFor(m => m.UsernameCheck)%>
                            帖子作者帐号模糊</label>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            版块
                        </label>
                        <div class="controls">
                            <select name="BoardId">
                                <option value="0">全部</option>
                                <%foreach (var b in Model.Boards){ %>
                                    <option value="<%=b.Id %>" <%=Model.BoardId==b.Id?"Selected":"" %>><%=b.Name.PadLeft(b.Name.Length + b.Layer*4, (char)0xA0)%></option>
                                <%} %>
                            </select>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            状态
                        </label>
                        <div class="controls">
                            <select name="Audit">
                                <option value="1"<%=Model.Audit==1?" Selected":"" %>>待审核</option>
                                <option value="2"<%=Model.Audit==2?" Selected":"" %>>已忽略</option>
                            </select>
                        </div>
                    </div>
                    <div class="control-group">
                    <div class="controls">
                        <button type="submit" name="SearchUser" value="search" id="Button_Login" class="btn btn-primary">查询</button>
                    </div>
                    </div>
                </form>
            </div>
                <form id="form_search_list" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post">
                    <div class="area">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th width="100">
                                            选择
                                        </th>
                                        <th width="60">
                                            主题ID
                                        </th>
                                        <th>
                                            主题标题
                                        </th>
                                        <th width="120">
                                            发帖人
                                        </th>
                                        <th width="120">
                                            时间
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <%if (Model.Datas.Count > 0){ %>
                                        <%foreach (var user in Model.Datas)
                                            { %>
                                            <tr>
                                                <th>
                                                    <input type="hidden" name="tids" value="<%=user.Id%>" />
                                                    <%if(Model.Audit==1){ %>
                                                    <label class="radio"><input type="radio" name="m_<%=user.Id%>" value="0" checked="checked" />忽略</label>
                                                    <%} %>
                                                    <label class="radio"><input type="radio" name="m_<%=user.Id%>" value="1" />通过</label>
                                                    <label class="radio"><input type="radio" name="m_<%=user.Id%>" value="2" />删除</label>
                                                </th>
                                                <td>
                                                    <%=user.Id%>
                                                </td>
                                                <td>
                                                    <a href="<%=Url.Action("Show","Topic",new{area="ForumHome",tid=user.Id}) %>" target="_blank"><%=Html.Encode(user.Title)%></a>
                                                </td>
                                                <td>
                                                    <%=user.PostUsername %>
                                                </td>
                                                <td>
                                                    <%=Html.ForumTime(user.PostDatetime).ToString("yyyy-MM-dd HH:mm:ss")%>
                                                </td>
                                            </tr>
                                        <%} %>
                                    <%}else{ %>
                                        <tr>
                                            <td colspan="5">
                                                无相关数据
                                            </td>
                                        </tr>
                                    <%} %>
                                </tbody>
                            </table>
                        </div>
                    <%if (Model.Datas.Count > 0){ %>
                        <div class="area">
                                <button type="submit" name="action" value="action" class="btn btn-primary">提交</button>
                        </div>
                    <%} %>
                </form>
            <div class="pagination area">
                <%
                int tabPageSize=3;
                int pageIndex = (int)Model.PageIndex;
                int pageCount = (int)Model.PageCount;
                int tabPageMin=0;
                int tabPageMax=0;
    
                if (pageCount>tabPageSize*2+1)
                {
                    if (pageIndex-tabPageSize>0)
                    {
                        if (pageIndex+tabPageSize<pageCount)
                        {
                            tabPageMin = pageIndex-tabPageSize;
                            tabPageMax = tabPageMin+tabPageSize*2;
                        }
                        else
                        {
                            tabPageMin = pageCount-tabPageSize*2;
                            tabPageMax = pageCount;
                        }
                    }
                    else
                    {
                        tabPageMin=1;
                        tabPageMax = tabPageSize*2+1;
                    }
                }
                else
                {
                    tabPageMin=1;
                    tabPageMax=pageCount;
                }
                %>
                <ul>
                    <li><a href="javascript:void(0);" onclick="page(1)">«</a></li>
                <%for (var i = tabPageMin; i <= tabPageMax; i++){ %>
                    <%if (pageIndex == i){ %>
                    <li class="active"><a href="#"><%=i %></a></li>
                    <%}else{ %>
                    <li><a href="javascript:void(0);" onclick="javascript:page(<%=i %>)"><%=i %></a></li>
                    <%} %>
                <%} %>
                    <li><a href="javascript:void(0);" onclick="javascript:page(<%=pageCount %>)">»</a></li>
                </ul>
            </div>
</asp:Content>
