﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminTopic_Search_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    批量主题管理
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "topic"); %>
    <%Html.SetString("menu.b", "topic"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
    <script type="text/javascript">
        function page(p) {
            $("#form_page input[name='action']").val("search");
            $("#form_page input[name='page']").val(p);
            $("#form_page").submit();
        }
        $(function () {
            $("button[name='research']").click(function () {
                $("#form_page input[name='action']").val("");
                $("#form_page").submit();
            });
            
            var options = {
                beforeSubmit: function(formData, jqForm, options) {
                    return true;
                },
                success: function(data, statusText) {
                    if (data.error)
                    {
                        alert(data.description);
                        return;
                    }
                    page(<%=Model.PageIndex %>);
                },
                error: function() {
                    alert("服务器通讯失败.");
                },
                url: "<%=Url.Action("Topic_Search_Batch","Handler") %>",
                type: 'post',
                dataType: 'json'
            };
            $("#form_search_list").ajaxForm(options);
        });
    </script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

        <form id="form_page" method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
            <%=Html.Hidden("_", DateTime.Now.Ticks.ToString())%>
            <%=Html.Hidden("action", "search")%>
            <%=Html.Hidden("page",Model.PageIndex) %>

            <%=Html.Hidden("topicId",Model.TopicId) %>
            <%=Html.Hidden("title",Model.Title) %>
            <%=Html.Hidden("titleCheck",Model.TitleCheck) %>
            <%=Html.Hidden("userId",Model.UserId) %>
            <%=Html.Hidden("username",Model.Username) %>
            <%=Html.Hidden("usernameCheck",Model.UsernameCheck) %>
            <%=Html.Hidden("boardId",Model.BoardId) %>
        </form>
        <div id="div_search" class="panel panel-form area"<%=Model.ShowSearch?"":" style=\"display:none;\"" %>>
            <form method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" class="form-horizontal form-jokul-horizontal">
                <%=Html.Hidden("action", "search")%>
                <%=Html.Hidden("_", DateTime.Now.Ticks.ToString())%>
                <%=Html.Hidden("page",0) %>
                <div class="control-group">
                    <label class="control-label">
                        主题ID
                    </label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.TopicId, new {@class="text" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        <%=Html.LabelFor(m => m.Title)%>
                    </label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.Title, new { @class = "text",size="50"  })%>
                        <label class="checkbox inline">
                            <%=Html.CheckBoxFor(m => m.TitleCheck)%>
                            主题标题模糊
                        </label>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        <%=Html.LabelFor(m => m.UserId)%>
                    </label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.UserId, new { @class = "text"  })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        <%=Html.LabelFor(m => m.Username)%>
                    </label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.Username, new { @class = "text",size="50" })%>
                        <label class="checkbox inline">
                            <%=Html.CheckBoxFor(m => m.UsernameCheck)%>
                            作者帐号模糊
                        </label>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        <%=Html.LabelFor(m => m.BoardId)%>
                    </label>
                    <div class="controls">
                        <select name="BoardId">
                            <option value="0">全站</option>
                            <%foreach (var b in Model.Boards){ %>
                                <option value="<%=b.Id %>"<%=Model.BoardId==b.Id?" Selected":"" %>><%=b.Name.PadLeft(b.Name.Length + b.Layer*4, (char)0xA0)%></option>
                            <%} %>
                        </select>
                    </div>
                </div>
                <div class="control-group">
                <div class="controls">
                    <button type="submit" value="search" class="btn btn-primary">查询</button>
                </div>
                </div>
            </form>
        </div>
        <div id="div_search_list"<%=Model.ShowItems?"":" style=\"display:none;\"" %>>
            <form id="form_search_list" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post">
                <div class="area">
                    <button type="button" name="research" value="research" class="btn">重新查询</button>
                </div>
                <div class="area">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="width:30px;">
                                        选择
                                    </th>
                                    <th style="width:60px;">
                                        主题ID
                                    </th>
                                    <th>
                                        主题标题
                                    </th>
                                    <th style="width:120px;">
                                        发帖人
                                    </th>
                                    <th style="width:120px;">
                                        时间
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <%if (Model.Topics.Count > 0){ %>
                                    <%foreach (var user in Model.Topics)
                                        { %>
                                        <tr>
                                            <th>
                                                <input type="checkbox" name="tids" value="<%=user.Id%>" />
                                            </th>
                                            <td>
                                                <%=user.Id%>
                                            </td>
                                            <td>
                                                <a href="<%=Url.Action("Show","Topic",new{area="ForumHome",tid=user.Id}) %>" target="_blank"><%=Html.Encode(user.Title)%></a>
                                            </td>
                                            <td>
                                                <%=user.PostUsername %>
                                            </td>
                                            <td>
                                                <%=Html.ForumTime(user.PostDatetime).ToString("yyyy-MM-dd HH:mm:ss")%>
                                            </td>
                                        </tr>
                                    <%} %>
                                <%}else{ %>
                                    <tr>
                                        <td colspan="5">
                                            无相关数据
                                        </td>
                                    </tr>
                                <%} %>
                            </tbody>
                        </table>
                    </div>
                <%if (Model.Topics.Count > 0){ %>
                    <div class="area clearfix">
                        <div class="fl">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>批量操作</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><label class="radio"><input type="radio" name="method" value="recycle" />将已经选择的主题【删除至回收站】</label></td>
                                    </tr>
                                    <tr>
                                        <td><label class="radio"><input type="radio" name="method" value="delete" />将已经选择的主题【彻底删除】</label></td>
                                    </tr>
                                    <tr>
                                        <td><label class="radio"><input type="radio" name="method" value="ban" />将已经选择的主题【屏蔽】</label></td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <button type="submit" name="action" value="action" class="btn">提交</button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <%} %>
             </form>
            <div class="pagination area">
                <%
                int tabPageSize=3;
                int pageIndex = (int)Model.PageIndex;
                int pageCount = (int)Model.PageCount;
                int tabPageMin=0;
                int tabPageMax=0;
    
                if (pageCount>tabPageSize*2+1)
                {
                    if (pageIndex-tabPageSize>0)
                    {
                        if (pageIndex+tabPageSize<pageCount)
                        {
                            tabPageMin = pageIndex-tabPageSize;
                            tabPageMax = tabPageMin+tabPageSize*2;
                        }
                        else
                        {
                            tabPageMin = pageCount-tabPageSize*2;
                            tabPageMax = pageCount;
                        }
                    }
                    else
                    {
                        tabPageMin=1;
                        tabPageMax = tabPageSize*2+1;
                    }
                }
                else
                {
                    tabPageMin=1;
                    tabPageMax=pageCount;
                }
                %>
                <ul>
                    <li><a href="javascript:void(0);" onclick="page(1)">«</a></li>
                <%for (var i = tabPageMin; i <= tabPageMax; i++){ %>
                    <%if (pageIndex == i){ %>
                    <li class="active"><a href="#"><%=i %></a></li>
                    <%}else{ %>
                    <li><a href="javascript:void(0);" onclick="javascript:page(<%=i %>)"><%=i %></a></li>
                    <%} %>
                <%} %>
                    <li><a href="javascript:void(0);" onclick="javascript:page(<%=pageCount %>)">»</a></li>
                </ul>
            </div>
        </div>
</asp:Content>
