﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminNav_Update_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
                <%if (Model.Entity.Id > 0) { %>
                    编辑
                <%}else{ %>
                    新建
                <%} %>
                导航
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "view"); %>
    <%Html.SetString("menu.b", "nav"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">

<script type="text/javascript">
    $(document).ready(function () {

        $("select[name=\"ctype\"],input[name=\"ctype\"]").change(function () {
            var control = $(this);
            var ctype_value = parseInt(control.val(), 10);
            if (ctype_value>0) {
                $(".custom_url").hide();
            } else {
                $(".custom_url").show();
            }
            $(".ctype_def").hide();
            $(".ctype_" + ctype_value + "_def").show();
        }).change();

        $("#main_form").ajaxForm({
            beforeSubmit: function (formData, jqForm, options) {
                $('button[name=\"ok\"]').button('loading');
                return true;
            },
            success: function (data, statusText) {
                if (data.error) {
                    $.jokul.alert(data.description);
                    $('button[name=\"ok\"]').button('reset');
                    return;
                }
                window.location.href = "<%=Url.Action("List") %>";
            },
            error: function () {
                $.jokul.alert("服务器通讯失败");
                $('button[name=\"ok\"]').button('reset');
            },
            url: "<%=Url.Action("Nav_Update","Handler") %>",
            type: 'post',
            dataType: 'json'
        });

        $("button[name='cancel']").click(function(){
            history.go(-1);
            return false;
        });
    });
</script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">
<form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post" class="form-horizontal form-jokul-horizontal">
<%=Html.Hidden("Id",Model.Entity.Id) %>
            <div class="area area-form">
                <div class="control-group">
                        <label class="control-label">
                            名称
                        </label>
                    <div class="controls">
                        <%=Html.TextBox("Name", Model.Entity.Name, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        地址类型
                    </label>
                    <div class="controls">
                        <select name="ctype">
                            <option value="0">自定义</option>
                            <option value="1"<%=Model.Entity.CType==1?" selected=\"selected\"":"" %>>首页</option>
                            <option value="2"<%=Model.Entity.CType==2?" selected=\"selected\"":"" %>>搜索</option>
                            <option value="3"<%=Model.Entity.CType==3?" selected=\"selected\"":"" %>>帮助</option>
                            <option value="4"<%=Model.Entity.CType==4?" selected=\"selected\"":"" %>>会员列表</option>
                            <option value="5"<%=Model.Entity.CType==5?" selected=\"selected\"":"" %>>手机版</option>
                        </select>
                    <span class="help-block ctype_def ctype_0_def">
                        可自定义或关联到现有的功能
                    </span>
                    <span class="help-block ctype_def ctype_1_def">
                        论坛首页位置
                    </span>
                    <span class="help-block ctype_def ctype_2_def">
                        只有拥有搜索权限的用户才能进入
                    </span>
                    <span class="help-block ctype_def ctype_3_def">
                        论坛的帮助信息链接
                    </span>
                    <span class="help-block ctype_def ctype_4_def">
                        只有拥有查看会员列表权限的用户才能进入
                    </span>
                    <span class="help-block ctype_def ctype_5_def">
                        将电脑版浏览转换为手机版，此连接只有在电脑版界面显示。
                    </span>
                    <span class="help-block ctype_def ctype_6_def">
                        将手机版浏览转换为电脑版，此连接只有在手机版界面显示。
                    </span>
                    </div>
                </div>
                <div class="control-group custom_url">
                        <label class="control-label">
                            自定Url地址
                        </label>
                    <div class="controls">
                        <%=Html.TextBox("url", Model.Entity.Url, new { @class = "text", size = "50" })%>
                        <span class="help-block">
                            自定义链接地址，格式：http://www.jokul.net
                        </span>
                    </div>
                </div>
                <div class="control-group">
                        <label class="control-label">
                            位置
                        </label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("type", 0, Model.Entity.Type == 0)%>页头导航</label>
                        <label class="radio"><%=Html.RadioButton("type", 1, Model.Entity.Type != 0)%>页尾导航</label>
                    </div>
                </div>
                <div class="control-group">
                        <label class="control-label">
                            次序
                        </label>
                    <div class="controls">
                        <%=Html.TextBox("Order", Model.Entity.Order, new { @class = "text", size = "5" })%>
                    </div>
                </div>
                <div class="control-group">
                        <label class="control-label">
                            新窗打开
                        </label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("OpenNew", 1, Model.Entity.OpenNew != 0)%>是</label>
                        <label class="radio"><%=Html.RadioButton("OpenNew", 0, Model.Entity.OpenNew == 0)%>否</label>
                    </div>
                </div>
                <div class="control-group">
                        <label class="control-label">
                            显示
                        </label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("Show", 1, Model.Entity.Show != 0)%>是</label>
                        <label class="radio"><%=Html.RadioButton("Show", 0, Model.Entity.Show == 0)%>否</label>
                    </div>
                </div>
                <div class="control-group">
                <div class="controls">
                    <button type="submit" name="ok" value="save" class="btn btn-primary" data-loading-text="保存中..." disabled="disabled" data-cw="保存">加载中...</button>
                    <button type="button" name="cancel" value="cancel" class="btn">返回</button>
                </div>
                </div>
            </div>
</form>
</asp:Content>
