﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminGroup_List_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    分组管理
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "user"); %>
    <%Html.SetString("menu.b", "group"); %>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

            <div class="area">
                <a href="<%=Url.Action( "Update","Group", new { id = -1 })%>" class="btn btn-primary">添加</a>
            </div>
            <div class="area">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th style="width:40px;">
                                    Id
                                </th>
                                <th style="width:40px;">
                                    图标
                                </th>
                                <th style="width:40px;">
                                    归属
                                </th>
                                <th style="width:80px;">
                                    组类型
                                </th>
                                <th>
                                    组名
                                </th>
                                <th style="width:120px;">
                                    操作
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <%if (Model.List.Count > 0)
                                { %>
                        <%foreach (var user in Model.List)
                            { %>
                            <tr>
                                <th><%=user.Id %></th>
                                <td>
                                    <%if (string.IsNullOrEmpty(user.OnlineImage)) { %>
                                    -
                                    <%}else{ %>
                                    <img src="<%=user.OnlineImage.StartsWith("http://",StringComparison.OrdinalIgnoreCase)?user.OnlineImage: ResolveUrl("../../../../static/images/online/" + user.OnlineImage)%>" />
                                    <%} %>
                                </td>
                                <td>
                                    <%if (user.System > 0){ %>
                                        <span style="color:red;">系统</span>
                                    <%}else{ %>
                                        用户
                                    <%} %>
                                </td>
                                <td>
                                    <%=EnumHelper.GetEnumDescription<EGroupType>(user.Type) %>
                                </td>
                                <td><%=user.Name %>
                                <%if (user.Type == (int)EGroupType.LV){ %>
                                    [<%=user.CreditLower %>~<%=user.CreditHigher %>积分]
                                <%} %>
                                    <%if (!string.IsNullOrEmpty(user.Image)) { %>
                                    <img src="<%=user.Image.StartsWith("http://",StringComparison.OrdinalIgnoreCase)?user.Image: ResolveUrl("../../../../static/images/group/" + user.Image)%>" />
                                    <%} %>
                                </td>
                                <td>
                                    <a href="<%=Url.Action( "Update", new {id=user.Id })%>">编辑</a>
                                    
                                    <%if (!(user.System > 0)){ %>
                                        |
                                        <a href="#" data-redirect="<%=Url.Action("Remove", new { id = user.Id } )%>" data-act="delete">删除</a>
                                    <%} %>
                                </td>
                            </tr>
                        <%} %>
                            <%}
                                else
                                { %>
                            <tr>
                                <td colspan="5">
                                    无数据
                                </td>
                            </tr>
                            <%} %>
                        </tbody>
                    </table>
                </div>
</asp:Content>
