﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminEmotion_SystemEmotionList_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    <%=Model.Category.Name %> 未安装的表情
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "view"); %>
    <%Html.SetString("menu.b", "emotion"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
<script type="text/javascript">
    $(document).ready(function () {

        $("#main_form").ajaxForm({
            beforeSubmit: function (formData, jqForm, options) {
                $('button[name=\"ok\"]').button('loading');
                return true;
            },
            success: function (data, statusText) {
                if (data.error) {
                    $.jokul.alert(data.description);
                    $('button[name=\"ok\"]').button('reset');
                    return;
                }
                window.location.href = "<%=Url.Action("EmotionList",new { category_id=Model.Category.Id}) %>";
            },
            error: function () {
                $.jokul.alert("服务器通讯失败");
                $('button[name=\"ok\"]').button('reset');
            },
            url: "<%=Url.Action("Emotion_Install","Handler") %>",
            type: 'post',
            dataType: 'json'
        });

    });
</script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

            <div class="area">
                <a href="<%=Url.Action( "CategoryList", "Emotion")%>" class="btn">返回表情分类</a>
            </div>
            <form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post">
                <input type="hidden" name="category_id" value="<%=Model.Category.Id %>" />

                    <div class="area">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="span1">
                                        选择
                                    </th>
                                    <th class="span1">
                                        表情
                                    </th>
                                    <th>
                                        简码
                                    </th>
                                    <th>
                                        文件夹名
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <%if (Model.List.Count > 0)
                                    { %>
                                <%var i=0; %>
                            <%foreach (var user in Model.List)
                                { %>
                                <%i++; %>
                                <tr>
                                    <td>
                                        <input type="checkbox" name="index" value="<%=i %>" />
                                        <input type="hidden" name="file_<%=i %>" value="<%=Html.Encode(user) %>" />
                                    </td>
                                    <td>
                                        <img src="<%=ResolveUrl("../../../../static/images/emotion/"+Model.Category.Key+"/" + user)%>" />
                                    </td>
                                    <td><input type="text" name="code_<%=i %>" value="<%=Html.Encode(user) %>" size="20" /></td>
                                    <td><%=user %></td>
                                </tr>
                            <%} %>
                                <%}
                                    else
                                    { %>
                                <tr>
                                    <td colspan="4">
                                        无数据
                                    </td>
                                </tr>
                                <%} %>
                            </tbody>
                        </table>
                    </div>
                <div class="area">
                    <button name="ok" value="install" class="btn btn-primary" data-loading-text="保存中...">安装</button>
                </div>
            </form>
</asp:Content>
