﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminBoard_List_Model>" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">
    版块管理
</asp:Content>
<asp:Content ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "board"); %>
    <%Html.SetString("menu.b", "board"); %>
</asp:Content>
<asp:Content ContentPlaceHolderID="HeadStyle" runat="server">
    <link href="<%=this.ResolveUrl ("../../utility/jquery.treegrid/jquery.treegrid.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../utility/jquery.treegrid/jquery.treegrid.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../utility/jquery.treegrid/jquery.treegrid.bootstrap2.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $('.tree').treegrid({
                expanderExpandedClass: 'icon-minus-sign',
                expanderCollapsedClass: 'icon-plus-sign'
            });
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <%if (Model.List.Count > 0){ %>
    <div class="area">
        <a href="<%=Url.Action( "Update", "Board")%>" class="btn btn-primary">添加</a>
    </div>
    <div class="area">
        <table class="table table-bordered table-hover tree">
            <thead>
                <tr>
                    <th>版块
                    </th>
                    <th class="center" style="width: 220px;">操作
                    </th>
                </tr>
            </thead>
            <tbody>
                <%foreach (var user in Model.List){ %>
                <tr class="treegrid-<%=user.Id %><%if (user.ParentId > 0){%> treegrid-parent-<%=user.ParentId %><%} %>">
                    <td class="middle">
                        <a href="<%=Url.SiteAction("Show", "Board", new { area = "ForumHome", bid = user.Id })%>" target="_blank"><%=user.Name %></a>
                    </td>
                    <td class="center middle">
                        <div class="btn-group">
                            <button type="button" class="btn btn-small" data-act="go" data-redirect="<%=Url.Action("Update", new { id = user.Id })%>">编辑</button>
                            <button type="button" class="btn btn-small" data-act="go" data-redirect="<%=Url.Action("UpdateModerator", new { id = user.Id })%>">版主</button>
                            <button type="button" class="btn btn-small" data-act="go" data-redirect="<%=Url.Action("Move", new { src_id = user.Id,url=Request.Url.AbsoluteUri })%>">移动</button>
                        </div>
                        <button type="button" class="btn btn-small btn-danger" data-act="delete" data-redirect="<%=Url.Action("Remove", new { id = user.Id })%>" data-confirm-message="删除版块将同时删除版块中的帖子，您确定要删除吗?">删除</button>
                    </td>
                </tr>
                <%} %>
            </tbody>
        </table>

    </div>
    <%}else{ %>
    <div class="alert area">
        在这里可以进行论坛的所有版块的管理操作，现在这里还没有任何版块，现在就建立一个版块让用户参与使用吧！
    </div>
    <div class="area">
        <a href="<%=Url.Action( "Update", "Board")%>" class="btn btn-primary">开始添加第一个版块</a>
    </div>
    <%} %>
</asp:Content>
