﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/Home.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Passport.MvcApp.Home.Models.Home_Model>" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">
    首页
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <div class="box_panel sp">
        <div class="box_panel_title clearfix">基本信息</div>
        <div class="box_panel_context form_panel_a">
            <dl>
                <dt>帐号</dt>
                <dd><%=Model.Username%>

                </dd>
                <dt>信箱</dt>
                <dd>
                    <%if (!StringHelper.IsNullOrWhiteSpace(Model.Email)) { %>
                        <%=Model.Email %>[<a href="<%=Url.Action("ChangeEmail","Setting") %>">更改绑定邮箱</a>]
                    <%}else{ %>
                        未设置
                        <div class="control">
                            您可以通过<a href="<%=Url.Action("ChangeEmail","Setting") %>">绑定邮箱</a>来找回账户密码以及可以用来登录账户
                        </div>
                    <%} %>

                </dd>
                <dt>最后登录</dt>
                <dd><%=Model.LastTime.ToString("yyyy-MM-dd HH:mm:ss") %> (IP:<%=Model.LastIp %>)</dd>
            </dl>
        </div>
    </div>
    <div class="box_panel sp">
        <div class="box_panel_title clearfix">安全信息</div>
        <div class="box_panel_context form_panel_a">
            <dl>
                <dt>密码</dt>
                <dd>
                    <%=Html.ActionLink("更改密码","ChangePassword","Setting") %>
                </dd>
                <dt>安全问答</dt>
                <dd>
                    <%if (Model.Question) { %>
                            已经开启
                            [<%=Html.ActionLink("更换", "ChangeQA", "Setting")%>]
                        <%}
                      else { %>
                            未设置，您可以<%=Html.ActionLink("现在设置", "ChangeQA", "Setting")%>，以保护您的帐号安全。
                        <%} %>
                </dd>
            </dl>
        </div>
    </div>
    <%if (Model.Apps.Count > 0) { %>
    <div class="box_panel sp">
        <div class="box_panel_title clearfix">应用</div>
        <div class="box_panel_context form_panel_a">
            <dl>
                <%foreach (ApplicationEntity app in Model.Apps) { %>
                <dt><a href="<%=app.Url %>" target="_blank"><%=app.Name %></a></dt>
                <dd><%=app.Description %></dd>
                <%} %>
            </dl>
        </div>
    </div>
    <%} %>
</div>
</asp:Content>
