﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/Inside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Passport.MvcApp.Admin.Models.Setting_Register_Model>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	注册设置
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "setting"); %>
    <%Html.SetString("menu.b", "setting.register"); %>
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/ckeditor/ckeditor.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/ckeditor/adapters/jquery.js") %>" type="text/javascript"></script>
    
    <script language="javascript">
        $(document).ready(function () {

            var configa = {
                toolbar: [
                    ['Source'], ['Bold', 'Italic', '-', 'NumberedList', 'BulletedList', '-', 'Link', 'Unlink', '-', 'Table', 'Image', 'Flash']
                ],
                resize_enabled: false
            };
            $("textarea.editor").ckeditor(configa);


            $("input[name=\"welcome_msg\"]").change(function () {
                var control = $(this);
                if (!control.is(":checked"))
                    return;
                var val = parseInt(control.val());
                if (val > 0)
                    $(".agreement").show();
                else
                    $(".agreement").hide();
            }).change();

            
            $("#main_form").ajaxForm({
                beforeSubmit: function (formData, jqForm, options) {
                    $('button[name=\"ok\"]').button('loading');
                    return true;
                },
                success: function (data, statusText) {
                    if (data.error) {
                        $.jokul.alert(data.description);
                        return;
                    }
                    $.jokul.alert("保存成功");
                },
                error: function () {
                    $.jokul.alert("服务器通讯失败");
                },
                complete: function () {
                    $('button[name=\"ok\"]').button('reset');
                },
                url: "<%=Url.Action("Setting_Register","Handler") %>",
                type: 'post',
                dataType: 'json'
            });

        });
    </script>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    
        <div class="area area-form">
            <form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post" class="form-horizontal form-jokul-horizontal">
                <div class="control-group">
                    <label class="control-label">
                        允许新用户注册
                    </label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("allow_register",0,Model.AllowRegister== 0)%>不允许</label>
                        <label class="radio"><%=Html.RadioButton("allow_register",1,Model.AllowRegister== 1)%>允许</label>
                    <span class="help-block">如果该项选择为“不允许”，那么将禁止新用户注册，此时如果有用户试图进行注册，则无法注册，同时前台将会有错误提示。</span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        IP注册间隔限制
                    </label>
                    <div class="controls">
                        <%=Html.TextBox("ip_span", Model.IpSpan, new { @class = "text input-mini", size = "5" })%>
                    <span class="help-block">
                        同一 IP 在本时间间隔（单位：分钟）内只能注册一个帐号,0 为不限制。
                    </span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        帐号长度
                    </label>
                    <div class="controls">
                        最小长度：
                        <%=Html.TextBox("username_min", Model.UsernameMin, new { @class = "text input-mini", size = "2" })%>
                        最大长度：
                        <%=Html.TextBox("username_max", Model.UsernameMax, new { @class = "text input-mini", size = "2" })%>
                    <span class="help-block">
                        最小长度需大于0(如果填写小于1的值将默认为1)，最大长度如果设置为0表示不限制
                    </span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        新用户注册验证
                    </label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("activation_verify", (int)EActivationVerify.None, Model.ActivationVerify == (int)EActivationVerify.None)%>无</label>
                        <label class="radio"><%=Html.RadioButton("activation_verify", (int)EActivationVerify.Email, Model.ActivationVerify == (int)EActivationVerify.Email)%>Email</label>
                    <span class="help-block">
                        选择新用户注册验证的激活方式<br />
                        若选择“无”则不进行注册验证。<br />
                        若选择“Email”验证则将会发送验证邮件到用户邮箱,通过验证信箱来激活帐号。
                    </span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">用户帐号保留关键字</label>
                    <div class="controls">
                        <%=Html.TextArea("censor_username", Model.CensorUsername, new { @class = "text", rows = "10", cols = "50" })%>
                    <span class="help-block">注册帐号时不能使用的关键字,每个关键字一行，可使用通配符“*”。</span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">Email 允许地址</label>
                    <div class="controls">
                        <%=Html.TextArea("access_email", Model.AccessEmail, new { @class = "text", rows = "10", cols = "50" })%>
                    <span class="help-block">
                        只允许特定域名结尾的邮箱进行注册, 每行一个域名。<br />
                        例如：@hotmail.com 注意:此项开启时,“Email 禁止地址”项设置无效。
                    </span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">Email 禁止地址</label>
                    <div class="controls">
                        <%=Html.TextArea("censor_email", Model.CensorEmail, new { @class = "text", rows = "10", cols = "50" })%>
                    <span class="help-block">
                        可以限制新用户不得以某些域名结尾的邮箱进行注册，每行一个域名。<br />
                        例如：@hotmail.com 注意：“Email 允许地址”项开启时，此项设置无效。
                    </span>
                    </div>
                </div>
                <div class="control-group">
                        <label class="control-label">
                            注册协议
                        </label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("welcome_msg",0, Model.WelcomeMsg<= 0)%>不启用</label>
                        <label class="radio"><%=Html.RadioButton("welcome_msg", 1,Model.WelcomeMsg> 0)%>启用</label>
                    <span class="help-block">
                        可以选择是否在用户注册时显示注册许可协议</span>
                    </div>
                </div>
                <div class="control-group setNode agreement" style="display:none;">
                        <label class="control-label">注册协议内容</label>
                    <div class="controls">
                        <%=Html.TextArea("welcome_msg_text", Model.WelcomeMsgText, new { @class = "editor", rows = "5", cols = "100" })%>
                    <span class="help-block">
                        填写您的注册许可协议信息。</span>
                    </div>
                </div>
                <div class="control-group">
                <div class="controls">
                    <button type="submit" name="ok" value="save" id="Button_Login" class="btn btn-primary" data-loading-text="保存中...">保存</button>
                </div>
                    </div>
            </form>
        </div>
</asp:Content>
