﻿

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_OAuthUser]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_OAuthUser]
GO
CREATE TABLE [Jokul_Passport_OAuthUser](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[OAuthKey] [nvarchar](16) NOT NULL,
	[UserId] [int] NOT NULL,
	[OpenId] [nvarchar](64) NOT NULL,
	[CreateTime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_OAuthUser] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)

GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_OAuthPlugin]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_OAuthPlugin]
GO
CREATE TABLE [Jokul_Passport_OAuthPlugin](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Key] [nvarchar](16) NOT NULL,
	[Name] [nvarchar](16) NOT NULL,
	[Setting] [ntext] NOT NULL,
	[Library] [nvarchar](256) NOT NULL,
	[Enabled] [tinyint] NOT NULL,
	[Order] [int] NOT NULL,
	[Description] [nvarchar](256) NOT NULL,
	[CreateTime] [datetime] NOT NULL,
	[Icon] [nvarchar](256) NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_OAuthPlugin] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_Application]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_Application]
GO
CREATE TABLE [Jokul_Passport_Application](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Key] [nvarchar](32) NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[Icon] [nvarchar](256) NOT NULL,
	[Url] [nvarchar](1024) NOT NULL,
	[Description] [ntext] NOT NULL,
	[SecurityCode] [nvarchar](64) NOT NULL,
	[Api] [nvarchar](1024) NOT NULL,
	[Show] [bit] NOT NULL,
	[Notify] [tinyint] NOT NULL,
	[Ip] [nvarchar](32) NOT NULL,
	[Format] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_Application] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_FailedLogin]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_FailedLogin]
GO
CREATE TABLE [Jokul_Passport_FailedLogin](
	[Ip] [nvarchar](64) NOT NULL,
	[Count] [int] NOT NULL,
	[DateTime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_FailedLogin] PRIMARY KEY CLUSTERED 
	(
		[Ip] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_Friend]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_Friend]
GO
CREATE TABLE [Jokul_Passport_Friend](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[FriendUserId] [int] NOT NULL,
	[FriendUsername] [nvarchar](32) NOT NULL,
	[DateTime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_Friend] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_FriendInvite]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_FriendInvite]
GO
CREATE TABLE [Jokul_Passport_FriendInvite](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[FriendUserId] [int] NOT NULL,
	[FriendUsername] [nvarchar](32) NOT NULL,
	[Message] [nvarchar](64) NOT NULL,
	[DateTime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_FriendInvite] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	),
	CONSTRAINT [IX_Jokul_Passport_FriendInvite] UNIQUE NONCLUSTERED 
	(
		[UserId] DESC,
		[FriendUserId] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_Group]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_Group]
GO
CREATE TABLE [Jokul_Passport_Group](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[System] [tinyint] NOT NULL,
	[Type] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_Group] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_Log]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_Log]
GO
CREATE TABLE [Jokul_Passport_Log](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Description] [ntext] NOT NULL,
	[CreateTime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_Log] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO


IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_Note]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_Note]
GO
CREATE TABLE [Jokul_Passport_Note](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[State] [tinyint] NOT NULL,
	[AppId] [int] NOT NULL,
	[Operation] [nvarchar](32) NOT NULL,
	[Paramers] [ntext] NOT NULL,
	[CreateDatetime] [datetime] NOT NULL,
	[UpdateDatetime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_Note] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_Setting]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_Setting]
GO
CREATE TABLE [Jokul_Passport_Setting](
	[Variable] [nvarchar](128) NOT NULL,
	[Value] [ntext] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_Settings] PRIMARY KEY CLUSTERED 
	(
		[Variable] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_ShortMessage]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_ShortMessage]
GO
CREATE TABLE [Jokul_Passport_ShortMessage](
	[Id] [bigint] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[Floder] [int] NOT NULL,
	[SenderId] [int] NOT NULL,
	[SenderUsername] [nvarchar](32) NOT NULL,
	[ReceiverId] [int] NOT NULL,
	[ReceiverUsername] [nvarchar](32) NOT NULL,
	[Title] [nvarchar](256) NOT NULL,
	[Message] [nvarchar](2048) NOT NULL,
	[DateTime] [datetime] NOT NULL,
	[New] [tinyint] NOT NULL,
	[Format] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_ShortMessage] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_Skin]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_Skin]
GO
CREATE TABLE [Jokul_Passport_Skin](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Key] [nvarchar](32) NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[Description] [nvarchar](128) NOT NULL,
	[System] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_Skin] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_SystemLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_SystemLog]
GO
CREATE TABLE [Jokul_Passport_SystemLog](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[Username] [nvarchar](32) NOT NULL,
	[Ip] [nvarchar](32) NOT NULL,
	[Action] [nvarchar](64) NOT NULL,
	[DataDescription] [nvarchar](512) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[CreateTime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_SystemLog] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_Unique]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_Unique]
GO
CREATE TABLE [Jokul_Passport_Unique](
	[DataId] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[Type] [tinyint] NOT NULL,
	[Data] [nvarchar](128) NOT NULL,
	[CreateTime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_Unique] PRIMARY KEY CLUSTERED 
	(
		[DataId] DESC
	)
)
GO


IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_User]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_User]
GO
CREATE TABLE [Jokul_Passport_User](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Username] [nvarchar](32) NOT NULL,
	[Password] [nvarchar](32) NOT NULL,
	[GroupId] [int] NOT NULL,
	[CreateIp] [nvarchar](64) NOT NULL,
	[CreateDateTime] [datetime] NOT NULL,
	[LastIp] [nvarchar](64) NOT NULL,
	[LastDatetime] [datetime] NOT NULL,
	[PMCount] [int] NOT NULL,
	[PMNewCount] [int] NOT NULL,
	[Question] [nvarchar](32) NOT NULL,
	[Answer] [nvarchar](32) NOT NULL,
	[Email] [nvarchar](64) NOT NULL,
	[UnevaluatedEmail] [nvarchar](64) NOT NULL,
	[Avatar] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_User] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_VerifyCode]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_VerifyCode]
GO
CREATE TABLE [Jokul_Passport_VerifyCode](
	[Code] [nvarchar](32) NOT NULL,
	[Action] [tinyint] NOT NULL,
	[Data] [ntext] NOT NULL,
	[Expiration] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_VerifyCode] PRIMARY KEY CLUSTERED 
	(
		[Code] DESC
	)
)
GO


IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Passport_Task]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Passport_Task]
GO
CREATE TABLE [Jokul_Passport_Task](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[Library] [nvarchar](256) NOT NULL,
	[LastExecuteTime] [datetime] NOT NULL,
	[Config] [ntext] NOT NULL,
	CONSTRAINT [PK_Jokul_Passport_Task] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO





