﻿
IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Application]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Application]
GO
CREATE TABLE [Jokul_Forum_Application](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Key] [nvarchar](32) NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[Url] [nvarchar](1024) NOT NULL,
	[Description] [ntext] NOT NULL,
	[SecurityCode] [nvarchar](64) NOT NULL,
	[Ip] [nvarchar](32) NOT NULL,
	[Format] [tinyint] NOT NULL,
	[NotifyUrl] [nvarchar](1024) NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Application] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Online]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Online]
GO
CREATE TABLE [Jokul_Forum_Online](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Key] [nvarchar](32) NOT NULL,
	[Image] [nvarchar](256) NOT NULL,
	[Hash] [nvarchar](32) NOT NULL,
	[Ip] [nvarchar](32) NOT NULL,
	[UserId] [int] NOT NULL,
	[GroupId] [int] NOT NULL,
	[Username] [nvarchar](32) NOT NULL,
	[Show] [bit] NOT NULL,
	[Description] [ntext] NOT NULL,
	[CreateTime] [datetime] NOT NULL,
	[UpdateTime] [datetime] NOT NULL,
	[BoardId] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Online] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Advertisement]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Advertisement]
GO
CREATE TABLE [Jokul_Forum_Advertisement](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AllowAvailable] [tinyint] NOT NULL,
	[Type] [tinyint] NOT NULL,
	[Name] [nvarchar](64) NOT NULL,
	[StartTime] [datetime] NOT NULL,
	[EndTime] [datetime] NOT NULL,
	[Target] [nvarchar](512) NOT NULL,
	[Code] [ntext] NOT NULL,
	[IsOverdue] [tinyint] NOT NULL,
	[OverdueCode] [text] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Advertisement] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Announcement]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Announcement]
GO
CREATE TABLE [Jokul_Forum_Announcement](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AllowAvailable] [tinyint] NOT NULL,
	[Title] [nvarchar](64) NOT NULL,
	[StartTime] [datetime] NOT NULL,
	[EndTime] [datetime] NOT NULL,
	[Message] [ntext] NOT NULL,
	[Order] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Announcement] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Attachment]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Attachment]
GO
CREATE TABLE [Jokul_Forum_Attachment](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[BoardId] [int] NOT NULL,
	[TopicId] [int] NOT NULL,
	[PostId] [int] NOT NULL,
	[UploadDatetime] [datetime] NOT NULL,
	[Name] [nvarchar](256) NOT NULL,
	[FileName] [nvarchar](256) NOT NULL,
	[Description] [nvarchar](128) NOT NULL,
	[FileType] [nvarchar](64) NOT NULL,
	[FileSize] [int] NOT NULL,
	[IsImage] [tinyint] NOT NULL,
	[Thumb] [tinyint] NOT NULL,
	[Download] [int] NOT NULL,
	[Cost] [money] NOT NULL,
	[CostType] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Attachment] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_AttachmentBuy]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_AttachmentBuy]
GO
CREATE TABLE [Jokul_Forum_AttachmentBuy](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AttachmentId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[Time] [datetime] NOT NULL,
	[Cost] [money] NOT NULL,
	[CostType] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_AttachmentBuy] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Board]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Board]
GO
CREATE TABLE [Jokul_Forum_Board](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ParentId] [int] NOT NULL,
	[LeftNumber] [int] NOT NULL,
	[RightNumber] [int] NOT NULL,
	[Layer] [int] NOT NULL,
	[ChildCount] [int] NOT NULL,
	[Name] [nvarchar](64) NOT NULL,
	[TodayTopicCount] [int] NOT NULL,
	[TopicCount] [int] NOT NULL,
	[PostCount] [int] NOT NULL,
	[CreateTime] [datetime] NOT NULL,
	[UpdateTime] [datetime] NOT NULL,
	[Icon] [nvarchar](256) NOT NULL,
	[Rule] [ntext] NOT NULL,
	[Description] [ntext] NOT NULL,
	[ChildCol] [smallint] NOT NULL,
	[LastPostUserId] [int] NOT NULL,
	[LastPostUsername] [nvarchar](32) NOT NULL,
	[LastTopicId] [int] NOT NULL,
	[LastTopicTitle] [nvarchar](64) NOT NULL,
	[Url] [nvarchar](256) NOT NULL,
	[Show] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Board] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_BoardActionPoint]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_BoardActionPoint]
GO
CREATE TABLE [Jokul_Forum_BoardActionPoint](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Enable] [int] NOT NULL,
	[BoardId] [int] NOT NULL,
	[GroupId] [int] NOT NULL,
	[ActionId] [int] NOT NULL,
	[Point_1] [money] NOT NULL,
	[Point_2] [money] NOT NULL,
	[Point_3] [money] NOT NULL,
	[Point_4] [money] NOT NULL,
	[Point_5] [money] NOT NULL,
	[Point_6] [money] NOT NULL,
	[Point_7] [money] NOT NULL,
	[Point_8] [money] NOT NULL,
	[Point_9] [money] NOT NULL,
	[Point_10] [money] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_BoardActionPoint] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_BoardExtended]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_BoardExtended]
GO
CREATE TABLE [Jokul_Forum_BoardExtended](
	[BoardId] [int] NOT NULL,
	[ShowTopic] [int] NOT NULL,
	[ShowTopicBoard] [int] NOT NULL,
	[AttachTitle] [nvarchar](32) NOT NULL,
	[TopicType] [int] NOT NULL,
	[SkinId] [int] NOT NULL,
	[Jammer] [bit] NOT NULL,
	[QuicklyReply] [bit] NOT NULL,
	[Recycle] [bit] NOT NULL,
	[DefaultOrderField] [int] NOT NULL,
	[DefaultOrder] [int] NOT NULL,
	[PicStyle] [bit] NOT NULL,
	[SEOKeywords] [nvarchar](256) NOT NULL,
	[SEODescription] [nvarchar](256) NOT NULL,
	[Domain] [nvarchar](16) NOT NULL
	CONSTRAINT [PK_Jokul_Forum_BoardExtended] PRIMARY KEY CLUSTERED 
	(
		[BoardId] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_BoardManagePermission]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_BoardManagePermission]
GO
CREATE TABLE [Jokul_Forum_BoardManagePermission](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[BoardId] [int] NOT NULL,
	[GroupId] [int] NOT NULL,
	[UpdateTopic] [int] NOT NULL,
	[UpdateReply] [int] NOT NULL,
	[DeleteTopic] [int] NOT NULL,
	[DeleteReply] [int] NOT NULL,
	[TopTopic_1] [int] NOT NULL,
	[TopTopic_2] [int] NOT NULL,
	[TopTopic_3] [int] NOT NULL,
	[AuditTopic] [int] NOT NULL,
	[AuditReply] [int] NOT NULL,
	[DigestTopic] [int] NOT NULL,
	[BanTopic] [int] NOT NULL,
	[BanReply] [int] NOT NULL,
	[HighLightTopic] [int] NOT NULL,
	[CloseTopic] [int] NOT NULL,
	[MoveTopic] [int] NOT NULL,
	[DestructionRatePost] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_BoardManagePermission] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_BoardPermission]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_BoardPermission]
GO
CREATE TABLE [Jokul_Forum_BoardPermission](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[BoardId] [int] NOT NULL,
	[GroupId] [int] NOT NULL,
	[VisitBoard] [int] NOT NULL,
	[VisitTopic] [int] NOT NULL,
	[PostTopic] [int] NOT NULL,
	[PostReply] [int] NOT NULL,
	[UploadAttachment] [int] NOT NULL,
	[ViewAttachment] [int] NOT NULL,
	[UpdateMyselfTopic] [int] NOT NULL,
	[UpdateMyselfReply] [int] NOT NULL,
	[DeleteMyselfTopic] [int] NOT NULL,
	[DeleteMyselfReply] [int] NOT NULL,
	[PostBanTopic] [int] NOT NULL,
	[ViewBanTopic] [int] NOT NULL,
	[RateTopic] [int] NOT NULL,
	[RateReply] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_BoardPermission] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_BoardRate]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_BoardRate]
GO
CREATE TABLE [Jokul_Forum_BoardRate](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Inherit] [int] NOT NULL,
	[BoardId] [int] NOT NULL,
	[GroupId] [int] NOT NULL,
	[PointId] [int] NOT NULL,
	[MinValue] [money] NOT NULL,
	[MaxValue] [money] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_BoardRate] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_BoardTopicType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_BoardTopicType]
GO
CREATE TABLE [Jokul_Forum_BoardTopicType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[BoardId] [int] NOT NULL,
	[Order] [int] NOT NULL,
	[Select] [tinyint] NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_BoardTopicType] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Buddy]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Buddy]
GO
CREATE TABLE [Jokul_Forum_Buddy](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[BuddyId] [int] NOT NULL,
	[Description] [nvarchar](256) NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Buddy] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Favorite]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Favorite]
GO
CREATE TABLE [Jokul_Forum_Favorite](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[Type] [tinyint] NOT NULL,
	[ResourceId] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Favorite] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_GradeLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_GradeLog]
GO
CREATE TABLE [Jokul_Forum_GradeLog](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[BoardId] [int] NOT NULL,
	[TopicId] [int] NOT NULL,
	[PostId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[Username] [nvarchar](32) NOT NULL,
	[Credit1] [money] NOT NULL,
	[Credit2] [money] NOT NULL,
	[Credit3] [money] NOT NULL,
	[Credit4] [money] NOT NULL,
	[Credit5] [money] NOT NULL,
	[Credit6] [money] NOT NULL,
	[Credit7] [money] NOT NULL,
	[Credit8] [money] NOT NULL,
	[Credit9] [money] NOT NULL,
	[Credit10] [money] NOT NULL,
	[DateTime] [datetime] NOT NULL,
	[Reason] [nvarchar](1024) NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_GradeLog] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Group]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Group]
GO
CREATE TABLE [Jokul_Forum_Group](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[System] [tinyint] NOT NULL,
	[Type] [tinyint] NOT NULL,
	[CreditLower] [int] NOT NULL,
	[CreditHigher] [int] NOT NULL,
	[Order] [int] NOT NULL,
	[Color] [nvarchar](8) NOT NULL,
	[Image] [nvarchar](256) NOT NULL,
	[OnlineImage] [nvarchar](256) NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Group] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_GroupExtended]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_GroupExtended]
GO
CREATE TABLE [Jokul_Forum_GroupExtended](
	[GroupId] [int] NOT NULL,
	[ViewIpField] [int] NOT NULL,
	[AttachmentExtension] [nvarchar](64) NOT NULL,
	[DayAttachmentSize] [int] NOT NULL,
	[PostIntervalSecond] [int] NOT NULL,
	[Search] [tinyint] NOT NULL,
	[MemberList] [tinyint] NOT NULL,
	[PostCheck] [tinyint] NOT NULL,
	[Cost] [bit] NOT NULL,
	[CostMax] [money] NOT NULL,
	[PostUpdateLog] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_GroupExtended] PRIMARY KEY CLUSTERED 
	(
		[GroupId] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_GroupManagePermission]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_GroupManagePermission]
GO
CREATE TABLE [Jokul_Forum_GroupManagePermission](
	[GroupId] [int] NOT NULL,
	[Nav] [int] NOT NULL,
	[Link] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_GroupManagePermission] PRIMARY KEY CLUSTERED 
	(
		[GroupId] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Help]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Help]
GO
CREATE TABLE [Jokul_Forum_Help](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Title] [nvarchar](64) NOT NULL,
	[Message] [ntext] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Help] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Link]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Link]
GO
CREATE TABLE [Jokul_Forum_Link](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](64) NOT NULL,
	[Logo] [nvarchar](1024) NOT NULL,
	[Url] [nvarchar](1024) NOT NULL,
	[Description] [nvarchar](1024) NOT NULL,
	[Order] [int] NOT NULL,
	[Enabled] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Link] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Log]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Log]
GO
CREATE TABLE [Jokul_Forum_Log](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Description] [ntext] NOT NULL,
	[CreateTime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Log] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_ManageLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_ManageLog]
GO
CREATE TABLE [Jokul_Forum_ManageLog](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Ip] [nvarchar](64) NOT NULL,
	[UserId] [int] NOT NULL,
	[Username] [nvarchar](64) NOT NULL,
	[Action] [tinyint] NOT NULL,
	[Description] [nvarchar](1024) NOT NULL,
	[DateTime] [datetime] NOT NULL,
	[BoardId] [int] NOT NULL,
	[BoardName] [nvarchar](64) NOT NULL,
	[TopicId] [int] NOT NULL,
	[TopicTitle] [nvarchar](64) NOT NULL,
	[PostId] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_ManageLog] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Medal]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Medal]
GO
CREATE TABLE [Jokul_Forum_Medal](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](128) NOT NULL,
	[Image] [nvarchar](256) NOT NULL,
	[Description] [nvarchar](256) NOT NULL,
	[Url] [nvarchar](256) NOT NULL,
	[Available] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Medal] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Moderator]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Moderator]
GO
CREATE TABLE [Jokul_Forum_Moderator](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[BoardId] [int] NOT NULL,
	[GroupId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[Username] [nvarchar](32) NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Moderator] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_MyPost]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_MyPost]
GO
CREATE TABLE [Jokul_Forum_MyPost](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[TopicId] [int] NOT NULL,
	[PostId] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_MyPost] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_MyTopic]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_MyTopic]
GO
CREATE TABLE [Jokul_Forum_MyTopic](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[TopicId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_MyTopic] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Nav]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Nav]
GO
CREATE TABLE [Jokul_Forum_Nav](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Type] [tinyint] NOT NULL,
	[CType] [tinyint] NOT NULL,
	[CId] [int] NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[Url] [nvarchar](256) NOT NULL,
	[Order] [int] NOT NULL,
	[OpenNew] [tinyint] NOT NULL,
	[Show] [tinyint] NOT NULL,
	CONSTRAINT [IX_Jokul_Forum_Nav] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Post_1]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Post_1]
GO
CREATE TABLE [Jokul_Forum_Post_1](
	[Id] [int] NOT NULL,
	[BoardId] [int] NOT NULL,
	[TopicId] [int] NOT NULL,
	[PostUserId] [int] NOT NULL,
	[PostUsername] [nvarchar](64) NOT NULL,
	[PostUserIp] [nvarchar](32) NOT NULL,
	[PostDateTime] [datetime] NOT NULL,
	[Title] [nvarchar](64) NOT NULL,
	[Message] [ntext] NOT NULL,
	[HTML] [tinyint] NOT NULL,
	[Smile] [tinyint] NOT NULL,
	[UBB] [tinyint] NOT NULL,
	[Attachment] [int] NOT NULL,
	[Signature] [tinyint] NOT NULL,
	[Url] [tinyint] NOT NULL,
	[Audit] [tinyint] NOT NULL,
	[First] [tinyint] NOT NULL,
	[Invisible] [tinyint] NOT NULL,
	[Ban] [tinyint] NOT NULL,
	[Grade] [int] NOT NULL,
	[Hide] [tinyint] NOT NULL,
	[UpdateUserId] [int] NOT NULL,
	[UpdateUsername] [nvarchar](32) NOT NULL,
	[UpdateTime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Post_1] PRIMARY KEY CLUSTERED 
	(
		[Id] ASC
	)
)
GO
CREATE NONCLUSTERED INDEX [IX_Jokul_Forum_Post_1_A] ON [Jokul_Forum_Post_1]
(
	[TopicId] ASC,
	[Audit] ASC,
	[Invisible] ASC,
	[Id] ASC
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_PostId]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_PostId]
GO
CREATE TABLE [Jokul_Forum_PostId](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[TopicId] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_PostId] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_PostSubTable]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_PostSubTable]
GO
CREATE TABLE [Jokul_Forum_PostSubTable](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[TopicCount] [int] NOT NULL,
	[PostCount] [int] NOT NULL,
	[CreateDateTime] [datetime] NOT NULL,
	[Avail] [tinyint] NOT NULL,
	[RecyclePost] [int] NOT NULL,
	[UnauditedPost] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_PostSubTable] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_SearchCache]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_SearchCache]
GO
CREATE TABLE [Jokul_Forum_SearchCache](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[KeyWord] [nvarchar](1024) NOT NULL,
	[SearchString] [nvarchar](1024) NOT NULL,
	[Count] [int] NOT NULL,
	[TopicId] [ntext] NOT NULL,
	[CreateDateTime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_SearchCache] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Settings]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Settings]
GO
CREATE TABLE [Jokul_Forum_Settings](
	[Variable] [nvarchar](128) NOT NULL,
	[Value] [ntext] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Settings] PRIMARY KEY CLUSTERED 
	(
		[Variable] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Skin]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Skin]
GO
CREATE TABLE [Jokul_Forum_Skin](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Key] [nvarchar](32) NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[Description] [nvarchar](128) NOT NULL,
	[System] [tinyint] NOT NULL,
	[Changeover] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Skin] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_EmotionCategory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_EmotionCategory]
GO
CREATE TABLE [Jokul_Forum_EmotionCategory](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Key] [nvarchar](32) NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[Order] [int] NOT NULL,
	[Enabled] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_EmotionCategory] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Smile]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Smile]
GO
CREATE TABLE [Jokul_Forum_Smile](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[CategoryId] [int] NOT NULL,
	[Code] [nvarchar](64) NOT NULL,
	[Image] [nvarchar](256) NOT NULL,
	[Enabled] [tinyint] NOT NULL,
	[Order] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Smile] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_StatDay]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_StatDay]
GO
CREATE TABLE [Jokul_Forum_StatDay](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[DateTime] [smalldatetime] NOT NULL,
	[Topic] [int] NOT NULL,
	[Post] [int] NOT NULL,
	[User] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_StatDay] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Statistic]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Statistic]
GO
CREATE TABLE [Jokul_Forum_Statistic](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[LastUserId] [int] NOT NULL,
	[LastUserNickname] [nvarchar](32) NOT NULL,
	[Topic] [int] NOT NULL,
	[Post] [int] NOT NULL,
	[User] [int] NOT NULL,
	[HighestOnline] [int] NOT NULL,
	[HighestOnlineDateTime] [smalldatetime] NOT NULL,
	[TodayTopic] [int] NOT NULL,
	[TodayPost] [int] NOT NULL,
	[TodayUser] [int] NOT NULL,
	[YesterdayTopic] [int] NOT NULL,
	[YesterdayPost] [int] NOT NULL,
	[YesterdayUser] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Statistic] PRIMARY KEY CLUSTERED
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_SystemLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_SystemLog]
GO
CREATE TABLE [Jokul_Forum_SystemLog](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[Username] [nvarchar](32) NOT NULL,
	[Ip] [nvarchar](32) NOT NULL,
	[Action] [nvarchar](64) NOT NULL,
	[DataDescription] [nvarchar](512) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[CreateTime] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_SystemLog] PRIMARY KEY CLUSTERED
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Tag]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Tag]
GO
CREATE TABLE [Jokul_Forum_Tag](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](64) NOT NULL,
	[Count] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Tag] PRIMARY KEY CLUSTERED
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Task]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Task]
GO
CREATE TABLE [Jokul_Forum_Task](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[Library] [nvarchar](256) NOT NULL,
	[LastExecuteTime] [datetime] NOT NULL,
	[Config] [ntext] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Task] PRIMARY KEY CLUSTERED
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Topic]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Topic]
GO
CREATE TABLE [Jokul_Forum_Topic](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[BoardId] [int] NOT NULL,
	[TopicTypeId] [int] NOT NULL,
	[Title] [nvarchar](64) NOT NULL,
	[ViewCount] [int] NOT NULL,
	[ReplayCount] [int] NOT NULL,
	[TodayReplayCount] [int] NOT NULL,
	[Attachment] [int] NOT NULL,
	[TagCount] [int] NOT NULL,
	[PostUserId] [int] NOT NULL,
	[PostUsername] [nvarchar](32) NOT NULL,
	[PostDatetime] [datetime] NOT NULL,
	[LastPostId] [int] NOT NULL,
	[LastPostDatetime] [datetime] NOT NULL,
	[LastPostUserId] [int] NOT NULL,
	[LastPostUsername] [nvarchar](32) NOT NULL,
	[Digest] [tinyint] NOT NULL,
	[Top] [tinyint] NOT NULL,
	[Audit] [tinyint] NOT NULL,
	[Invisible] [tinyint] NOT NULL,
	[PostSubTable] [int] NOT NULL,
	[HighLight] [nvarchar](32) NOT NULL,
	[Close] [tinyint] NOT NULL,
	[FormId] [int] NOT NULL,
	[Ban] [tinyint] NOT NULL,
	[LastModId] [int] NOT NULL,
	[Cover] [tinyint] NOT NULL,
	[Rate] [money] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Topic] PRIMARY KEY CLUSTERED
	(
		[Id] DESC
	)
)
GO


IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_TopicTag]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_TopicTag]
GO
CREATE TABLE [Jokul_Forum_TopicTag](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[TopicId] [int] NOT NULL,
	[TagId] [int] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_TopicTag] PRIMARY KEY CLUSTERED
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_User]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_User]
GO
CREATE TABLE [Jokul_Forum_User](
	[DataId] [int] IDENTITY(1,1) NOT NULL,
	[Id] [int] NOT NULL,
	[Username] [nvarchar](32) NOT NULL,
	[Email] [nvarchar](64) NOT NULL,
	[CreateIp] [nvarchar](64) NOT NULL,
	[CreateDateTime] [datetime] NOT NULL,
	[LastIp] [nvarchar](64) NOT NULL,
	[LastDatetime] [datetime] NOT NULL,
	[GroupId] [int] NOT NULL,
	[TemplateId] [int] NOT NULL,
	[LastPostDateTime] [datetime] NOT NULL,
	[Credit] [money] NOT NULL,
	[Credit1] [money] NOT NULL,
	[Credit2] [money] NOT NULL,
	[Credit3] [money] NOT NULL,
	[Credit4] [money] NOT NULL,
	[Credit5] [money] NOT NULL,
	[Credit6] [money] NOT NULL,
	[Credit7] [money] NOT NULL,
	[Credit8] [money] NOT NULL,
	[Credit9] [money] NOT NULL,
	[Credit10] [money] NOT NULL,
	[LastActivity] [datetime] NOT NULL,
	[TopicCount] [int] NOT NULL,
	[PostCount] [int] NOT NULL,
	[PostDigestCount] [int] NOT NULL,
	[Medal] [ntext] NOT NULL,
	[OnlineTime] [int] NOT NULL,
	[OnlineUpdateTime] [datetime] NOT NULL,
	[Verify] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_User] PRIMARY KEY CLUSTERED
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_UserExtended]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_UserExtended]
GO
CREATE TABLE [Jokul_Forum_UserExtended](
	[UserId] [int] NOT NULL,
	[QQ] [nvarchar](16) NOT NULL,
	[MSN] [nvarchar](32) NOT NULL,
	[Gender] [int] NOT NULL,
	[Birthday] [nvarchar](16) NOT NULL,
	[Bio] [nvarchar](128) NOT NULL,
	[Address] [nvarchar](64) NOT NULL,
	[Site] [nvarchar](128) NOT NULL,
	[Signature] [nvarchar](128) NOT NULL,
	[Nickname] [nvarchar](16) NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_UserExtended] PRIMARY KEY CLUSTERED
	(
		[UserId] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Word]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Word]
GO
CREATE TABLE [Jokul_Forum_Word](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[FindWord] [nvarchar](256) NOT NULL,
	[ReplaceWord] [nvarchar](256) NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Word] PRIMARY KEY CLUSTERED
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_TaskQueueService]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_TaskQueueService]
GO
CREATE TABLE [Jokul_Forum_TaskQueueService](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[instance] [int] NOT NULL,
	[instance_token] [nvarchar](32) NOT NULL,
	[last_time] [datetime] NOT NULL,
	[token] [nvarchar](32) NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_TaskQueueService] PRIMARY KEY CLUSTERED
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_TaskQueue]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_TaskQueue]
GO
CREATE TABLE [Jokul_Forum_TaskQueue](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[instance] [int] NOT NULL,
	[instance_token] [nvarchar](32) NOT NULL,
	[token] [nvarchar](32) NOT NULL,
	[create_time] [datetime] NOT NULL,
	[type] [nvarchar](256) NOT NULL,
	[data] [ntext] NOT NULL,
	[shape] [ntext] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_TaskQueue] PRIMARY KEY CLUSTERED
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_Plugin]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_Plugin]
GO
CREATE TABLE [Jokul_Forum_Plugin](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Version] [nvarchar](16) NOT NULL,
	[Key] [nvarchar](32) NOT NULL,
	[Setting] [ntext] NOT NULL,
	[Name] [nvarchar](32) NOT NULL,
	[Description] [nvarchar](256) NOT NULL,
	[Order] [int] NOT NULL,
	[Enabled] [tinyint] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_Plugin] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_RateSnapshot]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_RateSnapshot]
GO
CREATE TABLE [Jokul_Forum_RateSnapshot](
	[PostId] [int] NOT NULL,
	[Data] [ntext] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_RateSnapshot] PRIMARY KEY CLUSTERED 
	(
		[PostId] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_RateUser]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_RateUser]
GO
CREATE TABLE [Jokul_Forum_RateUser](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[PostId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[Username] [nvarchar](32) NOT NULL,
	[Credit1] [money] NOT NULL,
	[Credit2] [money] NOT NULL,
	[Credit3] [money] NOT NULL,
	[Credit4] [money] NOT NULL,
	[Credit5] [money] NOT NULL,
	[Credit6] [money] NOT NULL,
	[Credit7] [money] NOT NULL,
	[Credit8] [money] NOT NULL,
	[Credit9] [money] NOT NULL,
	[Credit10] [money] NOT NULL,
	[Time] [datetime] NOT NULL,
	[Count] [int] NOT NULL,
	[Reason] [nvarchar](256) NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_RateUser] PRIMARY KEY CLUSTERED 
	(
		[Id] DESC
	)
)
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_Forum_RatePost]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [Jokul_Forum_RatePost]
GO
CREATE TABLE [Jokul_Forum_RatePost](
	[PostId] [int] NOT NULL,
	[UserCount] [int] NOT NULL,
	[RateCount] [int] NOT NULL,
	[Credit1] [money] NOT NULL,
	[Credit2] [money] NOT NULL,
	[Credit3] [money] NOT NULL,
	[Credit4] [money] NOT NULL,
	[Credit5] [money] NOT NULL,
	[Credit6] [money] NOT NULL,
	[Credit7] [money] NOT NULL,
	[Credit8] [money] NOT NULL,
	[Credit9] [money] NOT NULL,
	[Credit10] [money] NOT NULL,
	[Time] [datetime] NOT NULL,
	CONSTRAINT [PK_Jokul_Forum_RatePost] PRIMARY KEY CLUSTERED 
	(
		[PostId] DESC
	)
)
GO
