﻿

-- sqlserver 2000 或 更高

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_FN_Split]') AND xtype in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [Jokul_FN_Split]
GO

if exists (select * from sysobjects where id = object_id(N'[Jokul_SP_DeleteDefault]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [Jokul_SP_DeleteDefault]
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_SP_TextReplace]') AND xtype in (N'P', N'PC'))
DROP PROCEDURE [Jokul_SP_TextReplace]
GO

CREATE FUNCTION [Jokul_FN_Split]
(
    @Input nvarchar(4000), -- 输入字符串
    @Separator nvarchar(4000) = ',' -- 分隔符
)
RETURNS 
@Result TABLE 
(
    Value nvarchar(4000)
)
AS
BEGIN

if @Input='' Return

DECLARE @InputLength int;
SET @InputLength = datalength(@Input)/2;
DECLARE @SeparatorLength int;
SET @SeparatorLength = datalength(@Separator)/2;
DECLARE @LastIndex int;
SET @LastIndex = 0;
DECLARE @CurrentIndex int;
SET @CurrentIndex = -1;

WHILE @CurrentIndex != 0
BEGIN
    SET @CurrentIndex = CHARINDEX(@Separator, @Input, @LastIndex );

    IF @CurrentIndex != 0
begin

        INSERT @Result
        (
            Value
        )
        VALUES
        (
            SUBSTRING(@Input, @LastIndex, @CurrentIndex - @LastIndex)
        )
end
    ELSE
begin

        INSERT @Result
        (
            Value
        )
        VALUES
        (
            SUBSTRING(@Input, @LastIndex, @InputLength + 1 - @LastIndex)
        )
end
    SET @LastIndex = @CurrentIndex + @SeparatorLength;
END

RETURN 

END
GO

CREATE PROCEDURE [Jokul_SP_DeleteDefault]
@tableName nvarchar(128),
@columnName nvarchar(128)
AS

declare @defname varchar(128)
declare @cmd varchar(128)

select @defname = name FROM sysobjects A JOIN sysconstraints sc ON A.id = sc.constid WHERE object_name(A.parent_obj) = @tableName AND A.xtype = 'D'AND sc.colid =(SELECT colid FROM syscolumns WHERE id = object_id(@tableName) AND name = @columnName)
select @cmd='alter table '+ @tableName+ ' drop constraint '+ @defname if @cmd is null print 'No default constraint to drop'exec (@cmd)
GO

CREATE   PROCEDURE [Jokul_SP_TextReplace]
 @TableStr Varchar(1000),
 @PKField Varchar(1000),
 @FieldStr Varchar(1000),
 @SourceStr Varchar(1000),
 @ReplaceStr Varchar(1000)
AS
BEGIN

declare @SqlStr nvarchar(4000)
set @SqlStr = ''

--定义替换的字符串
set @SqlStr = @SqlStr + ' declare @s_str varchar(8000);'
set @SqlStr = @SqlStr + ' declare @r_str varchar(8000);'
set @SqlStr = @SqlStr + ' select @s_str='''+@SourceStr+''';' --要替换的字符串
set @SqlStr = @SqlStr + ' select @r_str='''+@ReplaceStr+''';' --替换成的字符串

--替换处理
set @SqlStr = @SqlStr + ' declare @id int;'
set @SqlStr = @SqlStr + ' declare @ptr varbinary(16);'
set @SqlStr = @SqlStr + ' declare @start int;'
set @SqlStr = @SqlStr + ' declare @s nvarchar(4000),@len int;'
set @SqlStr = @SqlStr + ' declare @s_str1 nvarchar(4000);'
set @SqlStr = @SqlStr + ' declare @s_len int;'
set @SqlStr = @SqlStr + ' declare @i int;'
set @SqlStr = @SqlStr + ' declare @step int;'

set @SqlStr = @SqlStr + ' select @s_str1=reverse(@s_str),@s_len=len(@s_str)'
set @SqlStr = @SqlStr + ' ,@step=case when len(@r_str)>len(@s_str)'
set @SqlStr = @SqlStr + ' then 4000/len(@r_str)*len(@s_str)'
set @SqlStr = @SqlStr + ' else 4000 end;'

set @SqlStr = @SqlStr + ' declare tb cursor local for'
set @SqlStr = @SqlStr + ' select ['+@PKField+'],start=charindex(@s_str,['+@FieldStr+'])-1'
set @SqlStr = @SqlStr + ' from ['+@TableStr+']'
set @SqlStr = @SqlStr + ' where charindex(@s_str,['+@FieldStr+'])>0;'
--这里可以定义要处理的记录的条件

set @SqlStr = @SqlStr + ' open tb'
set @SqlStr = @SqlStr + ' fetch tb into @id,@start'
set @SqlStr = @SqlStr + ' while @@fetch_status=0'
set @SqlStr = @SqlStr + ' begin'
set @SqlStr = @SqlStr + ' select @ptr=textptr(['+@FieldStr+']),@s=substring(['+@FieldStr+'],@start+1,@step)'
set @SqlStr = @SqlStr + ' from ['+@TableStr+']'
set @SqlStr = @SqlStr + ' where ['+@PKField+']=@id;'

set @SqlStr = @SqlStr + ' while len(@s)>=@s_len'
set @SqlStr = @SqlStr + ' begin'
set @SqlStr = @SqlStr + ' select @len=len(@s),@i=charindex(@s_str1,reverse(@s))'
set @SqlStr = @SqlStr + ' if @i>0'
set @SqlStr = @SqlStr + ' begin'
set @SqlStr = @SqlStr + ' select @i=case when @i>=@s_len then @s_len else @i end'
set @SqlStr = @SqlStr + ' ,@s=replace(@s,@s_str,@r_str)'
set @SqlStr = @SqlStr + ' updatetext ['+@TableStr+'].['+@FieldStr+'] @ptr @start @len @s'
set @SqlStr = @SqlStr + ' end'
set @SqlStr = @SqlStr + ' else'
set @SqlStr = @SqlStr + ' set @i=@s_len'
set @SqlStr = @SqlStr + ' select @start=@start+len(@s)-@i+1'
set @SqlStr = @SqlStr + ' ,@s=substring(['+@FieldStr+'],@start+1,@step)'
set @SqlStr = @SqlStr + ' from ['+@TableStr+']'
set @SqlStr = @SqlStr + ' where ['+@PKField+']=@id'
set @SqlStr = @SqlStr + ' end'
set @SqlStr = @SqlStr + ' fetch tb into @id,@start'
set @SqlStr = @SqlStr + ' end'
set @SqlStr = @SqlStr + ' close tb;'
set @SqlStr = @SqlStr + ' deallocate tb;'

EXECUTE sp_executesql @SqlStr 

end
GO


--2005及以上版本及windows azure使用
IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Jokul_SP_DropIndex]') AND xtype in (N'P', N'PC'))
DROP PROCEDURE [Jokul_SP_DropIndex]
GO
CREATE PROCEDURE [Jokul_SP_DropIndex]
@tbName varchar(256)=null
AS

IF @tbName is null
begin
     raiserror('必须提供@tbName参数',12,1)
     return
end


DECLARE @t_dropindex TABLE 
(
   id int identity,
   index_name varchar(50),
   index_description varchar(1000),
   index_keys varchar(100)
);

INSERT @t_dropindex(index_name,index_description,index_keys) 
EXEC sp_helpindex @tbName

declare @i int,@sql varchar(100)
set @i=1

while @i<=(SELECT max(id) from @t_dropindex)
begin
      if exists(SELECT 1 
                from sysobjects A 
                join @t_dropindex B on A.name=B.index_name
                where B.id=@i and A.xtype in ('PK','UQ'))
      begin
           SELECT @sql='alter table '+@tbName+' drop constraint '
                       +(select index_name from @t_dropindex where id=@i)
           exec(@sql)
      end
      else
      begin
           SELECT @sql='drop index '+@tbName+'.'
                       +(SELECT index_name from @t_dropindex where id=@i)
           exec(@sql)
      end
 
      set @i=@i+1
end

go

