# Project Screenshot

![vet-management-system vercel app_dashboard (1)](https://github.com/JohnMwendwa/vet-management-system/assets/72663882/104f8d8d-6309-48a7-8a70-3047f3a7103a)

## Technologies Used <img src="https://raw.githubusercontent.com/Tarikul-Islam-Anik/Animated-Fluent-Emojis/master/Emojis/Objects/Hammer%20and%20Wrench.png" alt="Hammer and Wrench" width="30" height="30" />

- Material-tailwind/react (UI)
- Next.js (Full stack app)
- Next-auth (Authorization & Authentication)
- MongoDB (Storage of app data)
- Faker-js (Dummy data)
- Nodemailer (Sending emails)
- Mongoose (Database schema)
- Bcrypt (Hashing passwords before they're stored in the database)
- Fullcalendar (Booking and keeping track of appointments)

This is a [Next.js](https://nextjs.org/) project bootstrapped with [`create-next-app`](https://github.com/vercel/next.js/tree/canary/packages/create-next-app).

## Getting Started <img src="https://raw.githubusercontent.com/Tarikul-Islam-Anik/Animated-Fluent-Emojis/master/Emojis/Travel%20and%20places/Parachute.png" alt="Parachute" width="30" height="30" />

First, install the dependencies

```bash
npm install
```

Then create a `.env.local` file with the following environment variables

```bash
LOCAL_URL=Your Local mongoDB URL
MONGO_URL=Production mongoDB URL
NEXTAUTH_URL=http://localhost:3000/ | YOUR APP STARTING POINT URL
NEXTAUTH_SECRET=Secret to hash your tokens
```

Before running the app, ensure your local mongodb server is running or skip this part if you're using an online database

```bash
# In your command-line, go to where your mongodb bin is installed by running the following command (Tweak in accordance with your mongodb installation folder)

cd ../../mongodb/bin

# Then start the mongodb server by running the following command

net start mongodb

```

Then, run the development server:

```bash
npm run dev
# or
yarn dev
# or
pnpm dev
# or
bun dev
```

Open [http://localhost:3000](http://localhost:3000) with your browser to see the result.

This project uses [`next/font`](https://nextjs.org/docs/basic-features/font-optimization) to automatically optimize and load Inter, a custom Google Font.

## User Roles and permissions

The app has 3 types of users, namely :

1.  Doctors
2.  Nurses
3.  Clients

Upon creating an account (by signing up), the default role assigned to the newly created account is that of a client.

The 3 users have the following permissions:

I. Doctor

- A doctor has full admin rights to **CREATE**, **EDIT**, **DELETE** a user account, and can assign any role to that account i.e, the doctor can assign that newly created account the role of a doctor, nurse or client.

- A doctor also has full admin rights to **ADD**, **EDIT** and **REMOVE** employees

II. Nurses

- Nurses still don't have any admin rights at the moment but that is bound to change in the future. They only have the permission to edit their details i.e they can **EDIT** and **DELETE** their user details but can't change their roles.

III. Client

- Clients don't posses any admin rights but can only **CREATE**, **EDIT** and **DELETE** their accounts whenever they wish to.

## How to assign yourself **Full Admin Rights**

Once you fork this repo, signup atleast one account and then go to your database and change the role of that account to "doctor" and that's it, you have full admin rights.

## Learn More <img src="https://raw.githubusercontent.com/Tarikul-Islam-Anik/Animated-Fluent-Emojis/master/Emojis/Objects/Open%20Book.png" alt="Open Book" width="25" height="25" />

To learn more about Next.js, take a look at the following resources:

- [Next.js Documentation](https://nextjs.org/docs) - learn about Next.js features and API.
- [Learn Next.js](https://nextjs.org/learn) - an interactive Next.js tutorial.

You can check out [the Next.js GitHub repository](https://github.com/vercel/next.js/) - your feedback and contributions are welcome!

## Deploy on Vercel <img src="https://raw.githubusercontent.com/Tarikul-Islam-Anik/Animated-Fluent-Emojis/master/Emojis/Travel%20and%20places/Rocket.png" alt="Rocket" width="30" height="30" />

The easiest way to deploy your Next.js app is to use the [Vercel Platform](https://vercel.com/new?utm_medium=default-template&filter=next.js&utm_source=create-next-app&utm_campaign=create-next-app-readme) from the creators of Next.js.

Check out our [Next.js deployment documentation](https://nextjs.org/docs/deployment) for more details.
