# Flexbox Practice excercises

I created this repo with the intention of practicing how much of **flexbox** I have mastered in order to create layouts, and style components using the CSS flexbox.

Halfway I thought why not allow other developers to showcase their flexbox mastery too.

## How To Contribute

1. Fork the repo
2. Create a new folder in the root directory and add your flex project files there.
3. After you've finished your project, add the link to your project file in the root index.html file using the following format.

```html
...

<li class="nav__item">
  <a href="equal-height-cards/index.html" class="nav__link">
    Create cards with equal heights
  </a>
</li>

...
```

**CAUTION!!!** : Ensure you do not add a forward slash ( / ) at the beginning of href link, otherwise the link to your project won't work!.

4. You can append your name to the end of the link so others can know you created the project or search for you e.g

```html
<li class="nav__item">
  <a href="equal-height-cards/index.html" class="nav__link">
    Create cards with equal heights - John Mwendwa
  </a>
</li>
```

5. Try to use only flexbox for your layouts and design to see how much you've mustered it.

6. If you also want to showcase your CSS **grid** mastery, checkout my other repo on CSS grid and be sure to contribute here 👉
   https://github.com/JohnMwendwa/grid-practice-excercises

7. Don't forget to star the repo 😎

## Word to designers !

If you have an extremely good eye for design, you can alter the root style.css stylesheet. Although all your alterations are not always guaranteed to be merged but it's always worth the effort.

## LIVE DEMO

https://johnmwendwa.github.io/flexbox-practice-excercises
