package pm;

public class Exam5 {

	public static void main(String[] args) {
		/* 스레드 Thread
		 * 규모가 작은 프로젝트라도 스레드를 사용하지 않을 때가 거의 없을 정도로 쓰임새가 매우 많으므로 꼭 이해하자
		 
		 * 스레드란 ?
		 * 프로그램을 작성하다보면 어쩔 수 없이 동시에 수행해야 하는 일들이 있음
		 * 예를 들어 비디오 재생 프로그램을 만든다고 할 때 화면 재생과 오디오 재생이 동시에 실행되어야 함
		 * 이렇게 여러 개의 작업이 동시에 수행되도록 하기 위해서 한정된 cpu를 여러 개의 작업으로 나누어 사용해야 하는데
		 * 이것이 바로 스레드임
		 
		 * 프로그램 & 프로세스 & 스레드
		 * 프로그램은 하드에 저장된 파일들의 모음
		 * 프로세스는 메모리 상에 로딩된 프로그램
		 * 멀티 프로세스는 동일한 프로그램을 메모리에 2번 이상 로딩
		 
		 * 스레드
		 * CPU 를 사용하는 최소 단위
		 * 프로세스만 CPU를 사용할 수 있는데 자세히 보면 실제 CPU를 사용하는 것은 프로세스 내부의 스레드임
		  
		 * 자바에서의 스레드
		 * 프로그램이 메모리로 로딩되고 그 로딩된 프로세스의 내부에는 스레드가 있음
		 * 자바로 작성한 프로그램을 실행하면 메모리로 로딩되어 프로세스 상태가 됨
		 * .class를 실행하면 자바 가상 머신 (JVM)은 main 스레드를 생성함
		 * 즉 프로그램이 처음 실행되면 시작 시점에 main 스레드 하나만 존재함
		 * main() 메서드에서 작성한 내용이 바로 main 스레드에서 동작함
		 * 그런데 만약 main 스레드의 내부에서 2개의 스레드를 생성해서 
		 * 실행하면 동시에 2개의 스레드가 동작하게 되는데 이것을 멀티 스레드 프로세스라 함
		  
		 * 멀티 스레드의 필요성
		 * 스레드는 CPU를 사용하는 최소단위라고 위에서 말했음
		 * 그러면 멀티 스레드는 2개 이상의 스레드가 동시에 CPU를 사용한다는 의미
		 * 멀티 스레드가 필요한 이유가 무엇일까?
		 * 비디오와 자막을 화면에 동시에 출력할 때를 생각해보자
		 * 자막은 비디오 프레임에 맞춰 출력되어야 함
		 * 만약 단일 스레드로 두 개의 작업을 처리하면 각각의 작업은 순차적으로 처리됨
		 * 먼저 시작된 작업이 완전히 종료가 된 후에야 두 번째 작업이 실행됨
		 * 하지만 멀티스레드는 동시성 또는 병렬성을 가지고 처리됨
		 */
		
		int[] intArray = {1,2,3,4,5}; // 비디오 프레임
		String[] strArray = {"하나", "둘", "삼", "넷", "오"};
		
		for (int a : intArray) {
			System.out.println("비디오프레임" + a);
		}
		
		for (String b : strArray) {
			System.out.println("자막번호" + b);
		}

	}

}

/* 스레드 생성 방법
* 2가지 방법
* 1. 스레드를 클래스를 상속받아 run() 매서드를 오버라이딩하는 방법
* 2. 1단계 - Runnable 인터페이스를 구현 Runnable 객체를 생성함
*    2단계 - 스레드 객체를 생성할 때 1단계에서 생성한 Runnable 객체를 생성자에 전달해줌
* 사실 두 가지 생성방법 모두 run() 매서드를 재정의하여 스레드 객체를 생성함

* 스레드 실행 방법
* 객체를 어떤 방법으로 실행하든 스레드 객체 내의 start() 매서드를 호출함
* 여기서 재정의한 매서드는 run() 인데 run() 의 내용을 실행하기 위해서는 반드시
* start() 매서드를 호출해야 한다는 것을 명심하자 
* 주의할 점은 start() 매서드로 한 번 실행된 스레드 객체는 재사용할 수 없음
* 만약 다시 실행하려면 객체를 다시 생성해야만 함
* 
*/