package pm;

public class Exam5 {

	public static void main(String[] args) {
		// 객체의 타입 변환

		/* 기본 자료형에서 봤듯이 자바는 '=' 을 사용하여 왼쪽과 오른쪽의 자료형이 일치해야함
		 * 만약 자료형이 다르면 자바가 자동으로 타입을 변환해주거나
		 * 개발자가 명시적으로 타입을 변환해야 함
		 * 객체도 마찬가지로 타입 변환이 일어날 수 있음
		 *
		 * 객체에서는 자식 클래스에서 부모 클래스 쪽으로 변환되는 것이 업캐스팅
		 * 그 반대는 다운 캐스팅임
		 * 객체는 항상 업캐스팅은 할 수 있으므로 명시적으로 적어주지 않아도 자바가 대신해줌
		 * 
		 * 하지만 객체 명시적으로 적어줟 다운 캐스팅 자체가 안 될 때가 있음
		 * 잘못된 다운 캐스팅을 수행하면 ClassCastException이 발생하고 프로그램이 종료됨
		 * 
		 * 사람 	학생은 사람이다. (always OK)	업캐스팅
		 * 학생	사람은 학생이다. (not always) 다운캐스팅
		 * 
		 * 사람 human1 = new 사람(); < 학생과 학생이 아닌 사람 모두 포함되는 사람 객체
		 * 사람 human2 = new 학생(); < 학생인 사람 객체
		 * 
		 * 사람() 생성자를 이용해 객체를 생성하고 사람 자료형에 대입함
		 * 학생() 생성자를 이용하여 객체를 생성하고 역시 사람 자료형에 대입함
		 * 둘 다 사람 타입의 자료형이나 내용은 다름
		 * 첫 번째 human1 객체는 사람 클래스로 만들었기 때문에 여기에는 사람의 공통된 속성과 기능들을 가짐
		 * 반면에 human2는 실제 학생() 생성자로 객체를 생성했으므로 객체 내부에는 사람의 공통된
		 * 특성 뿐만 아니라 학생만의 속성과 기능들이 포함되어 있음. 다라서 human2도 사람 자료형으로
		 * 저장되어있으나 학생으로 다운캐스팅이 가능함
		 * 
		 * class A {} // 할아버지
		 * class B extends A {} // 아버지
		 * class C extends B {} // 손자
		 * 
		 * 업캐스팅 // 학생은 언제나 사람이 될 수 있음
		 * B b1 = new B();
		 * A a1 = (A) b1;
		 * 
		 * C c2 = new C();
		 * B b2 = (B) c2;		// B b2 = c2;
		 * A a2 = (A) c2;		// A a2 = c2;
		 * 
		 * 다운 캐스팅 // 사람이 언제나 학생이 되는 것은 아님
		 * A a1 = new A();
		 * B b1 = (B) a1; // 에러 발생 
		 * 
		 * A a2 = new B();
		 * B b2 = (B) a2; // 다운 캐스팅은 경우에 따라 될 수도 있음
		 * C c2 = (C) a2; // 에러 발생
		 * 
		 * 무슨 타입으로 선언되어있는지는 중요하지 않고 어떤 생성자로 생성되었는지가 가장 중요함
		 * B() 생성자로 만들었으면 A로 업캐스팅 할 수 있고
		 * C() 생성자로 만들었따면 A와 B로 업캐스팅 할 수 있음
		 * 
		 */
	}

}
