**JetBrains Privacy Policy**
============================

#### **Version 3.0, last updated: 3 July, 2024**

In this Privacy Notice, we describe the types of data, including Personal Data, (collectively,
“data”) that we and our associated companies collect from you when you use JetBrains Websites and
certain JetBrains products and services as described in this Privacy Notice (collectively, our
“services”), how we and our associated companies use and disclose that data, and your options for
accessing or updating your data.

For information about your privacy choices, please see Section 10, Your Privacy Choices and Rights,
and Section 14, Privacy Notice Specifications for Certain U.S. Jurisdictions.

If you are a resident of California, please also refer to Section 13, Privacy Notice Specifications
for California Residents, for information about the categories of personal information we collect
and your rights under California privacy laws.

The data controllers are JetBrains s.r.o., Praha 4, Na Hřebenech II 1718/8, PSČ 140 00, Czech
Republic, and the [associated companies of JetBrains](https://www.jetbrains.com/company/contacts/)
(collectively “JetBrains,” “we,” or “us”).

JetBrains and its [associated
companies](https://www.jetbrains.com/company/contacts/#headquarters-international-sales) act as
joint data controllers, who are jointly responsible for compliance with data protection legislation.
JetBrains s.r.o. is primarily responsible for exercising the rights of data subjects and providing
information about data processing. 

**This Privacy Notice identifies what Personal Data we may process about you. The extent varies
depending on whether you are just visiting our Website or using our products or services. We do not
process health data or otherwise sensitive data about you. For more information, you can contact us
anytime at** [**privacy@jetbrains.com**](mailto:privacy@jetbrains.com) **. This document applies
only to situations where we act as a Personal Data controller. More information about circumstances
in which we are in the role of data processor can be found in our** [**Data Processing
Agreement**](https://www.jetbrains.com/legal/dpa/) **. The list of our partners who might process
your Personal Data, including the location of the data, can be found**
[**here**](https://www.jetbrains.com/legal/docs/privacy/third-parties/) **.**

1. Definitions
--------------

The following definitions are used throughout this Privacy Notice:

**COPPA.** Children’s Online Privacy Protection Act. in the US. 

**GDPR.** General Data Protection Regulation (EU) 2016/679 as amended. 

**JetBrains Software Product**. Any software product distributed or made available by JetBrains
under the JetBrains Subscription Agreement or any other JetBrains Agreement, **excluding**
third-party software. Any such third-party software is governed by its own terms and conditions and
privacy policy.

**JetBrains Software as a Service**. Any JetBrains Software Product that is offered as a hosted
solution, where the software is installed and maintained by JetBrains and provided to you as a
service.

**JetBrains Website**. Any website that is the property of JetBrains, including, but not limited to,
everything hosted under the domains listed at
[https://www.jetbrains.com/legal/websites](https://www.jetbrains.com/legal/websites/).

**JetBrains Account**. An account you create and which JetBrains may use in communicating with you
or providing JetBrains Products to you. It contains your first name, last name, email address,
username, and, if uploaded voluntarily, your photograph or another avatar. Your JetBrains Account is
accessed via a username and password or a similar authentication method and can be used to manage
your Personal Data.

**JetBrains Terms of Use.** The JetBrains Subscription Agreement, the JetBrains Terms of Use for a
product or a service, the JetBrains License Agreement, or other agreements you have in place with
JetBrains covering JetBrains Products or services.

**Personal Data.** Any data relating to an identified or identifiable natural person.

All other terms used in this Privacy Notice (such as controller, processor, data subject, and
others) that are defined in Article 4 of the GDPR shall have the same meaning as defined in Article
4 of the GDPR.

JetBrains Software Products, the JetBrains Website, JetBrains Accounts, and JetBrains Software as a
Service may be collectively referred to as "**JetBrains Products**" or “**products and services**.”

2. Why We Collect Data and What We Collect
------------------------------------------

We collect data for various reasons, such as:

a) **To provide you with software, services, or information.** We may collect data, including your
Personal Data, that is required to provide you with software, support, and services, license
validation and checking for updates, providing support, reporting issues and bugs, and other
processing connected with the use of JetBrains Products or information. We may use collected data to
develop and test products and services. You may explicitly provide the Personal Data required for
you to receive the software, support, or services, whether you purchase or use JetBrains Products,
use our support forums, sign up for a JetBrains Account, register for a webinar, participate in a
survey, and/or subscribe to receive marketing and/or technical information and content. This data
may also be collected in the course of your using JetBrains Products. We may use [third-party
service providers](https://www.jetbrains.com/legal/docs/privacy/third-parties.html), acting as data
processors, to assist us in providing JetBrains Products to you or in our operations. For example,
we may use [third-party service
providers](https://www.jetbrains.com/legal/docs/privacy/third-parties.html) to provide data storage
and backup services. The legal basis for this data processing is the performance of a contract
between you and us. With your consent, your Personal Data may also be transferred to [third-party
service providers](https://www.jetbrains.com/legal/docs/privacy/third-parties.html), acting as
separate data controllers, who provide products and services complementary to JetBrains Products
(further data processing performed by these service providers is governed by their privacy
policies). The legal basis for this data processing is consent.

b) **To protect us from piracy and the unlawful use of our software or services**. We may collect
data that is necessary to protect us from piracy or the unlawful or unauthorized use of our software
or services, or that is necessary to ensure the security of our software or services, including both
Personal Data provided by you (see above) and data collected in the course of your use of JetBrains
Products. The legal basis for this data processing is JetBrains’ legitimate interest in protection
from piracy and from the unlawful use of JetBrains software and services. Such personal data may
include your IP address and information about your JetBrains Account. Collecting this data may
include asking for your school records to prove that you are indeed a student if you are applying
for a student license. 

c) **To improve our offerings based on usage.** With your consent, we may collect anonymous data
based on your use of JetBrains Products. We use this data to better understand the usage patterns of
our products and the behaviors of our collective audience. At times, we may share this information
in an aggregated anonymous form with third parties. Since the data is anonymous, no personal data is
processed. Please refer to our [Cookie
Notice](https://www.jetbrains.com/legal/docs/privacy/cookie-notice/) for more information regarding
the collection of non-anonymous data (cookies) when you are using the JetBrains Website.

d) **For JetBrains’ internal evidence and to protect the rights and interests of JetBrains and other
users**. We may collect data that is required as evidence of the provision of software and services
to you, of any communication between you and us, of your contact details, of your use of our
software and services, of your compliance with the terms of the agreement between you and JetBrains,
of any payments or refunds, and of any issues or disputes between you and us. We may use and
disclose this data where we believe, in our sole judgment, that it is legitimate and appropriate to
do so to protect our rights and interests and the rights and interests of other users of JetBrains
Products or services, or where we believe there has been a violation of this Privacy Notice that
could affect the interests of JetBrains or its customers for a period corresponding to the statute
of limitations. The legal basis for this data processing is our legitimate interest in keeping
internal evidence and protecting the rights and interests of us and other users.

e) **To promote and market our products and services.** We may use feedback that you voluntarily
provide about our products or services. As permitted by applicable law, we may use such feedback in
the form of anonymized quotes or in other ways in accordance with the JetBrains Terms of Use. We
also may use data that we collect and aggregate to assist us in determining the appropriate
marketing and advertising for our products and services. In doing so, we may share anonymous
aggregated data with third parties to assist us with these efforts. With your consent or if
permitted by applicable law on the legal basis of legitimate interest, we may also use your contact
details to send you commercial communications about our products and services. This may include
reaching out to you if you used a trial or EAP version of a JetBrains Product, if you started a
purchase process on the JetBrains Website but did not complete it, if you have used JetBrains
Products in the past, or in similar scenarios. We may also use [third-party service
providers](https://www.jetbrains.com/legal/docs/privacy/third-parties.html) to assist us with our
email marketing. In that case, the [third-party service
provider](https://www.jetbrains.com/legal/docs/privacy/third-parties.html) will have access to your
email address, your name, and other information necessary to engage in the marketing. Such
[third-party service providers](https://www.jetbrains.com/legal/docs/privacy/third-parties.html)
will act as data processors and will not use your Personal Data for their own purposes. As more
fully described in the **How We Collect Data** section, we also may use [third-party service
providers](https://www.jetbrains.com/legal/docs/privacy/third-parties.html) to assist us with our
digital advertising, including through cross-contextual advertising on third-party properties. In
that case, the [third-party service
provider](https://www.jetbrains.com/legal/docs/privacy/third-parties.html) will have access to your
online identifiers and information about your use of our products and services. The legal basis for
this data processing is our legitimate interest in promoting and marketing our products and
services, or your explicit consent. During conferences or events, we may use badge scanning
services, also called lead retrieval or scanning, where we can scan your badge and collect certain
Personal Data to enable us to contact you for the above-mentioned purposes.

f) **To fulfill legal duties stipulated by accounting, taxation, and other laws**. We may use and
disclose your Personal Data where required by law, such as in keeping and disclosing our accounts,
in keeping and disclosing our tax records, and in response to a court order, valid subpoena, or
other legal process for the period of time required by such laws. The legal basis for this data
processing is our compliance with our legal obligations.

You may object at any time to the processing of your Personal Data unless you provide us with
consent for such processing. In that case, you may revoke your consent. 

Examples of Personal Data involved in data processing include:

-   Name;
-   Email address;
-   Phone number;
-   Username;
-   Password;
-   Photograph (if voluntarily provided);
-   Cookies or other tracking identifiers;
-   Internet Protocol (IP) address;
-   Information about your device and/or internet browser;
-   SSH public key;
-   Physical address;
-   Information about subscription and payments, including financial information associated with our
    accounts and payments;
-   Tax ID;
-   Data about your use of JetBrains Products, services, and your JetBrains Account;
-   Comments, voluntarily provided feedback, and any data provided in survey responses or forms; and
-   Data in issue reports pertaining to JetBrains Products and services, such as project or device
    names.

Where appropriate, we will prompt you to give us your consent to collect and process your data as
described above. This may happen within JetBrains Products, on the JetBrains Website, or in another
environment set up by JetBrains, always in a clear and conspicuous manner. You can manage your
Personal Data and opt-outs as described in Section 5, Transparency, below.

3. How We Collect Data 
-----------------------

We collect Personal Data directly from you when you interact with our products and services or
communicate directly with us. We may also collect data about you from third parties. For example, if
you access our products or services through a third-party application, such as an app store, a
third-party login service, or a social networking site, we may collect from that third-party
application personal information about you that you have made available via your privacy settings.
We also collect data automatically when you visit the JetBrains Website or use JetBrains Products.

-   **Automatic collection of personal information**. We may collect certain information
    automatically when you use our services, such as your IP address, user settings, MAC address,
    cookie identifiers, mobile carrier, mobile advertising, and other unique identifiers, browser or
    device information, location information (including approximate location derived from your IP
    address), and internet service provider. We may also automatically collect information regarding
    your use of JetBrains Products, such as pages that you visit before, during, and after using our
    products and services, information about the links you click, the types of content you interact
    with, and the frequency and duration of your activities, and other information about how you use
    our services. 

<!-- -->

-   **Crash reports**. If you provide crash reports within JetBrains Products, we may collect
    personal information related to them, including detailed diagnostic information about your
    device and the activities that led to the crash.
-   Please note that you can edit such reports to make sure they do not contain any Personal Data,
    or you can contact our customer support without providing the logs.

<!-- -->

-   **Cookies (and other technologies).** For more information regarding cookies and other tracking
    technologies, please refer to our [Cookie
    Notice](https://www.jetbrains.com/legal/docs/privacy/cookie-notice/). 

<!-- -->

-   **AI**. If you are using [JetBrains
    AI](https://www.jetbrains.com/legal/docs/terms/jetbrains-ai-service/), we or our [LLM
    providers](https://www.jetbrains.com/legal/docs/terms/jetbrains-ai/service-providers/) may
    collect personal data related to your AI service usage. For more information, please consult our
    dedicated [policy](https://www.jetbrains.com/help/ai/data-collection-and-use-policy.html). 

<!-- -->

-   **Online forms.** We may collect Personal Data via a form based on the nature of your
    interaction with us. Each form explains our purpose for collecting such data in more detail. 

<!-- -->

-   **Social media platforms**. Our products and services may contain****buttons for social media
    platforms, such as Facebook, Instagram, and X, and these buttons might include widgets such as
    the “Share This” button or other interactive mini-programs. These features may collect personal
    information such as your IP address, and they may set a cookie to enable them to function
    properly. Your interactions with these platforms are governed by the privacy policies of the
    companies providing them.

<!-- -->

-   **Direct interaction.** We may collect Personal Data from you as part of your interaction with
    us, for example, when we provide product or sales support to you. 

4. How We Protect Children’s Personal Data
------------------------------------------

Our products and services are generally not designed for and are not offered to children under the
age of 13. In some cases, there’s an exception to this approach, and children under 13 might be able
to use our products. When a child confirms that they are under 13 years old, we ask for their
parent’s or legal guardian’s email address to obtain permission to process such Personal Data for
this purpose in accordance with COPPA and GDPR. If we don’t receive permission within three (3) days
or we are denied permission, the Personal Data collected through the form will be automatically
deleted after three (3) days. We don’t send marketing communications to children under 15 years old.
Children between the ages of 13 and 16 are asked to confirm that they discussed the processing of
their data with their parents or legal guardians and have their permission. 

5. Transparency
---------------

To respect your privacy, before using your Personal Data, we will inform you about the categories of
Personal Data we collect and the purposes we use them for. We will also inform you about the data
management options that you may have. For this purpose, we use agreements, terms of use, and consent
notices embedded in JetBrains Products and services, which are available
[here](https://www.jetbrains.com/legal/). You may also contact us at <privacy@jetbrains.com>. 

6. Sharing of Personal Data
---------------------------

Collected Personal Data is shared in accordance with the JetBrains Terms of Use of a given product
or service, as well as this Privacy Notice. Additionally, we share collected Personal Data within
the JetBrains group of companies described above, which act as joint data controllers and process
Personal Data for the purposes described in the section Why We Collect Data and What We Collect, or
with our data processors, a list of which can be found
[here](https://www.jetbrains.com/legal/docs/privacy/third-parties/), who help us operate our
software and services.

As part of the functionality of a given product or service, collected Personal Data may be shared
with other representatives of your company, in accordance with the JetBrains Terms of Use covering
that product or service.

Through our JetBrains Website, we may share your Personal Data with third-party advertising
partners. These third-party advertising partners may apply technologies and other tracking tools on
our services to collect information regarding your activities and your device (e.g. your IP address,
cookie identifiers, page(s) visited, location, and time of day). These advertising partners may use
this information (and similar information collected from other services) to deliver personalized
advertisements to you when you visit digital properties within their networks. This practice is
commonly referred to as “interest-based advertising,” “cross-context behavioral advertising,” or
“personalized advertising.

We may also share your Personal Data with certain third parties (such as with tax authorities or
with other government bodies exercising their statutory powers) if we are obliged to do so under
applicable legislation, to protect our legal rights and those of others, or if such sharing is
necessary to achieve the purposes defined in section Why We Collect Data and What We Collect
(especially with government bodies or with parties harmed as a result of violations of applicable
laws).

If we are involved in a merger, an acquisition, financial due diligence, reorganization, bankruptcy,
receivership, purchase or sale of assets, or a transition of service to another provider. In that
case, your information may be sold or transferred as part of such a transaction, as permitted by law
and/or contract.

**YouTube API Services.** We may display YouTube videos on the JetBrains Website using the API
client. The API client uses [YouTube API
Services](https://developers.google.com/youtube/terms/developer-policies#definition-youtube-api-services).
By interacting with the video, you agree to [YouTube’s Terms of
Service](https://www.youtube.com/t/terms) and acknowledge [Google’s Privacy
Policy](https://www.google.com/policies/privacy). By interacting with the JetBrains Website, you
acknowledge our Privacy Policy.

-   Information we collect. The API client collects and uses data from YouTube API Services. It also
    collects information from the devices you use to access the JetBrains Website in accordance with
    your tracking preferences in accordance with our [Cookie
    Notice. ](https://www.jetbrains.com/legal/docs/privacy/cookie-notice/)
-   **How we use your information.** We use the data collected from the API client to display
    YouTube videos through it. YouTube can access information about the videos you viewed on the
    JetBrains Website and display advertisements based on your viewing history. YouTube ad settings
    are available
    [here](https://www.youtube.com/intl/en_us/howyoutubeworks/user-settings/ad-settings/). We use
    first-party and third-party cookies to enhance and personalize your website experience. 
-   **Sharing.** We may share [authorized
    data](https://developers.google.com/youtube/terms/developer-policies#definition-authorized-data)
    with [Google](https://policies.google.com/privacy?hl=en-US) (including
    [YouTube](https://support.google.com/youtube/answer/10364219?hl=cs)).
-   **Your rights.** You can manage or revoke Google’s access to your data via [Google’s Security
    Settings. ](https://myaccount.google.com/connections?filters=3,4&hl=cs)

7. Security
-----------

To secure your Personal Data, our products and services are designed with security, data protection,
and privacy in mind.

We encrypt your data in transit and at rest where it is technically feasible. For the protection of
data during transmission, we use an up-to-date TLS (Transport Layer Security) protocol to encrypt
your data. To encrypt data at rest, we use strong, up-to-date encryption algorithms, such as
AES-256. All encryption keys are regularly rotated, and access to them is strictly limited.

We thoroughly review all Personal Data usage processes before implementation to help achieve
compliance with applicable data-protection-related laws and to safeguard user information. This is
done to minimize data usage and to make sure that you, as the data owner, are informed about the
processing. When the reason for data storage expires, and we are no longer required to keep it, we
remove your Personal Data from our servers or anonymize it for further usage. Depending on the
activity within which your data is collected, it may appear in datasets used for research. Before
using the datasets for research or other purposes you are not informed of, we remove or anonymize
your Personal Data in the datasets.

We use [suppliers](https://www.jetbrains.com/legal/docs/privacy/third-parties.html) to host our
products and services and JetBrains Websites and to process your data in accordance with this
Privacy Notice. When choosing a supplier, JetBrains performs a supplier risk assessment process to
evaluate their compliance with legal regulations and security standards and help ensure that your
data is stored in a secure location with appropriate security measures in place.For more details
about security at JetBrains, please visit our [Trust Center.](https://trust-center.jetbrains.com/)

8. Location of Your Information
-------------------------------

The default location for any Personal Data of our customers is the EU, unless specified otherwise.
For Software as a Service products, we may provide the option for our customers to choose between
hosting their instance in the EU or in [other
regions](https://www.jetbrains.com/privacy-security/data-centers/). For JetBrains AI, the default
location of Personal Data storage may differ; see [this
link](https://www.jetbrains.com/legal/docs/privacy/third-parties/). At times, JetBrains may process
or transfer some of your Personal Data (such as your name and email address) to our affiliate
companies or subprocessors outside the EU. Any such transfer and processing will be done in
accordance with the applicable laws on data protection and this Privacy Notice and will be based on
a relevant adequacy decision of the European Commission, especially regarding standard data
protection clauses. For more information, please
click[here](https://www.jetbrains.com/legal/docs/privacy/third-parties/).

9. Third-Party Links
--------------------

JetBrains Products and Websites may contain links to other websites provided by third parties not
under JetBrains’ control. When following a link and providing information to a third-party website,
please be aware that JetBrains is not responsible for the data provided to that third party. This
Privacy Notice only applies to JetBrains Websites, so when you visit other websites, even when you
click on a link posted on JetBrains Websites, you should read their privacy policies.

10. Your Privacy Choices and Rights 
------------------------------------

**Your Privacy Choices: **

The privacy choices you have regarding your personal information are determined by the specific laws
applicable to you and your data. The following may apply to you:

-   **Email communications**. If you receive an unwanted email from us, you can use the unsubscribe
    link found at the bottom of the email to opt out of receiving future emails. Note that you will
    continue to receive transaction and product-related emails regarding JetBrains Products you have
    access to. We may also send you certain non-promotional and transactional communications and you
    will not be able to opt out of those communications (e.g. communications regarding updates to
    our terms or to this Privacy Notice). 

<!-- -->

-   **Cookies and personalized advertising**. You may stop or restrict tracking by clicking on the
    “[Opt-Out” link](https://www.jetbrains.com/opt-out/) in the footer of our Website. You can
    adjust your preferences by interacting with the cookie banner that is displayed when you visit
    the [Opt-Out page](https://www.jetbrains.com/opt-out/). Please note that cookie-based opt-outs
    are effective only on the specific device where you opted out. 

The online advertising industry also provides websites from which you may opt out of receiving
targeted ads from data partners and other advertising partners that participate in self-regulatory
programs. You can access these and learn more about targeted advertising and consumer choice and
privacy by visiting the [Network Advertising
Initiative](https://www.networkadvertising.org/managing/opt_out.asp), [the Digital Advertising
Alliance](https://www.aboutads.info/choices/), [the European Digital Advertising
Alliance](https://www.youronlinechoices.eu/), and [the Digital Advertising Alliance of
Canada](https://youradchoices.ca/choices/). 

Please note that you must opt out separately in each browser and on each device. 

-   **Data retention and deletion.** If at any time you choose to cease using JetBrains Products,
    you may ask for your Personal Data to be removed from our servers by sending a request to
    <privacy@jetbrains.com> or via your JetBrains Account. After the Personal Data removal, we may
    keep pseudonyms of your Personal Data solely as a record of the data removal. Generally, we
    retain your Personal Data as long as we need to in order to achieve the purpose for which it was
    collected. We may retain your information if it is required for compliance with legal
    obligations and/or defense in the event of a violation of the JetBrains Terms of Use and/or
    Privacy Policies. We may also have copies of your information in application logs, weblogs,
    and/or backups made for security and support purposes if this is mentioned in a JetBrains Terms
    of Use or consent text accepted before the Personal Data collection. These backups will not be
    accessible as separately delineated information. We may store Personal Data pertaining to a
    customer or user for as long as they are entitled to a license for or usage of JetBrains
    Products. Further, we may keep the data to protect ourselves from damage in the event of
    litigation in accordance with the current legislation. Please note, however, that you must
    retain a copy of all data that you have placed on our servers in case of any loss. Further, if
    you cease using our software and/or services, we will not be responsible for the retention of
    any of your data.
-   **Data management**. You may manage your Personal Data in your JetBrains Account, including by
    opting out of certain kinds of data collection. You can also adjust your preferences in the
    settings of JetBrains Products. Email preferences can also be set by clicking on the
    “Unsubscribe” link in the footer of emails sent by us. You are responsible for the correctness
    of the Personal Data you provide to us. We expect you to check the Personal Data you provide to
    us, and if any inconsistency appears, update your Personal Data or report the inconsistency to
    JetBrains.

**Your Privacy Rights: **

As permitted by applicable law, you may have the right to request a copy of the information that we
hold about you. To do so, please go to your JetBrains Account and ask for a copy through the means
available there, or contact <privacy@jetbrains.com>. Where permitted by applicable law, we may
charge a fee for this service.

Moreover, as set out in locally applicable Personal Data protection laws, you may have the right to:
(i) request access to your Personal Data; (ii) request rectification of your Personal Data; (iii)
request the erasure of your Personal Data; (iv) request a restriction on the processing of your
Personal Data; (v) request Personal Data portability; or (vi) object to, or opt-out of, the
processing of your Personal Data in some cases.

-   **Right of access.** You may have the right to obtain from us a confirmation as to whether or
    not Personal Data concerning you is being processed, and, where that is the case, to request
    access to your Personal Data. The information about Personal Data processing includes the
    purposes of the processing, the categories of Personal Data concerned, the recipients or
    categories of recipients to whom your Personal Data has been or will be disclosed, etc. However,
    this is not an absolute right, and the interests of other individuals may restrict your right of
    access. Further, you may have the right to obtain a copy of your Personal Data undergoing
    processing. For additional copies requested, we may charge a reasonable fee based on
    administrative costs.
-   **Right to rectification.** You may have the right to obtain from us the rectification of
    inaccurate Personal Data. Depending on the purposes of the processing, you may have the right to
    have incomplete Personal Data made complete, in particular by providing a supplementary
    statement.
-   **Right to erasure (right to be forgotten).** Under certain circumstances, you may have the
    right to require us to delete your Personal Data.
-   **Right to a restriction of processing.** Under certain circumstances, you may have the right to
    require us to restrict the processing of your Personal Data. In this case, the respective
    Personal Data will be marked and may only be processed by us for certain purposes.
-   **Right to Personal Data portability.** Under certain circumstances, you may have the right to
    receive the Personal Data that you have provided us concerning you in a structured, commonly
    used, and machine-readable format, and to transmit this Personal Data to another entity.
-   **Right to Object.** Under certain circumstances, you may have the right to object at any time,
    on grounds relating to the particular situation, to the processing of your Personal Data by us,
    and we may be required to no longer process your Personal Data.

These rights can be exercised by sending an email to <privacy@jetbrains.com>.

You may also contact JetBrains to get up-to-date information about the processing of your Personal
Data and any Personal Data recipients.

You may lodge a complaint related to the processing of your Personal Data with the competent data
protection authority for the country where you are located or with the[Czech data protection
authority](https://www.uoou.cz/), as we are based in that country. 

11. Changes to This Notice
--------------------------

This Privacy Notice is current as of the date of the last update set forth above. We may change this
Privacy Notice from time to time, so please be sure to check back periodically. We will post any
changes to this Privacy Notice on the JetBrains Website. If we make any changes to this Privacy
Notice that materially affect our practices with regard to the Personal Data we have previously
collected from you, we will endeavor to provide you with an advance notice of such changes by
highlighting them on the JetBrains Website.

12. Contact Us
--------------

If you have any questions or concerns, or if you feel that this Privacy Notice has been violated in
any way, please let us know immediately by contacting <privacy@jetbrains.com>. If you wish to
contact our DPO, please contact <dpo@jetbrains.com>.

13. Privacy Notice Specifications for California Residents
----------------------------------------------------------

**NOTICE AT COLLECTION AND SUPPLEMENTAL NOTICE FOR CALIFORNIA RESIDENTS**
This Notice at Collection and Supplemental Notice for California Residents describes our information
practices pursuant to applicable California privacy laws, including the California Consumer Privacy
Act (the “CCPA”), as amended. To the extent you are a California resident, and we collect “personal
information” subject to the CCPA, the following applies. This section does not address or apply to
our handling of publicly available information or personal information that is otherwise exempt
under the CCPA.**An Important Note:** This Privacy Notice does not apply to any of the personal
information that we process on behalf of our customers through their use of our products and
services (“**Customer Underlying Data**”). Our customers’ respective privacy policies govern their
collection and use of Customer Underlying Data. Our processing of Customer Underlying Data is
governed by the contracts that we have in place with our customers, not this Privacy Notice. Any
questions or requests relating to Customer Underlying Data should be directed to the relevant
customer.

**Categories of Personal Information Collected and Disclosed**

The following table describes the categories of personal information JetBrains collects and the
categories of third parties to whom we may disclose this information for a business or commercial
purpose.

<table>
<colgroup>
<col width="50%" />
<col width="50%" />
</colgroup>
<thead>
<tr class="header">
<th><p>Category of Personal Information Collected by JetBrains</p></th>
<th><p>Category of Third Parties We May Disclose Personal Information to for a Business Purpose</p></th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td><strong>Identifiers:</strong> Name, signature, address, unique personal identifier, online identifier, Internet Protocol address, and telephone number.Note: Some personal information included in this category may overlap with other categories.</td>
<td><ul>
<li>Business partners </li>
<li>Affiliates</li>
<li>Data analytics providers</li>
<li>Advertising networks</li>
<li>Advisors and agents</li>
<li>Others as required by law </li>
</ul></td>
</tr>
<tr class="even">
<td><strong>Customer records:</strong> Name, contact information, and financial or payment information (e.g. bank account number).</td>
<td><ul>
<li>Business partners </li>
<li>Affiliates </li>
<li>Advisors and agents</li>
<li>Others as required by law</li>
</ul></td>
</tr>
<tr class="odd">
<td><strong>Commercial information:</strong> Records of personal property, products or services purchased, obtained, or considered, or other purchasing or consuming histories or tendencies.</td>
<td><ul>
<li>Business partners </li>
<li>Affiliates </li>
<li>Data analytics providers</li>
<li>Advertising networks</li>
<li>Advisors and agents</li>
<li>Others as required by law</li>
</ul></td>
</tr>
<tr class="even">
<td><strong>Internet or other electronic network activity:</strong> Browsing history, search history, and information on a consumer’s interaction with an internet website, application, or advertisement.</td>
<td><ul>
<li>Business partners </li>
<li>Affiliates</li>
<li>Data analytics providers</li>
<li>Advertising networks</li>
<li>Advisors and agents</li>
<li>Others as required by law</li>
</ul></td>
</tr>
<tr class="odd">
<td><strong>Location data:</strong> Physical location based on IP address and physical address. </td>
<td><ul>
<li>Business partners</li>
<li>Data analytics providers</li>
<li>Advertising networks</li>
<li>Advisors and agents</li>
<li>Others as required by law</li>
</ul></td>
</tr>
<tr class="even">
<td><strong>Inferences drawn from other personal information to create a profile about a consumer:</strong> Profile reflecting a consumer’s preferences, characteristics, psychological trends, predispositions, behavior, attitudes, intelligence, abilities, and aptitudes.</td>
<td><ul>
<li>Business partners</li>
<li>Data analytics providers</li>
<li>Advertising networks</li>
<li>Advisors and agents</li>
<li>Others as required by law</li>
</ul></td>
</tr>
</tbody>
</table>

**Sources of Personal Information**

For details on sources of personal information, see the section **How We Collect Data**. More
details are available upon request. 

**Purposes of Collection, Use, and Disclosure**

As described in more detail above in Sections 2 and 6, **Why We Collect Your Data and What We
Collect** and **Sharing of Personal Data**, in general, we may collect, use, disclose, and otherwise
process personal information for the following business or commercial purposes and as otherwise
directed or consented to by you:

-   To provide our products and services to you; 
-   To protect us from piracy and the unlawful use of our software or services;
-   To improve our offerings based on usage;
-   For JetBrains’ internal evidence and to protect the rights and interests of JetBrains and other
    users;
-   To advertise and market our products and services to you;
-   General business and operational support; and, 
-   To comply with applicable laws. 

**“Sales” and “Sharing” of Personal Information.**

The CCPA defines “sale” as disclosing or making available personal information to a third party in
exchange for monetary or other valuable consideration, and “sharing” includes disclosing or making
available personal information to a third party for purposes of cross-context behavioral
advertising. While we do not disclose personal information to third parties in exchange for monetary
compensation, we may “sell” or “share” the following categories of personal information:
identifiers, internet and network activity information, location data (via your IP address), and
inferences. We may disclose these categories to third-party advertising networks, analytics
providers, and social networks for purposes of marketing and advertising and to improve and measure
our ad campaigns.

We do not sell or share sensitive personal information, nor do we sell or share personal information
about individuals we know are under the age of sixteen (16).

**Retention of Personal Information. **

We store the personal information we collect as described in this Privacy Notice for as long as you
use JetBrains Products or as necessary to fulfill the purpose(s) for which it was collected, provide
our products and services, resolve disputes, establish legal defenses, conduct audits, pursue
legitimate business purposes, enforce our agreements, and comply with applicable laws, or based upon
other criteria, including, but not limited to, the sensitivity and volume of such data.
Additionally, we endeavor to retain all such personal information in accordance with legal
requirements.

**De-Identified Information.** If we create or receive de-identified information, we will maintain
and use such de-identified information in de-identified form. We will not attempt to reidentify such
information, except to comply with applicable law.

**Privacy Rights for Residents of California **

The CCPA provides California residents with specific rights regarding personal information. Subject
to certain conditions and exceptions, California residents have the following rights:

-   **Right to know.** You have the right to request (i) the categories of personal information we
    collected about you; (ii) the categories of sources from which the personal information is
    collected; (iii) our business or commercial purposes for collecting, selling, or sharing
    personal information; (iv) the categories of third parties to whom we have disclosed personal
    information; and (v) a copy of the specific pieces of personal information we have collected
    about you.
-   **Right to Delete.** You have the right to request us to delete any personal information we have
    collected from you.
-   **Right to Correct.** You have the right to request us to correct inaccuracies in your personal
    information.
-   **Right to Opt Out of Sales and Sharing.** You have the right to opt out of “sales” and
    “sharing” of your personal information, as those terms are defined under the CCPA. 
-   **Right to Limit Use of Sensitive Personal Information.** You have the right to limit the use
    and disclosure of your sensitive personal information. We do not collect, use, or disclose
    sensitive personal information; thus, this right is not available to California residents.
-   **Non-Discrimination**. |You have the right not to receive discriminatory treatment by us for
    the exercise of your rights conferred by the CCPA.

**Submitting CCPA Requests**

California residents may exercise their CCPA privacy rights as set forth below:

**Right to Know, Delete, and Correct.** California residents may submit CCPA requests to
access/know, delete, or correct their personal information by sending an email to
privacy@jetbrains.com.

**Authorized Agent**.****Only you, or someone legally authorized to act on your behalf, may make a
verifiable consumer request related to your personal information. You may also make a verifiable
consumer request on behalf of your minor child. To authorize an agent, provide written authorization
signed by you and your designated agent and contact us as set forth in the **Contact Us** subsection
below for additional instructions.

**Verification**. To protect your privacy, we will take steps to reasonably verify your identity
before fulfilling your request. These steps may involve asking you to provide sufficient information
that allows us to reasonably verify that you are either the person about whom we collected personal
information or an authorized representative, or we may ask you to answer questions regarding your
account and use of our products and services. If we cannot verify your identity or authority to make
a request, we may not be able to fulfill your request. 

**Right to Opt Out of Sales and Sharing.** To exercise your right to opt out of the “sale” or
“sharing” of your personal information, you may do so via our [cookie preference
manager](https://www.jetbrains.com/opt-out/). We will apply your opt-out based upon the personal
information in our records that is linked or reasonably linkable to the information provided in your
request. You may also click the “[Do Not Sell or Share My Personal
Information](https://www.jetbrains.com/opt-out/)” link. Please note that your request to opt out of
sale or sharing will be linked to your browser identifier only. If you use a different computer or
internet browser to access our sites, you will need to renew your cookie management choices.

**GPC.** In addition, if we detect that your browser or device is transmitting an opt-out preference
signal, such as the “global privacy control” (GPC) signal, we will opt that browser or device out of
cookies that result in the “sale” or “sharing” of your personal information. If you come to our
Website or use our services from a different device or from a different browser on the same device,
you will need to opt out, or use an opt-out preference signal, for that browser and/or device as
well. More information about GPC is available at <https://globalprivacycontrol.org/>.

**California Shine the Light**. The California “Shine the Light” law permits users who are
California residents to request and obtain from us once a year, free of charge, a list of the third
parties to whom we have disclosed their personal information (if any) for their direct marketing
purposes in the prior calendar year, as well as the type of personal information disclosed to those
parties.

**Right for minors to remove posted content.** Where required by law, California residents under the
age of 18 may request to have their posted content or information removed from the publicly viewable
portions of the services by contacting us directly as set forth in the **Contact Us** subsection
below or by logging into their account and removing the content or information using our
self-service tools.

**Contact Us**

If you have any questions or concerns, or if you need to contact us regarding your privacy rights,
please email us at <privacy@jetbrains.com>. 

14. Privacy Notice Specifications for Certain U.S. Jurisdictions
----------------------------------------------------------------

Residents of certain U.S. states, including Colorado, Connecticut, Utah, and Virginia, require
additional disclosures under applicable privacy laws.

**Sale of Personal Information**

While we do not disclose personal information to third parties in exchange for monetary
compensation, we may “sell” or “share” the following categories of personal information:
identifiers, such as unique personal identifiers, online identifiers, IP address, or other similar
identifiers; location data (via your IP address); internet and network activity information; and
inferences. We may disclose these categories to third-party advertising networks, analytics
providers, and social networks for the purposes of marketing and advertising and to improve and
measure our ad campaigns.

**Consumer Rights**

Residents of certain U.S. states, including Colorado, Connecticut, Utah, and Virginia, may have,
subject to certain limitations, additional rights under applicable privacy laws, which may include:

**Access**. The right to confirm whether we are processing their personal information and to obtain
a copy of their personal information in a portable and, to the extent technically feasible, readily
usable format.
**Deletion**. The right to delete their personal information provided to or obtained by us.
**Correction**. The right to correct inaccuracies in their personal information.
**Opt Out**. The right to opt out of certain types of processing, including:
-   To opt out of the “sale” of their personal information;
-   To opt out of targeted advertising by us; and
-   To opt out of any processing of personal information for the purpose of making decisions that
    produce legal or similarly significant effects.

You may submit a request to exercise most of your privacy rights under U.S. state privacy laws
through our webform or by emailing us at <privacy@jetbrains.com>.

To opt out of targeted advertising by us, you can adjust your cookie settings
[here](https://www.jetbrains.com/opt-out/) or on your device. In addition, our Website responds to
global privacy control (GPC) signals, which means that if we detect that your browser is
communicating a GPC signal, we will process that as a request to opt that particular browser and
device out of sales and sharing (i.e., via cookies and tracking tools) on our Website. Note that if
you come back to our Website on a different device or use a different browser on the same device,
you will need to opt out (or set GPC) for that browser and device as well. More information about
GPC is available at <https://globalprivacycontrol.org/>.

We will respond to your request as required under applicable U.S. privacy law(s). When you submit a
request, we will take steps to verify your identity and request by matching the information provided
by you with the information we have in our records. In some cases, we may request additional
information in order to verify your identity, or, where necessary, to process your request. If we
are unable to verify your identity after a good-faith attempt, we may deny the request. If your
request is denied, we will explain the basis for the denial.

If we deny your request, in certain jurisdictions you may be able to appeal our decision according
to the instructions we provide in our response.

To the extent required under applicable U.S. privacy laws, you may also designate someone as an
authorized agent to submit requests and act on your behalf. Authorized agents may be required to
provide proof of their authorization and we may also require the relevant consumer to directly
verify the identity and authority of the authorized agent.

15. Privacy Notice Specifications for Chinese Customers
-------------------------------------------------------

If you’re a customer of JetBrains Shanghai, please refer to the dedicated [Shanghai Privacy
Notice,](https://www.jetbrains.com/legal/docs/privacy/privacy_shanghai/) which is applicable to
processing of your Personal Data when interacting with our Website and ordering JetBrains Products.
The processing of your Personal Data while using JetBrains Products is governed by this Privacy
Notice.
