package io.kotless.gen.factory.aws.route53

import io.kotless.Application
import io.kotless.KotlessConfig
import io.kotless.gen.GenerationContext
import io.kotless.gen.GenerationFactory
import io.kotless.gen.factory.aws.infra.ProvidersFactory
import io.kotless.terraform.functions.link
import io.terraformkt.aws.data.acm.acm_certificate
import io.terraformkt.hcl.ref

object CertificateFactory : GenerationFactory<Application.DNS, CertificateFactory.Output> {
    data class Output(val cert_arn: String)

    override fun mayRun(entity: Application.DNS, context: GenerationContext) = context.output.check((context.schema.config.cloud as KotlessConfig.Cloud.AWS).terraform, ProvidersFactory)

    override fun generate(entity: Application.DNS, context: GenerationContext): GenerationFactory.GenerationResult<Output> {
        val providers = context.output.get((context.schema.config.cloud as KotlessConfig.Cloud.AWS).terraform, ProvidersFactory)

        val cert = acm_certificate(context.names.tf(entity.certificate)) {
            providers.us_east_provider?.let {
                provider = link(it)
            }

            domain = entity.certificate
            statuses = arrayOf("ISSUED")
        }

        return GenerationFactory.GenerationResult(Output(cert::arn.ref), cert)
    }
}
