# Changelog

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)


# 0.2.0 - 2021-10-19

* Introduce support of Azure cloud 
* Migrate from JCenter to Space Packages
* A lot of changes inside the platform

# 0.1.7-beta-5 - 2021-02-01

## Changed

* Migrated to Gradle 6.8.1 with Kotlin 1.4.21
* Updated Ktor version to 1.5.0
* Updated Spring Boot version to 2.4.2

## Fixed

* Now Kotless correctly handles favicons thanks to mkuzmin

# 0.1.7-beta-4 - 2020-10-09

## Added

* Initial GraalVM support
    * Works only with Ktor right now
    * Ktor Site examples migrated to GraalVM

## Fixed

* Now Kotless should be working on Windows, thanks to zaenk (chmod will not be used on Windows)

# 0.1.6 - 2020-08-25

## Added

* Support for different runtimes: Java 8 and Java 11

## Changed

* Migrate to Terraform 12 by default

## Fixed

* Problem with LocalStack not stopping after a run

# 0.1.5 - 2020-06-02

## Fixed

* Reflections dependency reverted to older version because of critical bug in it
* Fix for HTTPRequest -- sometimes user-agent can miss in APIGateway request

# 0.1.4 - 2020-05-31

## Added

* Spring Boot DSL -- Spring Boot serverless container and parser of it. Support dynamic and static
  routes, warming of lambda, granular permissions. Does not support Scheduled.
* Support local run for Spring Boot DSL via tomcat starter
* Spring Boot examples: shortener and site

## Changed

* Examples were reworked into one project
* `workDirectory` is now called `staticsRoot`

## Fixed

* Improvements in all parsers -- now all of them should work a lot faster
* Fixes to documentation in code

# 0.1.3 - 2020-02-08

## Added

* Output to console URL of deployed application
* Support local start for Kotless DSL
* Support @Scheduled execution for local starts
* Use AWS Local Stack for mocking of AWS services during local start
    * Extension files will be automatically applied to LocalStack instance

## Fixed

* Support deployment without Route53 record -- will use generated by API Gateway DNS record. Note:
  *Usage of generated record may lead to problems with hardcoded links. Kotless Links API works with
  them correctly.*
* Support headless mode -- without any configuration Gradle project should be successfully imported and
  local starts will work. Still, configuration is required for actual deployment.

# 0.1.2 - 2019-11-03

## Added

* Ktor DSL -- Ktor Engine and parser for it. Support dynamic and static routes, warming of lambda,
  granular permissions. Does not support Scheduled.
* Add local run task for Ktor DSL -- now you can run server locally.
* Support of all remaining HTTP methods in Kotless and Ktor DSL
* Ktor examples: add shortener and site

# 0.1.1 - 2019-10-14

## Added

* Support of binary responses for binary MimeTypes
* Scheduled events -- just annotate function with @Scheduled
* Extensions API -- now it is possible to use custom Terraform code along with Kotless generated
  during deployment.
* URL shortener example -- simple URL shortener written with Kotless

## Changed

* Separate Terraform synthesizing into Terraform DSL, Generators and Optimizers
* Minor style changes in Gradle DSL

## Fixed

* Multiregional -- now Kotless can be deployed to any region
* Default parameters in functions now back to working
* Format of S3 resource arn in permissions
* Deploy-time check of signatures of annotated functions

# 0.1.0 — 2019-06-18

### Added

* Explicitly declared permissions, e.g. `@S3Bucket(bucket = "my_bucket", mode = Mode.Read`
    * Works for functions, classes and objects
    * Taken from routes and global actions (like `LambdaWarming`, `LambdaInit` and so on)
* `LambdaWarming` sequences - functions to execute each warming cycle
* `LambdaInit` sequences - functions to execute on initialization of lambda
* `HttpRequestInterceptor` - interceptors for HTTP requests, maybe chained
* Possibility to extend serialization and deserialization
* Links built-in support -- base links and links with parameters
