# Exposed Migration

This sample project illustrates how to:

- generate a migration script using Exposed
- apply a migration using a third-party library like
  [Flyway](https://documentation.red-gate.com/flyway/flyway-cli-and-api/usage/api-java) with a migration script
  generated by Exposed

## Generating a migration script

To simulate applying a migration on an existing database, the database in this sample project is initially set up using
raw SQL in the function `simulateExistingDatabase`. In `Tables.kt`, the table `Users` represents the modified version
of the Users table, which was created in `simulateExistingDatabase` and does not have a primary key.

The function `MigrationUtils.generateMigrationScript` generates a SQL migration script in the specified directory. The
`exposed-migration` dependency is needed for this. In this sample project, it will be generated inside a directory
called `migrations`.

```kotlin
implementation("org.jetbrains.exposed:exposed-migration:$exposedVersion")
```

The generated migration script can also be edited manually before applying a migration. In this sample project, it will
be generated inside a directory called `migrations`.

To generate the migration script for this project, execute the following command in the repository's root directory:

```bash
./gradlew generateMigrationScript
```

## Applying a migration

In this sample project, Flyway is set up to apply migrations using migration scripts in the directory where Exposed
generates them. It is recommended to apply the migration in a separate transaction.

## Running

To apply the database migration for this project, execute the following command in the repository's root directory:

```bash
./gradlew run
```
