/*
 * Decompiled with CFR 0.152.
 */
package qiniu.happydns.local;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import qiniu.happydns.Domain;
import qiniu.happydns.IResolver;
import qiniu.happydns.Record;
import qiniu.happydns.local.Resolver;

public final class SystemDnsServer {
    private static final boolean isWindows = System.getProperty("os.name", "").toLowerCase().startsWith("windows");
    private static final String confName = "/etc/resolv.conf";
    private static long lastMondifyTime = 0L;
    private static String[] curAddresses = null;

    private SystemDnsServer() {
    }

    public static String[] getByJNDI() {
        try {
            Class<?> dirContext = Class.forName("javax.naming.directory.DirContext");
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            Class<?> initialDirContext = Class.forName("javax.naming.directory.InitialDirContext");
            Constructor<?> constructor = initialDirContext.getConstructor(Hashtable.class);
            Object obj = constructor.newInstance(env);
            Method m = dirContext.getMethod("getEnvironment", new Class[0]);
            Hashtable newEnv = (Hashtable)m.invoke(obj, new Object[0]);
            String dns = (String)newEnv.get("java.naming.provider.url");
            String dnsTrim = dns.replace("dns://", "");
            return dnsTrim.split(" ");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getByInternalAPI() {
        try {
            Class<?> resolverConfiguration = Class.forName("sun.net.dns.ResolverConfiguration");
            Method open = resolverConfiguration.getMethod("open", new Class[0]);
            Method getNameservers = resolverConfiguration.getMethod("nameservers", new Class[0]);
            Object instance = open.invoke(null, new Object[0]);
            List nameservers = (List)getNameservers.invoke(instance, new Object[0]);
            if (nameservers == null || nameservers.size() == 0) {
                return null;
            }
            String[] ret = new String[nameservers.size()];
            int i = 0;
            for (Object dns : nameservers) {
                ret[i++] = (String)dns;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getByUnixConf() {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            FileReader r = new FileReader(confName);
            BufferedReader input = new BufferedReader(r);
            String currentLine = null;
            while ((currentLine = input.readLine()) != null) {
                if (!(currentLine = currentLine.substring(0, currentLine.indexOf("#") == -1 ? currentLine.length() : currentLine.indexOf("#"))).contains("nameserver")) continue;
                lines.add(currentLine.replace("nameserver", "").trim());
            }
            if (lines.size() == 0) {
                return null;
            }
            String[] ret = new String[lines.size()];
            return lines.toArray(ret);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String[] defaultServer() {
        String[] addresses = null;
        File f = new File(confName);
        if (!isWindows && f.exists()) {
            if (f.lastModified() != lastMondifyTime) {
                curAddresses = SystemDnsServer.getByUnixConf();
            }
            addresses = curAddresses;
        }
        if (addresses == null && (addresses = SystemDnsServer.getByInternalAPI()) == null) {
            addresses = SystemDnsServer.getByJNDI();
        }
        return addresses;
    }

    public static IResolver defaultResolver() {
        return new IResolver(){

            @Override
            public Record[] resolve(Domain domain) throws IOException {
                String[] addresses = SystemDnsServer.defaultServer();
                if (addresses == null) {
                    throw new IOException("no dns server");
                }
                Resolver resolver = new Resolver(InetAddress.getByName(addresses[0]));
                return resolver.resolve(domain);
            }
        };
    }
}

