/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.wechat.model;

import cn.ieclipse.smartim.model.impl.AbstractMessage;
import cn.ieclipse.util.StringUtils;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import io.github.biezhi.wechat.api.WechatClient;
import io.github.biezhi.wechat.handler.msg.AppMsgXmlHandler;
import io.github.biezhi.wechat.handler.msg.EmojiMsgXmlHandler;
import io.github.biezhi.wechat.handler.msg.ImageMsgXmlHandler;
import io.github.biezhi.wechat.model.xml.AppMsgInfo;
import java.io.File;

public class WechatMessage
extends AbstractMessage {
    public static final int MSGTYPE_TEXT = 1;
    public static final int MSGTYPE_IMAGE = 3;
    public static final int MSGTYPE_FILE = 6;
    public static final int MSGTYPE_VOICE = 34;
    public static final int MSGTYPE_VERIFYMSG = 37;
    public static final int MSGTYPE_POSSIBLEFRIEND_MSG = 40;
    public static final int MSGTYPE_SHARECARD = 42;
    public static final int MSGTYPE_VIDEO = 43;
    public static final int MSGTYPE_EMOTICON = 47;
    public static final int MSGTYPE_LOCATION = 48;
    public static final int MSGTYPE_APP = 49;
    public static final int MSGTYPE_VOIPMSG = 50;
    public static final int MSGTYPE_STATUSNOTIFY = 51;
    public static final int MSGTYPE_VOIPNOTIFY = 52;
    public static final int MSGTYPE_VOIPINVITE = 53;
    public static final int MSGTYPE_MICROVIDEO = 62;
    public static final int MSGTYPE_SYSNOTICE = 9999;
    public static final int MSGTYPE_SYS = 10000;
    public static final int MSGTYPE_RECALLED = 10002;
    public static final int APPMSGTYPE_TEXT = 1;
    public static final int APPMSGTYPE_IMG = 2;
    public static final int APPMSGTYPE_AUDIO = 3;
    public static final int APPMSGTYPE_VIDEO = 4;
    public static final int APPMSGTYPE_URL = 5;
    public static final int APPMSGTYPE_ATTACH = 6;
    public static final int APPMSGTYPE_OPEN = 7;
    public static final int APPMSGTYPE_EMOJI = 8;
    public static final int APPMSGTYPE_VOICE_REMIND = 9;
    public static final int APPMSGTYPE_SCAN_GOOD = 10;
    public static final int APPMSGTYPE_GOOD = 13;
    public static final int APPMSGTYPE_EMOTION = 15;
    public static final int APPMSGTYPE_CARD_TICKET = 16;
    public static final int APPMSGTYPE_REALTIME_SHARE_LOCATION = 17;
    public static final String APPMSGTYPE_TRANSFERS = "2e3";
    public static final int APPMSGTYPE_RED_ENVELOPES = 2001;
    public static final int APPMSGTYPE_READER_TYPE = 100001;
    public static final int UPLOAD_MEDIA_TYPE_IMAGE = 1;
    public static final int UPLOAD_MEDIA_TYPE_VIDEO = 2;
    public static final int UPLOAD_MEDIA_TYPE_AUDIO = 3;
    public static final int UPLOAD_MEDIA_TYPE_ATTACHMENT = 4;
    public static final String CONTENT_DELIMITER = ":<br/>";
    @SerializedName(value="MsgType")
    public int MsgType;
    @SerializedName(value="FromUserName")
    public String FromUserName;
    @SerializedName(value="ToUserName")
    public String ToUserName;
    @SerializedName(value="Content")
    public String Content;
    @SerializedName(value="MsgId")
    public String MsgId;
    @SerializedName(value="CreateTime")
    public long CreateTime;
    @SerializedName(value="StatusNotifyCode")
    public int StatusNotifyCode;
    @SerializedName(value="StatusNotifyUserName")
    public String StatusNotifyUserName;
    @Expose(serialize=false, deserialize=false)
    public String text;
    public String src;
    public String groupId;
    public String MediaId;
    public int AppMsgType;
    public String FileName;
    public String EncryFileName;
    public int ImgHeight;
    public int ImgWidth;
    @Expose(serialize=false, deserialize=false)
    public AppMsgInfo AppMsgInfo;

    public CharSequence getText() {
        if (this.text == null) {
            this.parseContent();
        }
        return this.text;
    }

    public void parseContent() {
        String temp;
        this.text = this.MsgType == 47 ? new EmojiMsgXmlHandler(this).getHtml(this.getMediaLink()) : (this.MsgType == 3 ? new ImageMsgXmlHandler(this).getHtml(this.getMediaLink()) : (this.MsgType == 49 ? new AppMsgXmlHandler(this).getHtml(this.getMediaLink()) : (this.MsgType == 43 ? "\u89c6\u9891\u6d88\u606f\uff08\u8bf7\u5728\u624b\u673a\u4e0a\u67e5\u770b\uff09" : (this.MsgType == 34 ? "\u8bed\u97f3\u6d88\u606f\uff08\u8bf7\u5728\u624b\u673a\u4e0a\u67e5\u770b\uff09" : (this.MsgType == 62 ? "\u5c0f\u89c6\u9891\uff08\u8bf7\u5728\u624b\u673a\u4e0a\u67e5\u770b\uff09" : (this.MsgType == 37 ? "\u9a8c\u8bc1\u6d88\u606f\uff08\u8bf7\u5728\u624b\u673a\u4e0a\u67e5\u770b\uff09" : (this.MsgType == 53 ? "\u89c6\u9891\u9080\u8bf7\u6d88\u606f\uff08\u8bf7\u5728\u624b\u673a\u4e0a\u67e5\u770b\uff09" : (temp = StringUtils.decodeXml((String)this.Content)))))))));
    }

    public String getMediaLink() {
        if (WechatClient.getInstance() != null) {
            File dir = WechatClient.getInstance().getWorkDir("media");
            File f = null;
            if (this.MsgType == 3) {
                f = new File(dir, "image_" + this.MsgId + ".jpg");
            } else if (this.MsgType == 47) {
                f = new File(dir, "emotion_" + this.MsgId + ".gif");
            } else if (this.MsgType == 49 && 6 == this.AppMsgType && !StringUtils.isEmpty((CharSequence)this.FileName)) {
                f = new File(WechatClient.getInstance().getWorkDir("attach"), this.FileName);
            }
            String link = WechatClient.getInstance().getMediaLink(this, f);
            return link;
        }
        return null;
    }

    public long getTime() {
        return this.CreateTime * 1000L;
    }

    public String toString() {
        return String.format("type:%d, msg:%s", this.MsgType, this.text);
    }
}

