/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.wechat.model;

import io.github.biezhi.wechat.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    private static final Logger log = LoggerFactory.getLogger(Environment.class);
    private Properties props = new Properties();

    private Environment() {
    }

    public static Environment empty() {
        return new Environment();
    }

    public static Environment of(Properties props) {
        Environment environment = new Environment();
        environment.props = props;
        return environment;
    }

    public static Environment of(Map<String, String> map) {
        Environment environment = new Environment();
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            environment.props.setProperty(key, map.get(key));
        }
        return environment;
    }

    public Environment of(URL url) {
        String location = url.getPath();
        try {
            location = URLDecoder.decode(location, "utf-8");
            return Environment.of(url.openStream(), location);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    public static Environment of(File file) {
        try {
            return Environment.of(Files.newInputStream(Paths.get(file.getPath(), new String[0]), new OpenOption[0]), file.getName());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Environment of(String location) {
        if (location.startsWith("classpath:")) {
            location = location.substring("classpath:".length());
            return Environment.loadClasspath(location);
        }
        if (location.startsWith("file:")) {
            location = location.substring("file:".length());
            new Environment();
            return Environment.of(new File(location));
        }
        if (location.startsWith("url:")) {
            location = location.substring("url:".length());
            try {
                return new Environment().of(new URL(location));
            }
            catch (MalformedURLException e) {
                log.error("", (Throwable)e);
                return null;
            }
        }
        new Environment();
        return Environment.loadClasspath(location);
    }

    private static Environment loadClasspath(String classpath) {
        InputStream is;
        if (classpath.startsWith("/")) {
            classpath = classpath.substring(1);
        }
        if ((is = Environment.getDefault().getResourceAsStream(classpath)) == null) {
            return new Environment();
        }
        return Environment.of(is, classpath);
    }

    private static Environment of(InputStream is, String location) {
        if (is == null) {
            log.warn("InputStream not found: " + location);
            return null;
        }
        try {
            Environment environment = new Environment();
            environment.props.load(is);
            Environment environment2 = environment;
            return environment2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            Utils.closeQuietly(is);
        }
    }

    public static ClassLoader getDefault() {
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loader == null && (loader = Environment.class.getClassLoader()) == null) {
            try {
                loader = ClassLoader.getSystemClassLoader();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return loader;
    }

    public Environment set(String key, Object value) {
        this.props.put(key, value);
        return this;
    }

    public Environment add(String key, Object value) {
        this.props.put(key, value);
        return this;
    }

    public Environment addAll(Map<String, String> map) {
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            this.props.setProperty(key, map.get(key));
        }
        return this;
    }

    public Environment addAll(Properties props) {
        Set<String> keySet = props.stringPropertyNames();
        for (String key : keySet) {
            this.props.setProperty(key, props.getProperty(key));
        }
        return this;
    }

    public String get(String key) {
        return this.props.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public Object getObject(String key) {
        return this.props.get(key);
    }

    public Integer getInt(String key) {
        if (this.getObject(key) != null) {
            return Integer.valueOf(this.getObject(key).toString());
        }
        return null;
    }

    public Integer getInt(String key, int defaultValue) {
        if (this.getInt(key) != null) {
            return this.getInt(key);
        }
        return defaultValue;
    }

    public Long getLong(String key) {
        if (this.getObject(key) != null) {
            return Long.valueOf(this.getObject(key).toString());
        }
        return null;
    }

    public Long getLong(String key, long defaultValue) {
        if (this.getLong(key) != null) {
            return this.getLong(key);
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key) {
        if (this.getObject(key) != null) {
            return Boolean.valueOf(this.getObject(key).toString());
        }
        return null;
    }

    public Boolean getBoolean(String key, boolean defaultValue) {
        if (this.getBoolean(key) != null) {
            return this.getBoolean(key);
        }
        return defaultValue;
    }

    public Double getDouble(String key) {
        if (this.getObject(key) != null) {
            return Double.valueOf(this.getObject(key).toString());
        }
        return null;
    }

    public Double getDouble(String key, double defaultValue) {
        if (this.getDouble(key) != null) {
            return this.getDouble(key);
        }
        return defaultValue;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.props.size());
        Set<String> keySet = this.props.stringPropertyNames();
        for (String key : keySet) {
            map.put(key, this.props.getProperty(key));
        }
        return map;
    }

    public Properties props() {
        return this.props;
    }
}

