/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.wechat.model;

import cn.ieclipse.smartim.model.impl.AbstractContact;
import cn.ieclipse.util.StringUtils;
import io.github.biezhi.wechat.model.Const;
import java.util.List;

public class Contact
extends AbstractContact
implements Comparable<Contact> {
    public static final int CONTACTFLAG_CONTACT = 1;
    public static final int CONTACTFLAG_CHATCONTACT = 2;
    public static final int CONTACTFLAG_CHATROOMCONTACT = 4;
    public static final int CONTACTFLAG_BLACKLISTCONTACT = 8;
    public static final int CONTACTFLAG_DOMAINCONTACT = 16;
    public static final int CONTACTFLAG_HIDECONTACT = 32;
    public static final int CONTACTFLAG_FAVOURCONTACT = 64;
    public static final int CONTACTFLAG_3RDAPPCONTACT = 128;
    public static final int CONTACTFLAG_SNSBLACKLISTCONTACT = 256;
    public static final int CONTACTFLAG_NOTIFYCLOSECONTACT = 512;
    public static final int CONTACTFLAG_TOPCONTACT = 2048;
    public long Uin;
    public String UserName;
    public String NickName;
    public String HeadImgUrl;
    public int ContactFlag;
    public int MemberCount;
    public String RemarkName;
    public int HideInputBarFlag;
    public int Sex;
    public String Signature;
    public int VerifyFlag;
    public int OwnerUin;
    public String PYInitial;
    public String PYQuanPin;
    public String RemarkPYInitial;
    public String RemarkPYQuanPin;
    public int StarFriend;
    public int AppAccountFlag;
    public int Statues;
    public int AttrStatus;
    public String Province;
    public String City;
    public String Alias;
    public int SnsFlag;
    public int UniFriend;
    public String DisplayName;
    public int ChatRoomId;
    public String KeyWord;
    public String EncryChatRoomId;
    public List<Contact> MemberList;

    public String getName() {
        if (this.DisplayName != null && !this.DisplayName.isEmpty()) {
            return this.DisplayName;
        }
        if (this.RemarkName != null && !this.RemarkName.isEmpty()) {
            return this.RemarkName;
        }
        if (this.NickName != null && !this.NickName.isEmpty()) {
            return this.NickName;
        }
        if (this.isGroup()) {
            StringBuilder sb = new StringBuilder();
            int max = 3;
            int i = 0;
            while (i < 3 && i < this.MemberList.size()) {
                sb.append(this.MemberList.get(i).getName());
                sb.append('\u3001');
                ++i;
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString();
            }
        }
        return this.UserName;
    }

    public String getUin() {
        return this.UserName;
    }

    public Contact getMember(String uid) {
        if (!StringUtils.isEmpty(this.MemberList)) {
            for (Contact t : this.MemberList) {
                if (uid == null || !uid.equals(t.UserName)) continue;
                return t;
            }
        }
        return null;
    }

    @Override
    public int compareTo(Contact that) {
        if (this.isTop()) {
            return -1;
        }
        if (that.isTop()) {
            return 1;
        }
        int ret = super.compareTo((AbstractContact)that);
        return ret;
    }

    public boolean isTop() {
        return (this.ContactFlag & 0x800) != 0;
    }

    public String getPYInitial() {
        String py = StringUtils.isEmpty((CharSequence)this.RemarkPYInitial) ? this.PYInitial : this.RemarkPYInitial;
        return py;
    }

    public boolean match(String input) {
        boolean ret = false;
        if (!StringUtils.isEmpty((CharSequence)this.PYInitial)) {
            ret = this.PYInitial.toLowerCase().contains(input);
        }
        if (!ret && !StringUtils.isEmpty((CharSequence)this.PYQuanPin)) {
            ret = this.PYQuanPin.toLowerCase().contains(input);
        }
        if (!ret) {
            String name = this.getName().toLowerCase();
            ret = name.contains(input);
        }
        return ret;
    }

    public boolean isPublic() {
        return (this.VerifyFlag & 8) != 0;
    }

    public boolean is3rdApp() {
        return (this.ContactFlag & 0x80) != 0;
    }

    public boolean isSpecial() {
        return Const.API_SPECIAL_USER.contains(this.UserName);
    }

    public boolean isGroup() {
        return this.MemberCount > 0 || !StringUtils.isEmpty(this.MemberList) || this.UserName.startsWith("@@");
    }

    public boolean equals(Object obj) {
        if (obj instanceof Contact) {
            return this.getUin().equals(((Contact)obj).getUin());
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.getName();
    }
}

