/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.wechat.handler.msg;

import cn.ieclipse.util.StringUtils;
import io.github.biezhi.wechat.handler.msg.AbstractMsgXmlHandler;
import io.github.biezhi.wechat.model.WechatMessage;
import io.github.biezhi.wechat.model.xml.AppMsgInfo;
import java.io.File;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AppMsgXmlHandler
extends AbstractMsgXmlHandler {
    public AppMsgXmlHandler() {
    }

    public AppMsgXmlHandler(WechatMessage m) {
        super(m);
    }

    public String encode(File file, String mediaId) {
        Element root = DocumentHelper.createElement((String)"appmsg");
        root.addAttribute("appid", "wxeb7ec651dd0aefa9");
        root.addAttribute("sdkver", "");
        root.addElement("title").setText(file.getName());
        root.addElement("des");
        root.addElement("action");
        root.addElement("type").setText("6");
        root.addElement("content");
        root.addElement("url");
        root.addElement("rowurl");
        Element appattach = root.addElement("appattach");
        appattach.addElement("totallen").setText(String.valueOf(file.length()));
        appattach.addElement("attachid").setText(mediaId);
        root.addElement("extinfo");
        return root.asXML();
    }

    public AppMsgInfo decode() {
        AppMsgInfo info = new AppMsgInfo();
        try {
            Element node = this.root.element("appmsg");
            info.appId = node.attributeValue("appid");
            info.title = node.elementTextTrim("title");
            info.desc = node.elementTextTrim("des");
            String showType = node.elementTextTrim("showtype");
            String type = node.elementTextTrim("type");
            info.msgType = StringUtils.getInt((String)type, (int)0);
            info.showType = StringUtils.getInt((String)showType, (int)0);
            info.url = node.elementTextTrim("url");
            if (info.url != null) {
                info.url = StringUtils.decodeXml((String)info.url);
            }
            node = this.root.element("appinfo");
            info.appName = node.elementTextTrim("appname");
            if (this.message != null) {
                this.message.AppMsgInfo = info;
            }
        }
        catch (Exception e) {
            return null;
        }
        return info;
    }

    public String getHtml(String link) {
        AppMsgInfo info = this.decode();
        if (info == null) {
            return this.content;
        }
        String html = "";
        if (info.msgType == 6) {
            if (link != null) {
                info.url = link;
            }
            String size = "";
            if (!StringUtils.isEmpty((CharSequence)info.desc)) {
                size = "(" + size + ")";
            }
            html = String.format("\u63a5\u6536\u5fae\u4fe1\u6587\u4ef6 %s%s\u4fdd\u5b58\u4e8e <a href=\"%s\">%s</a>", info.title, size, info.url, info.url);
            return html;
        }
        html = String.format("<a href=\"%s\">%s%s</a>", info.url, info.title, info.desc);
        return html;
    }
}

