/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.wechat.handler.msg;

import cn.ieclipse.util.StringUtils;
import io.github.biezhi.wechat.api.WechatClient;
import io.github.biezhi.wechat.model.WechatMessage;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AbstractMsgXmlHandler {
    protected String content;
    protected Element root;
    protected Document document;
    protected String rootTag = "msg";
    protected WechatMessage message;
    protected boolean unescape = true;
    protected boolean parseXmlContent = true;

    public String getRootTag() {
        return this.rootTag;
    }

    public boolean isUnescape() {
        return this.unescape;
    }

    public boolean isParseXmlContent() {
        return this.parseXmlContent;
    }

    public AbstractMsgXmlHandler(WechatMessage message) {
        String content;
        this.message = message;
        String string = content = this.isUnescape() ? StringUtils.decodeXml((String)message.Content) : message.Content;
        if (this.isParseXmlContent() && !"\u8be5\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff0c\u8bf7\u5728\u624b\u673a\u4e0a\u67e5\u770b".equals(content)) {
            String regex = String.format(".*(<%s>.*</%s>).*", this.rootTag, this.rootTag);
            this.content = Pattern.compile(regex, 8).matcher(content.replaceAll("\\s*<br\\s?/>\\s*", "")).replaceAll("$1");
            try {
                this.document = DocumentHelper.parseText((String)this.content);
                this.root = this.document.getRootElement();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("xml content: " + content);
            }
        }
    }

    public AbstractMsgXmlHandler() {
        this.document = DocumentHelper.createDocument();
        this.root = this.document.addElement(this.rootTag);
    }

    public String getQueryString() {
        if (WechatClient.getInstance() != null) {
            return WechatClient.getInstance().getQueryString();
        }
        return null;
    }
}

