/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.wechat.handler;

import cn.ieclipse.smartim.model.IContact;
import cn.ieclipse.util.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.biezhi.wechat.handler.AbstractContactHandler;
import io.github.biezhi.wechat.model.Const;
import io.github.biezhi.wechat.model.Contact;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class WechatContactHandler
extends AbstractContactHandler<Contact> {
    private int memberCount;
    private List<Contact> publicUsersList;
    private List<Contact> groupList;
    private List<Contact> specialUsersList;
    private List<Contact> memberList;
    private List<Contact> allList;

    public Contact handle(JsonObject result) {
        return (Contact)this.gson.fromJson((JsonElement)result, Contact.class);
    }

    public List<Contact> handle(JsonArray array) {
        return (List)this.gson.fromJson((JsonElement)array, (Type)WechatContactHandler.type(List.class, new Type[]{Contact.class}));
    }

    public void handleContacts(JsonObject response, IContact user) {
        this.memberCount = response.get("MemberCount").getAsInt();
        JsonArray array = response.getAsJsonArray("MemberList");
        this.allList = this.handle(array);
        this.memberList = new ArrayList<Contact>();
        this.groupList = new ArrayList<Contact>();
        this.specialUsersList = new ArrayList<Contact>();
        this.publicUsersList = new ArrayList<Contact>();
        if (this.allList != null) {
            Contact my = null;
            for (Contact contact : this.allList) {
                if (contact.isPublic()) {
                    this.publicUsersList.add(contact);
                    continue;
                }
                if (Const.API_SPECIAL_USER.contains(contact.UserName)) {
                    this.specialUsersList.add(contact);
                    continue;
                }
                if (contact.UserName.startsWith("@@")) {
                    this.groupList.add(contact);
                    continue;
                }
                if (contact.UserName.equals(user.getUin())) {
                    my = contact;
                    continue;
                }
                this.memberList.add(contact);
            }
            if (my != null) {
                this.allList.remove(my);
            }
        }
    }

    public List<Contact> handleRecents(String chatSet, List<Contact> specials) {
        ArrayList<Contact> recentList = new ArrayList<Contact>();
        if (!StringUtils.isEmpty((CharSequence)chatSet)) {
            for (Contact c : this.allList) {
                if (!c.isTop()) continue;
                recentList.add(c);
            }
            String[] set = chatSet.split(",");
            int i = 0;
            while (i < set.length) {
                Contact c = this.find(set[i], this.allList);
                if (c == null) {
                    c = this.find(set[i], specials);
                }
                if (c != null && !recentList.contains(c)) {
                    recentList.add(c);
                }
                ++i;
            }
        }
        return recentList;
    }

    public List<Contact> getGroupList() {
        return this.groupList;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public List<Contact> getMemberList() {
        return this.memberList;
    }

    public List<Contact> getPublicUsersList() {
        return this.publicUsersList;
    }

    public List<Contact> getSpecialUsersList() {
        return this.specialUsersList;
    }

    public List<Contact> getAllList() {
        return this.allList;
    }

    public Contact find(String uin, List<Contact> list) {
        if (!StringUtils.isEmpty((CharSequence)uin) && !StringUtils.isEmpty(list)) {
            for (Contact c : list) {
                if (!c.UserName.equals(uin)) continue;
                return c;
            }
        }
        return null;
    }
}

