/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.wechat.api;

import cn.ieclipse.smartim.AbstractSmartClient;
import cn.ieclipse.smartim.callback.LoginCallback;
import cn.ieclipse.smartim.callback.ReceiveCallback;
import cn.ieclipse.smartim.exception.LogicException;
import cn.ieclipse.smartim.handler.MessageInterceptor;
import cn.ieclipse.smartim.model.IContact;
import cn.ieclipse.smartim.model.IMessage;
import cn.ieclipse.smartim.model.impl.AbstractContact;
import cn.ieclipse.smartim.model.impl.AbstractFrom;
import cn.ieclipse.smartim.model.impl.AbstractMessage;
import cn.ieclipse.util.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.biezhi.wechat.Utils;
import io.github.biezhi.wechat.api.WechatApi;
import io.github.biezhi.wechat.handler.DecodeMessageInterceptor;
import io.github.biezhi.wechat.handler.GroupMessageInterceptor;
import io.github.biezhi.wechat.handler.TypeMessageInterceptor;
import io.github.biezhi.wechat.handler.WechatContactHandler;
import io.github.biezhi.wechat.handler.WechatMessageHandler;
import io.github.biezhi.wechat.handler.msg.AppMsgXmlHandler;
import io.github.biezhi.wechat.model.Const;
import io.github.biezhi.wechat.model.Contact;
import io.github.biezhi.wechat.model.Environment;
import io.github.biezhi.wechat.model.GroupFrom;
import io.github.biezhi.wechat.model.UploadInfo;
import io.github.biezhi.wechat.model.UserFrom;
import io.github.biezhi.wechat.model.WechatMessage;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatClient
extends AbstractSmartClient {
    private static final Logger log = LoggerFactory.getLogger(WechatClient.class);
    private static WechatClient instance;
    private WechatApi api;
    private int memberCount;
    private List<Contact> publicUsersList;
    private List<Contact> groupList;
    private List<Contact> specialUsersList;
    private List<Contact> memberList;
    private List<Contact> recentList;
    private List<Contact> allList;
    private Contact accout;
    private WechatContactHandler contactHandler = new WechatContactHandler();
    private WechatMessageHandler msgHandler = new WechatMessageHandler();

    public static WechatClient getInstance() {
        return instance;
    }

    public WechatClient() {
        this(null);
    }

    public WechatClient(Proxy proxy) {
        WechatClient.initSSL();
        Environment environment = Environment.of("classpath:config.properties");
        this.api = new WechatApi(environment, proxy);
        this.addMessageInterceptor(new TypeMessageInterceptor());
        this.addMessageInterceptor(new GroupMessageInterceptor());
        this.addMessageInterceptor(new DecodeMessageInterceptor());
        instance = this;
    }

    private boolean waitForLogin() {
        int maxCount = 10;
        while (maxCount > 0) {
            Utils.sleep(maxCount < 5 ? 500 : 1000);
            log.info("[*] \u8bf7\u4f7f\u7528\u5fae\u4fe1\u626b\u63cf\u4e8c\u7ef4\u7801\u4ee5\u767b\u5f55 ... \n");
            if (!this.api.waitforlogin(1)) {
                --maxCount;
                continue;
            }
            log.info("[*] \u8bf7\u5728\u624b\u673a\u4e0a\u70b9\u51fb\u786e\u8ba4\u4ee5\u767b\u5f55 ... \n");
            if (!this.api.waitforlogin(0)) {
                --maxCount;
                continue;
            }
            return true;
        }
        return false;
    }

    public void login() {
        this.isLogin = false;
        try {
            log.info("[*] \u6b63\u5728\u83b7\u53d6 uuid ... ");
            this.api.getUUID();
            log.info("[*] \u6b63\u5728\u83b7\u53d6\u4e8c\u7ef4\u7801 ... \u6210\u529f\n");
            String qrCodePath = this.api.genqrcode();
            if (this.loginCallback != null) {
                this.loginCallback.onQrcode(qrCodePath);
            }
            if (this.waitForLogin() && this.api.login() && this.api.webwxinit()) {
                this.isLogin = true;
                this.accout = this.contactHandler.handle(this.api.account);
                if (this.loginCallback != null) {
                    this.loginCallback.onLogin(true, null);
                }
                return;
            }
        }
        catch (Exception e) {
            this.loginCallback.onLogin(false, e);
        }
    }

    public void close() {
        this.pollStarted = false;
        this.isClose = true;
        this.isLogin = false;
        this.api.close();
    }

    public void setWorkDir(File path) {
        super.setWorkDir(path);
        this.api.setWorkDir(path);
    }

    public void init() throws Exception {
        log.info("[*] \u5f00\u542f\u72b6\u6001\u901a\u77e5 ... ");
        if (!this.api.openStatusNotify()) {
            log.warn("\u72b6\u6001\u901a\u77e5\u6253\u5f00\u5931\u8d25");
        }
        log.info("[*] \u83b7\u53d6\u8054\u7cfb\u4eba ... ");
        JsonObject response = this.api.wxGetContact();
        if (response == null) {
            log.warn("\u83b7\u53d6\u8054\u7cfb\u4eba\u5931\u8d25");
            return;
        }
        this.contactHandler.handleContacts(response, this.getAccount());
        JsonArray array = this.api.batchGetContact(Arrays.asList(Const.API_SPECIAL_USER.toArray(new String[0])));
        List<Contact> special = this.contactHandler.handle(array);
        this.specialUsersList = special;
        this.groupList = this.contactHandler.getGroupList();
        if (this.groupList != null && !this.groupList.isEmpty()) {
            ArrayList<String> gids = new ArrayList<String>(this.groupList.size());
            for (Contact c : this.groupList) {
                gids.add(c.getUin());
            }
            JsonArray garray = this.api.batchGetContact(gids);
            this.groupList = this.contactHandler.handle(garray);
        }
        this.memberList = this.contactHandler.getMemberList();
        this.publicUsersList = this.contactHandler.getPublicUsersList();
        List<Contact> special2 = this.contactHandler.getSpecialUsersList();
        this.specialUsersList.addAll(special2);
        this.allList = this.contactHandler.getAllList();
        this.recentList = this.contactHandler.handleRecents(this.api.chatSet, this.specialUsersList);
        log.info("[*] \u5e94\u6709 [{}] \u4e2a\u8054\u7cfb\u4eba\uff0c\u8bfb\u53d6\u5230\u8054\u7cfb\u4eba [{}] \u4e2a\n", (Object)this.memberCount, (Object)this.memberList.size());
        log.info("[*] \u5171\u6709 [{}] \u4e2a\u7fa4 | [{}] \u4e2a\u76f4\u63a5\u8054\u7cfb\u4eba | [{}] \u4e2a\u7279\u6b8a\u8d26\u53f7 \uff5c [{}] \u4e2a\u516c\u4f17\u53f7/\u670d\u52a1\u53f7\n", new Object[]{this.groupList.size(), this.memberList.size(), this.specialUsersList.size(), this.publicUsersList.size()});
    }

    public void start() {
        if (this.receiveCallback != null && this.isLogin() && !this.pollStarted) {
            this.pollStarted = true;
            new Thread(){

                @Override
                public void run() {
                    int logout = 0;
                    block8: while (WechatClient.this.pollStarted) {
                        Utils.sleep(1000L);
                        try {
                            int[] checkResponse = WechatClient.this.api.synccheck();
                            int retcode = checkResponse[0];
                            int selector = checkResponse[1];
                            switch (retcode) {
                                case 1100: 
                                case 1101: 
                                case 1102: {
                                    if (++logout <= 3) continue block8;
                                    log.warn("[*] \u4f60\u5728\u624b\u673a\u4e0a\u767b\u51fa\u4e86\u5fae\u4fe1\n");
                                    WechatClient.this.close();
                                    if (WechatClient.this.receiveCallback == null) continue block8;
                                    WechatClient.this.receiveCallback.onReceiveError((Throwable)new LogicException(retcode, "[*] \u4f60\u5728\u624b\u673a\u4e0a\u767b\u51fa\u4e86\u5fae\u4fe1\n"));
                                    break;
                                }
                                case 0: {
                                    logout = 0;
                                    WechatClient.this.handle(selector);
                                    break;
                                }
                                default: {
                                    logout = 0;
                                    log.debug("wxSync: {}\n", (Object)WechatClient.this.api.wxSync().toString());
                                    break;
                                }
                            }
                        }
                        catch (TimeoutException checkResponse) {
                        }
                        catch (IOException e) {
                            boolean cfr_ignored_0 = e.getCause() instanceof TimeoutException;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }.start();
        }
    }

    private void handle(int selector) throws Exception {
        switch (selector) {
            case 2: {
                JsonObject dic = this.api.wxSync();
                if (dic == null) break;
                this.handle_msg(dic);
                break;
            }
            case 7: {
                this.api.wxSync();
                break;
            }
            case 0: {
                Utils.sleep(1000L);
                break;
            }
            case 4: {
                JsonObject dic = this.api.wxSync();
                if (dic == null) break;
                this.handle_mod(dic);
                break;
            }
        }
    }

    private void handle_mod(JsonObject dic) {
        block2: {
            log.debug("handle modify");
            try {
                this.handle_contact(dic);
                this.handle_msg(dic);
            }
            catch (Throwable e) {
                if (this.receiveCallback == null) break block2;
                this.receiveCallback.onReceiveError(e);
            }
        }
    }

    public Contact getGroupById(String gid) {
        JsonArray array;
        List<Contact> list;
        Contact group = null;
        for (Contact g : this.groupList) {
            if (gid == null || !gid.equals(g.UserName)) continue;
            group = g;
            break;
        }
        if (group == null && !StringUtils.isEmpty(list = this.contactHandler.handle(array = this.api.batchGetContact(Arrays.asList(gid))))) {
            group = list.get(0);
            this.groupList.add(group);
            if (this.modificationCallback != null) {
                this.modificationCallback.onContactChanged((IContact)group);
            }
        }
        return group;
    }

    private GroupFrom getGroupFrom(String gid, String uid) {
        GroupFrom from = new GroupFrom();
        Contact group = this.getGroupById(gid);
        if (group != null) {
            JsonArray array;
            List<Contact> list;
            from.setGroup(group);
            from.setUser(group.getMember(uid));
            if (from.getUser() == null && !StringUtils.isEmpty(list = this.contactHandler.handle(array = this.api.batchGetContact(Arrays.asList(gid))))) {
                int idx = this.groupList.indexOf(group);
                group = list.get(0);
                this.groupList.set(idx, group);
                from.setUser(group.getMember(uid));
                from.setNewbie(true);
            }
            return from;
        }
        return from;
    }

    public Contact getContact(String uid) {
        Contact contact = null;
        if (!uid.equals(this.getAccount().getUin())) {
            JsonArray array;
            List<Contact> list;
            for (Contact t : this.memberList) {
                if (uid == null || !uid.equals(t.UserName)) continue;
                contact = t;
                break;
            }
            if (contact == null) {
                for (Contact t : this.publicUsersList) {
                    if (uid == null || !uid.equals(t.UserName)) continue;
                    contact = t;
                    break;
                }
            }
            if (contact == null && !StringUtils.isEmpty(list = this.contactHandler.handle(array = this.api.batchGetContact(Arrays.asList(uid))))) {
                Contact c;
                contact = c = list.get(0);
                if (c.isPublic()) {
                    this.publicUsersList.add(c);
                } else {
                    this.memberList.add(c);
                }
                if (this.modificationCallback != null) {
                    this.modificationCallback.onContactChanged((IContact)c);
                }
            }
        }
        return contact;
    }

    public AbstractFrom getFrom(WechatMessage msg) {
        try {
            if (msg.groupId != null) {
                return this.getGroupFrom(msg.groupId, msg.src == null ? "" : msg.src);
            }
            UserFrom from = new UserFrom();
            if (msg.src.equals(this.accout.UserName)) {
                from.setUser(this.getContact(msg.ToUserName));
                from.setTarget((IContact)this.accout);
                from.setOut();
            } else {
                from.setUser(this.getContact(msg.src));
            }
            return from;
        }
        catch (Exception e) {
            if (this.receiveCallback != null) {
                this.receiveCallback.onReceiveError((Throwable)e);
            }
            return null;
        }
    }

    private void handle_contact(JsonObject dic) {
        JsonArray modContactList = dic.getAsJsonArray("ModContactList");
        for (JsonElement element : modContactList) {
            int i;
            JsonObject m = element.getAsJsonObject();
            String username = m.get("UserName").getAsString();
            if (username.startsWith("@@")) {
                boolean in_list = false;
                Contact newg = this.contactHandler.handle(m);
                if (!StringUtils.isEmpty(this.groupList)) {
                    i = 0;
                    while (i < this.groupList.size()) {
                        Contact g = this.groupList.get(i);
                        if (username.equals(g.UserName)) {
                            in_list = true;
                            g = newg;
                            this.groupList.set(i, newg);
                        }
                        ++i;
                    }
                }
                if (in_list) continue;
                this.groupList.add(newg);
                if (this.modificationCallback == null) continue;
                this.modificationCallback.onContactChanged((IContact)newg);
                continue;
            }
            if (!username.startsWith("@")) continue;
            Contact c = this.contactHandler.handle(m);
            boolean in_list = false;
            i = 0;
            while (i < this.memberList.size()) {
                Contact contact = this.memberList.get(i);
                if (username.equals(contact.UserName)) {
                    in_list = true;
                    contact = c;
                    this.memberList.set(i, contact);
                    break;
                }
                ++i;
            }
            if (in_list) continue;
            this.memberList.add(c);
            if (this.modificationCallback == null) continue;
            this.modificationCallback.onContactChanged((IContact)c);
        }
    }

    public IMessage handleMessage(String raw) {
        WechatMessage msg = this.msgHandler.handle(raw);
        if (!this.intercept((IMessage)msg)) {
            return msg;
        }
        return null;
    }

    public void handle_msg(JsonObject json) {
        List<WechatMessage> msgs = this.msgHandler.handleAll(json);
        for (WechatMessage msg : msgs) {
            boolean handled;
            if (msg.MsgType == 51 && msg.StatusNotifyCode == 4 && !StringUtils.isEmpty((CharSequence)msg.StatusNotifyUserName)) {
                this.recentList = this.contactHandler.handleRecents(msg.StatusNotifyUserName, this.specialUsersList);
                if (this.modificationCallback != null) {
                    this.modificationCallback.onContactChanged(null);
                }
            }
            if (!(handled = this.intercept((IMessage)msg))) {
                AbstractFrom from = this.getFrom(msg);
                if (from != null && from.getContact() != null && !this.getRecentList().contains(from.getContact())) {
                    this.getRecentList().add(0, (Contact)from.getContact());
                }
                this.notifyReceive(msg, from);
                continue;
            }
            log.info("intercept msg : " + (Object)((Object)msg));
        }
    }

    private boolean intercept(IMessage msg) {
        boolean ret = false;
        for (MessageInterceptor interceptor : this.interceptors) {
            if (!interceptor.handle(msg)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public int sendMessage(IMessage msg, IContact target) {
        if (target instanceof AbstractContact) {
            ((AbstractContact)target).setLastMessage(msg);
        }
        String uin = target.getUin();
        WechatMessage m = (WechatMessage)msg;
        String text = StringUtils.isEmpty((CharSequence)m.text) ? m.Content : m.text;
        try {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("Type", m.MsgType);
            body.put("Content", m.Content);
            body.put("FromUserName", m.FromUserName);
            body.put("ToUserName", m.ToUserName);
            body.put("MediaId", m.MediaId);
            JsonObject ret = this.api.wxSendMessage(body);
            this.notifySend(0, uin, text, null);
        }
        catch (Exception e) {
            this.notifySend(0, uin, text, e);
        }
        return 0;
    }

    public WechatMessage createMessage(int type, String msg, IContact target) {
        WechatMessage m = new WechatMessage();
        m.MsgType = type <= 0 ? 1 : type;
        m.Content = Utils.unicodeToUtf8(msg);
        m.FromUserName = this.getAccount().getUin();
        m.ToUserName = target.getUin();
        m.CreateTime = System.currentTimeMillis() / 1000L;
        return m;
    }

    public UploadInfo uploadMedia(File file, String mime, String media) {
        try {
            return this.api.wxUploadMedia(false, file, mime, media);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMediaLink(WechatMessage m, File file) {
        try {
            int msgType = m.MsgType;
            String msgId = m.MsgId;
            if (3 == msgType || 47 == msgType) {
                return this.api.wxGetMsgImg(msgId, file);
            }
            if (49 == msgType) {
                return this.api.wxGetMsgMedia(m, file);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String createFileMsgContent(File file, String mediaId) {
        return new AppMsgXmlHandler().encode(file, mediaId);
    }

    public int broadcast(String msg, Object ... targets) {
        int ret = 0;
        if (targets != null) {
            Object[] objectArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                Object target = objectArray[n2];
                if (target != null) {
                    try {
                        if (target instanceof IContact) {
                            this.api.wxSendMessage(msg, ((IContact)target).getUin());
                        }
                        ++ret;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        return ret;
    }

    public IContact getAccount() {
        return this.accout;
    }

    public List<Contact> getGroupList() {
        return this.groupList;
    }

    public List<Contact> getMemberList() {
        return this.memberList;
    }

    public List<Contact> getPublicUsersList() {
        return this.publicUsersList;
    }

    public List<Contact> getSpecialUsersList() {
        return this.specialUsersList;
    }

    public List<Contact> getRecentList() {
        return this.recentList;
    }

    public Contact find(String uin, List<Contact> list) {
        return this.contactHandler.find(uin, list);
    }

    public String getQueryString() {
        if (this.api != null && this.api.session != null) {
            return String.format("sid=%s&skey=%s", this.api.session.getSid(), this.api.session.getSkey());
        }
        return null;
    }

    public static void initSSL() {
        System.setProperty("https.protocols", "TLSv1");
        System.setProperty("jsse.enableSNIExtension", "false");
    }

    public static void main(String[] args) throws Exception {
        WechatClient client = new WechatClient();
        client.setWorkDir(new File("").getAbsoluteFile());
        client.setLoginCallback(new LoginCallback(){

            public void onQrcode(String path) {
                System.out.println("qrcode:" + path);
            }

            public void onLogin(boolean success, Exception e) {
                System.out.println("login:" + success + " exception:" + e);
            }
        });
        client.setReceiveCallback(new ReceiveCallback(){

            public void onReceiveMessage(AbstractMessage message, AbstractFrom from) {
                System.out.println(from);
                System.out.println(message);
            }

            public void onReceiveError(Throwable e) {
                System.out.println("receive error:" + e);
            }
        });
        System.out.println(System.currentTimeMillis());
        client.login();
        if (client.isLogin()) {
            client.init();
            client.start();
        }
    }
}

