/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.wechat.api;

import cn.ieclipse.smartim.exception.LogicException;
import cn.ieclipse.util.FileUtils;
import cn.ieclipse.util.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.biezhi.wechat.Utils;
import io.github.biezhi.wechat.api.CookieManager;
import io.github.biezhi.wechat.api.URLConst;
import io.github.biezhi.wechat.model.Const;
import io.github.biezhi.wechat.model.Environment;
import io.github.biezhi.wechat.model.Session;
import io.github.biezhi.wechat.model.UploadInfo;
import io.github.biezhi.wechat.model.WechatMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatApi {
    private static final Logger log = LoggerFactory.getLogger(WechatApi.class);
    protected Environment environment;
    protected String appid = "wx782c26e4c19acffb";
    protected String wxHost;
    protected String wxFileHost;
    protected String redirectUri;
    protected Session session;
    protected Map<String, Object> baseRequest;
    protected JsonObject synckeyDic;
    protected String synckey;
    protected String deviceId = "e" + System.currentTimeMillis();
    protected String userAgent = Const.API_USER_AGENT[new Random().nextInt(2)];
    protected String cookie;
    protected JsonObject account;
    protected String chatSet;
    private int readTimeout;
    private int connTimeout;
    private int writeTimeout;
    private int mediaIndex = 0;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private OkHttpClient client;
    private CookieManager cookieJar = new CookieManager();
    private File workDir;

    public WechatApi(Environment environment, Proxy proxy) {
        this.wxHost = environment.get("wxHost", "wx.qq.com");
        this.connTimeout = environment.getInt("http.conn-time-out", 10);
        this.readTimeout = environment.getInt("http.read-time-out", 60);
        this.writeTimeout = environment.getInt("http.write-time-out", 60);
        URLConst.init(this.wxHost);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cookieJar((CookieJar)this.cookieJar).connectTimeout((long)this.connTimeout, TimeUnit.SECONDS).writeTimeout((long)this.writeTimeout, TimeUnit.SECONDS).readTimeout((long)this.readTimeout, TimeUnit.SECONDS).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        if (proxy != null) {
            builder.proxy(proxy);
        }
        this.client = builder.build();
    }

    public boolean getUUID() {
        String url = "https://login.weixin.qq.com/jslogin";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appid", this.appid);
        params.put("fun", "new");
        params.put("lang", "zh_CN");
        params.put("_", String.valueOf(System.currentTimeMillis()));
        try {
            String response = this.doGet(url, params);
            String code = Utils.match("window.QRLogin.code = (\\d+);", response);
            if (Utils.isBlank(code)) {
                log.warn("\u83b7\u53d6UUID\u5931\u8d25");
                throw new LogicException(-1, "\u83b7\u53d6UUID\u5931\u8d25\uff0c\u63a5\u53e3\u54cd\u5e94\u7801\u4e3a\u7a7a");
            }
            if (!code.equals("200")) {
                log.warn("\u9519\u8bef\u7684\u72b6\u6001\u7801: {}", (Object)code);
                throw new LogicException(Integer.parseInt(code), "\u83b7\u53d6UUID\u5931\u8d25");
            }
            this.session = new Session();
            this.session.setUuid(Utils.match("window.QRLogin.uuid = \"(.*)\";", response));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public String genqrcode() {
        String url = "https://login.weixin.qq.com/qrcode/" + this.session.getUuid();
        File output = new File(this.workDir, "wechat.jpg");
        if (output.getParentFile() != null && !output.getParentFile().exists()) {
            output.getParentFile().mkdirs();
        }
        FormBody body = new FormBody.Builder().add("t", "webwx").add("_", String.valueOf(System.currentTimeMillis())).build();
        Request request = new Request.Builder().url(url).post((RequestBody)body).build();
        try {
            Response response = this.client.newCall(request).execute();
            byte[] bytes = response.body().bytes();
            FileOutputStream fos = new FileOutputStream(output);
            fos.write(bytes);
            fos.close();
        }
        catch (Exception e) {
            log.error("[*] \u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25", (Throwable)e);
        }
        return output.getAbsolutePath();
    }

    public boolean waitforlogin(int tip) {
        Utils.sleep(tip);
        String url = String.valueOf(URLConst.API.LOGIN.url()) + "?tip=%d&uuid=%s&_%s";
        url = String.format(url, tip, this.session.getUuid(), System.currentTimeMillis());
        String response = null;
        try {
            response = this.doGet(url, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (Utils.isBlank(response)) {
            log.warn("\u626b\u63cf\u4e8c\u7ef4\u7801\u9a8c\u8bc1\u5931\u8d25");
            throw new LogicException(-1, "\u626b\u63cf\u4e8c\u7ef4\u7801\u9a8c\u8bc1\u5931\u8d25");
        }
        String code = Utils.match("window.code=(\\d+);", response);
        if (Utils.isBlank(code)) {
            log.warn("\u626b\u63cf\u4e8c\u7ef4\u7801\u9a8c\u8bc1\u5931\u8d25");
            return false;
        }
        if (code.equals("201")) {
            return true;
        }
        if (code.equals("200")) {
            String r_uri;
            String pm = Utils.match("window.redirect_uri=\"(\\S+?)\";", response);
            this.redirectUri = r_uri = String.valueOf(pm) + "&fun=new";
            this.wxHost = r_uri.split("://")[1].split("/")[0];
            URLConst.init(this.wxHost);
            return true;
        }
        if (code.equals("408")) {
            log.warn("[\u767b\u9646\u8d85\u65f6] \n");
        } else {
            log.warn("[\u767b\u9646\u5f02\u5e38] \n");
        }
        return false;
    }

    public boolean login() throws Exception {
        Request.Builder requestBuilder = new Request.Builder().url(this.redirectUri);
        Request request = requestBuilder.build();
        log.debug("[*] \u8bf7\u6c42 => {}\n", (Object)request);
        Response response = this.client.newCall(request).execute();
        String body = response.body().string();
        Headers headers = response.headers();
        List cookies = headers.values("Set-Cookie");
        this.cookie = Utils.getCookie(cookies);
        log.info("[*] \u8bbe\u7f6ecookie [{}]", (Object)this.cookie);
        if (Utils.isBlank(body)) {
            throw new LogicException(-1, "\u767b\u5f55\u5931\u8d25");
        }
        String error = Utils.match("<error>(\\S+)</error>", body);
        if (!StringUtils.isEmpty((CharSequence)error)) {
            String code = Utils.match("<ret>(\\S+)</ret>", error);
            String msg = Utils.match("<message>(\\S+)</message>", error);
            if (!"0".equals(code) && msg != null) {
                throw new LogicException(Integer.parseInt(code), msg);
            }
        }
        this.session.setSkey(Utils.match("<skey>(\\S+)</skey>", body));
        this.session.setSid(Utils.match("<wxsid>(\\S+)</wxsid>", body));
        this.session.setUin(Utils.match("<wxuin>(\\S+)</wxuin>", body));
        this.session.setPassTicket(Utils.match("<pass_ticket>(\\S+)</pass_ticket>", body));
        this.baseRequest = Utils.createMap("Uin", Long.valueOf(this.session.getUin()), "Sid", this.session.getSid(), "Skey", this.session.getSkey(), "DeviceID", this.deviceId);
        File output = new File("temp.jpg");
        if (output.exists()) {
            output.delete();
        }
        return true;
    }

    public boolean webwxinit() {
        JsonObject response;
        if (this.session == null) {
            return false;
        }
        String url = String.valueOf(URLConst.API.INIT.url()) + "?pass_ticket=%s&skey=%s&r=%s";
        url = String.format(url, this.session.getPassTicket(), this.session.getSkey(), System.currentTimeMillis());
        Map<String, Object> param = Utils.createMap("BaseRequest", this.baseRequest);
        try {
            response = this.doPost(url, param).getAsJsonObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.account = response.get("User").getAsJsonObject();
        this.chatSet = response.get("ChatSet").getAsString();
        this.makeSynckey(response);
        JsonObject baseResponse = response.getAsJsonObject("BaseResponse");
        return baseResponse.get("Ret").getAsInt() == 0;
    }

    private void makeSynckey(JsonObject dic) {
        this.synckeyDic = dic.getAsJsonObject("SyncKey");
        StringBuffer synckey = new StringBuffer();
        JsonArray list = this.synckeyDic.getAsJsonArray("List");
        for (JsonElement element : list) {
            JsonObject item = element.getAsJsonObject();
            synckey.append("|" + item.get("Key").getAsInt() + "_" + item.get("Val").getAsInt());
        }
        this.synckey = synckey.length() > 0 ? synckey.substring(1) : "";
    }

    public boolean openStatusNotify() throws Exception {
        String url = String.valueOf(URLConst.API.STATUS_NOTIFY.url()) + "?lang=%s&pass_ticket=%s";
        url = String.format(url, "zh_CN", this.session.getPassTicket());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("BaseRequest", this.baseRequest);
        params.put("Code", 3);
        params.put("FromUserName", this.account.get("UserName").getAsString());
        params.put("ToUserName", this.account.get("UserName").getAsString());
        params.put("ClientMsgId", System.currentTimeMillis());
        JsonObject response = this.doPost(url, params).getAsJsonObject();
        if (response == null) {
            return false;
        }
        JsonObject baseResponse = response.getAsJsonObject("BaseResponse");
        return baseResponse.get("Ret").getAsInt() == 0;
    }

    public JsonObject wxGetContact() throws Exception {
        String url = String.valueOf(URLConst.API.GET_CONTACT.url()) + "?pass_ticket=%s&skey=%s&r=%s";
        url = String.format(url, this.session.getPassTicket(), this.session.getSkey(), System.currentTimeMillis());
        JsonObject response = this.doPost(url, null).getAsJsonObject();
        return response;
    }

    public JsonArray batchGetContact(List<String> groupIds) {
        String url = String.valueOf(URLConst.API.GET_CONTACT_BATCH.url()) + "?type=ex&r=%s&pass_ticket=%s";
        url = String.format(url, System.currentTimeMillis(), this.session.getPassTicket());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("BaseRequest", this.baseRequest);
        params.put("Count", groupIds.size());
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (String groupId : groupIds) {
            list.add(Utils.createMap("UserName", groupId, "EncryChatRoomId", ""));
        }
        params.put("List", list);
        try {
            JsonElement response = this.doPost(url, params);
            JsonObject dic = response.getAsJsonObject();
            return dic.get("ContactList").getAsJsonArray();
        }
        catch (Exception e) {
            return new JsonArray();
        }
    }

    public JsonObject wxSync() throws Exception {
        JsonObject baseResponse;
        String url = String.valueOf(URLConst.API.SYNC.url()) + "?sid=%s&skey=%s&pass_ticket=%s";
        url = String.format(url, this.session.getSid(), this.session.getSkey(), this.session.getPassTicket());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("BaseRequest", this.baseRequest);
        params.put("SyncKey", this.synckeyDic);
        params.put("rr", System.currentTimeMillis());
        JsonElement response = this.doPost(url, params);
        if (response == null) {
            return null;
        }
        JsonObject dic = response.getAsJsonObject();
        if (dic != null && (baseResponse = dic.getAsJsonObject("BaseResponse")) != null && baseResponse.get("Ret").getAsInt() == 0) {
            this.makeSynckey(dic);
        }
        return dic;
    }

    public boolean snapshot() {
        return false;
    }

    public int[] synccheck() throws Exception {
        String url = URLConst.SYNC_CHECK;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("r", String.valueOf(System.currentTimeMillis()) + Utils.getRandomNumber(5));
        params.put("sid", this.session.getSid());
        params.put("uin", this.session.getUin());
        params.put("skey", this.session.getSkey());
        params.put("deviceid", this.deviceId);
        params.put("synckey", this.synckey);
        params.put("_", System.currentTimeMillis());
        String response = this.doGet(false, url, this.cookie, params);
        int[] arr = new int[]{-1, -1};
        if (Utils.isBlank(response)) {
            return arr;
        }
        String retcode = Utils.match("retcode:\"(\\d+)\",", response);
        String selector = Utils.match("selector:\"(\\d+)\"}", response);
        if (retcode != null && selector != null) {
            arr[0] = Integer.parseInt(retcode);
            arr[1] = Integer.parseInt(selector);
        }
        return arr;
    }

    public JsonObject wxSendMessage(String msg, String to) throws Exception {
        String url = String.valueOf(URLConst.API.SEND_MSG.url()) + "?pass_ticket=%s";
        url = String.format(url, this.session.getPassTicket());
        String clientMsgId = String.valueOf(System.currentTimeMillis()) + Utils.getRandomNumber(5);
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("BaseRequest", this.baseRequest);
        HashMap<String, Object> Msg = new HashMap<String, Object>();
        Msg.put("Type", 1);
        Msg.put("Content", Utils.unicodeToUtf8(msg));
        Msg.put("FromUserName", this.account.get("UserName").getAsString());
        Msg.put("ToUserName", to);
        Msg.put("LocalID", clientMsgId);
        Msg.put("ClientMsgId", clientMsgId);
        params.put("Msg", Msg);
        JsonElement response = this.doPost(url, params);
        if (response == null) {
            return null;
        }
        return response.getAsJsonObject();
    }

    public JsonObject wxSendMessage(Map<String, Object> Msg) throws Exception {
        String url = String.valueOf(URLConst.API.SEND_MSG.url()) + "?pass_ticket=%s";
        url = String.format(url, this.session.getPassTicket());
        String clientMsgId = String.valueOf(System.currentTimeMillis() / 1000L) + Utils.getRandomNumber(6);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("BaseRequest", this.baseRequest);
        int type = (Integer)Msg.get("Type");
        if (type != 1) {
            if (type == 3) {
                url = String.valueOf(URLConst.API.SEND_IMG.url()) + "?fun=async&f=json&pass_ticket=" + this.session.getPassTicket();
                params.put("Scene", 0);
            } else if (type == 47) {
                url = String.valueOf(URLConst.API.SEND_EMOTION.url()) + "?fun=sys&f=json&pass_ticket=" + this.session.getPassTicket();
                params.put("Scene", 0);
                if (Msg.get("EmojiFlag") == null) {
                    Msg.put("EmojiFlag", 2);
                }
            } else if (type == 6) {
                url = String.valueOf(URLConst.API.SEND_FILE.url()) + "?fun=async&f=json&pass_ticket=" + this.session.getPassTicket();
                params.put("Scene", 0);
            }
        }
        if (Msg.get("LocalID") == null) {
            Msg.put("LocalID", clientMsgId);
        }
        if (Msg.get("ClientMsgId") == null) {
            Msg.put("ClientMsgId", clientMsgId);
        }
        params.put("Msg", Msg);
        JsonElement response = this.doPost(url, params);
        if (response == null) {
            return null;
        }
        return response.getAsJsonObject();
    }

    public UploadInfo wxUploadMedia(boolean enableLog, File file, String mime, String media) throws Exception {
        JsonObject obj;
        String url = URLConst.MEDIA_UPLOAD;
        Cookie c = this.cookieJar.getFirstCookie("webwx_data_ticket");
        String webwx_data_ticket = "";
        if (c != null) {
            webwx_data_ticket = c.value();
        }
        long len = file.length();
        String ext = FileUtils.getExtension((String)file.getName()).toLowerCase();
        String mimeType = StringUtils.isEmpty((CharSequence)mime) ? "application/octet-stream" : mime;
        String mediaType = media;
        if (mediaType == null) {
            mediaType = "doc";
            if (Arrays.asList("png", "jpg", "jpeg", "bmp").contains(ext)) {
                mimeType = "image/" + ext;
                mediaType = "pic";
            }
        }
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("BaseRequest", this.baseRequest);
        req.put("ClientMediaId", String.valueOf(System.currentTimeMillis()) + Utils.getRandomNumber(5));
        req.put("TotalLen", len);
        req.put("StartPos", 0);
        req.put("DataLen", len);
        req.put("MediaType", 4);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("f", "json");
        params.put("id", "WU_FILE_" + this.mediaIndex++);
        params.put("type", mimeType);
        params.put("lastModifiedDate", new Date(file.lastModified()).toString());
        params.put("size", String.valueOf(len));
        params.put("mediatype", mediaType);
        params.put("uploadmediarequest", new Gson().toJson(req));
        params.put("webwx_data_ticket", webwx_data_ticket);
        params.put("pass_ticket", this.session.getPassTicket());
        Request.Builder requestBuilder = new Request.Builder().url(url);
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        for (String key : params.keySet()) {
            Object object = params.get(key);
            builder.addFormDataPart(key, object.toString());
        }
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (File)file);
        builder.addFormDataPart("filename", file.getName(), fileBody);
        MultipartBody body = builder.build();
        Request request = requestBuilder.post((RequestBody)body).build();
        if (enableLog) {
            log.debug("[*] \u8bf7\u6c42 => {}\n", (Object)request);
        }
        Response response = this.client.newCall(request).execute();
        String result = response.body().string();
        if (enableLog) {
            log.debug("[*] \u54cd\u5e94 => {}", (Object)body);
        }
        if ((obj = new JsonParser().parse(result).getAsJsonObject()).getAsJsonObject("BaseResponse").get("Ret").getAsInt() == 0) {
            UploadInfo info = new UploadInfo();
            info.MediaId = obj.get("MediaId").getAsString();
            try {
                info.CDNThumbImgHeight = obj.get("CDNThumbImgHeight").getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                info.CDNThumbImgWidth = obj.get("CDNThumbImgWidth").getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            info.EncryFileName = obj.get("EncryFileName").getAsString();
            return info;
        }
        return null;
    }

    public String wxGetIcon(String username, File file) throws Exception {
        String url = String.valueOf(URLConst.API.GET_ICON.url()) + "?username=" + username + "&skey=" + this.session.getSkey();
        if (file == null) {
            return url;
        }
        return this.doDown(false, url, this.cookie, file, null);
    }

    public String wxGetHead(String username, File file) throws Exception {
        String url = String.valueOf(URLConst.API.GET_HEAD.url()) + "?username=" + username + "&skey=" + this.session.getSkey();
        if (file == null) {
            return url;
        }
        return this.doDown(false, url, this.cookie, file, null);
    }

    public String wxGetMsgImg(String msgId, File file) throws Exception {
        String url = String.valueOf(URLConst.API.GET_IMG.url()) + "?MsgID=" + msgId + "&skey=" + this.session.getSkey();
        if (file == null) {
            return url;
        }
        return this.doDown(false, String.valueOf(url) + "&type=big", this.cookie, file, null);
    }

    public String wxGetMsgMedia(WechatMessage m, File file) throws Exception {
        Cookie c = this.cookieJar.getFirstCookie("webwx_data_ticket");
        String dt = null;
        if (c != null) {
            dt = c.value();
        }
        String skey = "";
        String pt = "";
        if (this.session != null) {
            skey = this.session.getSkey();
            pt = this.session.getPassTicket();
        }
        String url = String.format(String.valueOf(URLConst.MEDIA_GET) + "?MsgID=%s&skey=%s&sender=%s&mediaid=%s&encryfilename=%s&pass_ticket=%s&webwx_data_ticket=%s", m.MsgId, skey, m.FromUserName, m.MediaId, m.EncryFileName, pt, dt);
        if (file == null) {
            return url;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.doDown(false, url, this.cookie, file, params);
    }

    public void sendText(String msg, String uid) throws Exception {
        this.wxSendMessage(msg, uid);
    }

    public void logout() {
        if (this.session == null) {
            return;
        }
        String url = String.valueOf(URLConst.API.LOGOUT.url()) + "?redirect=0&type=1&skey=" + this.session.getSkey();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sid", this.session.getSid());
        params.put("uin", this.session.getUin());
        try {
            this.doPost(url, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String doGet(String url, Map<String, Object> params) throws Exception {
        return this.doGet(true, url, null, params);
    }

    private String doGet(boolean enableLog, String url, String cookie, Map<String, Object> params) throws Exception {
        String query;
        String string = query = params == null ? null : StringUtils.getMapBody(params, null, (boolean)true);
        if (!StringUtils.isEmpty((CharSequence)query)) {
            url = url.contains("=") ? String.valueOf(url) + "&" + query : String.valueOf(url) + "?" + query;
        }
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (cookie != null) {
            requestBuilder.addHeader("Cookie", this.cookie);
        }
        Request request = requestBuilder.build();
        if (enableLog) {
            log.debug("[*] \u8bf7\u6c42 => {}\n", (Object)request);
        }
        Response response = this.client.newCall(request).execute();
        String body = response.body().string();
        if (enableLog) {
            log.debug("[*] \u54cd\u5e94 => {}", (Object)body);
        }
        return body;
    }

    private JsonElement doPost(String url, Object object) throws Exception {
        String bodyJson = null;
        RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)"");
        if (object != null) {
            bodyJson = Utils.toJson(object);
            requestBody = RequestBody.create((MediaType)JSON, (String)bodyJson);
        }
        Request.Builder requestBuilder = new Request.Builder().url(url).post(requestBody);
        if (this.cookie != null) {
            requestBuilder.addHeader("Cookie", this.cookie);
        }
        Request request = requestBuilder.build();
        log.debug("[*] \u8bf7\u6c42 => {}\n", (Object)request);
        Response response = this.client.newCall(request).execute();
        String body = response.body().string();
        if (body != null && body.length() <= 300) {
            log.debug("[*] \u54cd\u5e94 => {}", (Object)body);
        }
        return new JsonParser().parse(body);
    }

    private String doDown(boolean enableLog, String url, String cookie, File file, Map<String, Object> params) throws Exception {
        String query;
        String string = query = params == null ? null : StringUtils.getMapBody(params, null, (boolean)true);
        if (!StringUtils.isEmpty((CharSequence)query)) {
            url = url.contains("=") ? String.valueOf(url) + "&" + query : String.valueOf(url) + "?" + query;
        }
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (cookie != null) {
            requestBuilder.addHeader("Cookie", this.cookie);
        }
        Request request = requestBuilder.build();
        if (enableLog) {
            log.debug("[*] \u8bf7\u6c42 => {}\n", (Object)request);
        }
        Response response = this.client.newCall(request).execute();
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (response.isSuccessful()) {
            int len;
            InputStream is = response.body().byteStream();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            is.close();
            fos.close();
            return StringUtils.file2url((String)file.getAbsolutePath());
        }
        return null;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void close() {
        this.cookie = null;
        if (this.client != null) {
            this.client.dispatcher().cancelAll();
        }
        this.logout();
    }

    public static class BaseRequest {
        public long Uin;
        public String Sid;
        public String Skey;
        public String DeviceID;
    }

    public static class BaseResponse {
        public int Ret;
        public String ErrMsg;
    }
}

