/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.wechat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    private Utils() {
    }

    public static Map<String, Object> createMap(Object ... values) {
        HashMap<String, Object> map = new HashMap<String, Object>(values.length / 2);
        int i = 0;
        while (i < values.length) {
            map.put(values[i].toString(), values[++i]);
            ++i;
        }
        return map;
    }

    public static String emptyOr(String str1, String str2) {
        if (Utils.isBlank(str1)) {
            return str2;
        }
        return str1;
    }

    public static void sleep(long timeout) {
        try {
            TimeUnit.MILLISECONDS.sleep(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String match(String p, String str) {
        Pattern pattern = Pattern.compile(p);
        Matcher m = pattern.matcher(str);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isBlank(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean isNotBlank(String str) {
        return !Utils.isBlank(str) && !"null".equalsIgnoreCase(str);
    }

    public static String getRandomNumber(int size) {
        String num = "";
        int i = 0;
        while (i < size) {
            double a = Math.random() * 9.0;
            a = Math.ceil(a);
            int randomNum = new Double(a).intValue();
            num = String.valueOf(num) + randomNum;
            ++i;
        }
        return num;
    }

    public static String toJson(Object o) {
        try {
            return gson.toJson(o);
        }
        catch (Exception e) {
            log.error("Json\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        try {
            return (T)gson.fromJson(json, classOfT);
        }
        catch (Exception e) {
            log.error("Json\u53cd\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String unicodeToUtf8(String str) {
        try {
            if (str == null) {
                return str;
            }
            if (str.indexOf("\\u") == -1) {
                return str;
            }
            byte[] utf8 = str.getBytes("UTF-8");
            str = new String(utf8, "UTF-8");
            return str;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return str;
        }
    }

    public static String getCookie(List<String> cookies) {
        StringBuilder sBuffer = new StringBuilder();
        for (String value : cookies) {
            if (value == null) continue;
            String cookie = value.substring(0, value.indexOf(";") + 1);
            sBuffer.append(cookie);
        }
        return sBuffer.toString();
    }
}

