/*
 * Decompiled with CFR 0.152.
 */
package cn.ieclipse.util;

import java.util.Iterator;
import java.util.regex.Pattern;

public class TextUtils {
    private static String[] EMPTY_STRING_ARRAY = new String[0];

    private TextUtils() {
    }

    public static void getChars(CharSequence s, int start, int end, char[] dest, int destoff) {
        Class<?> c = s.getClass();
        if (c == String.class) {
            ((String)s).getChars(start, end, dest, destoff);
        } else if (c == StringBuffer.class) {
            ((StringBuffer)s).getChars(start, end, dest, destoff);
        } else if (c == StringBuilder.class) {
            ((StringBuilder)s).getChars(start, end, dest, destoff);
        } else {
            for (int i = start; i < end; ++i) {
                dest[destoff++] = s.charAt(i);
            }
        }
    }

    public static String join(CharSequence delimiter, Object[] tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        Iterator it = tokens.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(delimiter);
                sb.append(it.next());
            }
        }
        return sb.toString();
    }

    public static String[] split(String text, String expression) {
        if (text.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return text.split(expression, -1);
    }

    public static String[] split(String text, Pattern pattern) {
        if (text.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return pattern.split(text, -1);
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static int getTrimmedLength(CharSequence s) {
        int end;
        int start;
        int len = s.length();
        for (start = 0; start < len && s.charAt(start) <= ' '; ++start) {
        }
        for (end = len; end > start && s.charAt(end - 1) <= ' '; --end) {
        }
        return end - start;
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            if (a instanceof String && b instanceof String) {
                return a.equals(b);
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String htmlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isGraphic(CharSequence str) {
        int cp;
        int len = str.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            int gc = Character.getType(cp);
            if (gc == 15 || gc == 16 || gc == 19 || gc == 0 || gc == 13 || gc == 14 || gc == 12) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isGraphic(char c) {
        int gc = Character.getType(c);
        return gc != 15 && gc != 16 && gc != 19 && gc != 0 && gc != 13 && gc != 14 && gc != 12;
    }

    public static boolean isDigitsOnly(CharSequence str) {
        int cp;
        int len = str.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            if (Character.isDigit(cp)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintableAscii(char c) {
        int asciiFirst = 32;
        int asciiLast = 126;
        return ' ' <= c && c <= '~' || c == '\r' || c == '\n';
    }

    public static boolean isPrintableAsciiOnly(CharSequence str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (TextUtils.isPrintableAscii(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean delimitedStringContains(String delimitedString, char delimiter, String item) {
        if (TextUtils.isEmpty(delimitedString) || TextUtils.isEmpty(item)) {
            return false;
        }
        int pos = -1;
        int length = delimitedString.length();
        while ((pos = delimitedString.indexOf(item, pos + 1)) != -1) {
            if (pos > 0 && delimitedString.charAt(pos - 1) != delimiter) continue;
            int expectedDelimiterPos = pos + item.length();
            if (expectedDelimiterPos == length) {
                return true;
            }
            if (delimitedString.charAt(expectedDelimiterPos) != delimiter) continue;
            return true;
        }
        return false;
    }

    public static long packRangeInLong(int start, int end) {
        return (long)start << 32 | (long)end;
    }

    public static int unpackRangeStartFromLong(long range) {
        return (int)(range >>> 32);
    }

    public static int unpackRangeEndFromLong(long range) {
        return (int)(range & 0xFFFFFFFFL);
    }

    public static class SimpleStringSplitter
    implements StringSplitter,
    Iterator<String> {
        private String mString;
        private char mDelimiter;
        private int mPosition;
        private int mLength;

        public SimpleStringSplitter(char delimiter) {
            this.mDelimiter = delimiter;
        }

        @Override
        public void setString(String string) {
            this.mString = string;
            this.mPosition = 0;
            this.mLength = this.mString.length();
        }

        @Override
        public Iterator<String> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.mPosition < this.mLength;
        }

        @Override
        public String next() {
            int end = this.mString.indexOf(this.mDelimiter, this.mPosition);
            if (end == -1) {
                end = this.mLength;
            }
            String nextString = this.mString.substring(this.mPosition, end);
            this.mPosition = end + 1;
            return nextString;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface StringSplitter
    extends Iterable<String> {
        public void setString(String var1);
    }
}

