/*
 * Decompiled with CFR 0.152.
 */
package cn.ieclipse.util;

import cn.ieclipse.util.TextUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class StringUtils {
    public static String getRequestParamValue(Object obj, String charset) {
        if (obj == null) {
            return "";
        }
        String value = obj instanceof List ? StringUtils.join((CharSequence)",", (List)obj) : (obj instanceof Object[] ? StringUtils.join((CharSequence)",", (Object[])obj) : obj.toString());
        try {
            return URLEncoder.encode(value, charset);
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static String getRequestBody(Object input, String charset, boolean excludeNull) {
        String encode;
        String string = encode = TextUtils.isEmpty(charset) ? "UTF-8" : charset;
        if (input == null) {
            return null;
        }
        if (input instanceof Map) {
            return StringUtils.getMapBody((Map)input, encode, excludeNull);
        }
        StringBuilder sb = new StringBuilder();
        Field[] field = input.getClass().getFields();
        for (int i = 0; i < field.length && field.length > 0; ++i) {
            Object val;
            field[i].setAccessible(true);
            String name = field[i].getName();
            try {
                val = field[i].get(input);
            }
            catch (Exception e) {
                continue;
            }
            if (val == null && excludeNull) continue;
            sb.append(name);
            sb.append('=');
            sb.append(StringUtils.getRequestParamValue(val, encode));
            sb.append('&');
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getMapBody(Map map, String charset, boolean excludeNull) {
        StringBuilder sb = new StringBuilder();
        String encode = TextUtils.isEmpty(charset) ? "UTF-8" : charset;
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (value == null && excludeNull) continue;
            sb.append(key);
            sb.append('=');
            sb.append(StringUtils.getRequestParamValue(value, encode));
            sb.append('&');
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Deprecated
    public static String getRequestParam(Object object, String encoding) {
        return StringUtils.getRequestBody(object, encoding, true);
    }

    public static String join(CharSequence delimiter, String ... arrays) {
        return TextUtils.join(delimiter, arrays);
    }

    public static String join(CharSequence delimiter, Object[] tokens) {
        return TextUtils.join(delimiter, tokens);
    }

    public static String join(CharSequence delimiter, List<?> list) {
        return TextUtils.join(delimiter, list.toArray());
    }

    public static boolean isEmpty(CharSequence text) {
        return TextUtils.isEmpty(text);
    }

    public static boolean isEmpty(Collection<?> list) {
        return list == null || list.isEmpty();
    }

    public static String encodeXml(String src) {
        if (src == null) {
            return src;
        }
        return src.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String decodeXml(String src) {
        if (src == null) {
            return src;
        }
        return src.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
    }

    public static String file2url(String path) {
        if (path == null) {
            return null;
        }
        String prefix = path.startsWith("/") ? "file://" : "file:///";
        return prefix + path.replaceAll("\\\\", "/");
    }

    public static String file2string(Class<?> clazz, String name) {
        try {
            InputStream is = clazz.getResourceAsStream(name);
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            is.close();
            return new String(buffer);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long getLong(String v, long dft) {
        if (StringUtils.isEmpty(v)) {
            return dft;
        }
        try {
            return Long.parseLong(v);
        }
        catch (Exception e) {
            return dft;
        }
    }

    public static int getInt(String v, int dft) {
        if (StringUtils.isEmpty(v)) {
            return dft;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception e) {
            return dft;
        }
    }

    public static boolean getBool(String v, boolean dft) {
        if (StringUtils.isEmpty(v)) {
            return dft;
        }
        try {
            return Boolean.parseBoolean(v);
        }
        catch (Exception e) {
            return dft;
        }
    }
}

