/*
 * Decompiled with CFR 0.152.
 */
package cn.ieclipse.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class LimitArrayList<E>
extends ArrayList<E> {
    private int limit = 0;

    public LimitArrayList(int limit) {
        this.limit = limit;
    }

    @Override
    public boolean add(E e) {
        if (this.size() >= this.limit) {
            this.remove(0);
        }
        return super.add(e);
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c != null) {
            if (c.size() < this.limit) {
                int n = c.size() + this.size() - this.limit;
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        this.remove(0);
                    }
                }
                return super.addAll(c);
            }
            this.clear();
            int n = c.size() - this.limit;
            Iterator<E> iterator = c.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                E e = iterator.next();
                if (i >= n) {
                    this.add(e);
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    public int getLimit() {
        return this.limit;
    }
}

