/*
 * Decompiled with CFR 0.152.
 */
package cn.ieclipse.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtils {
    private static final int BUFFER_SIZE = 8192;

    private IOUtils() {
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                closeable = null;
            }
            catch (IOException iOException) {
            }
            finally {
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void closeStream(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static int copyStream(InputStream is, OutputStream os) throws IOException {
        int total = 0;
        int read = 0;
        byte[] buf = new byte[8192];
        while ((read = is.read(buf)) > 0) {
            os.write(buf, 0, read);
            total += read;
        }
        return total;
    }

    public static InputStream readSocketStream(InputStream is, int length) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copyStream(is, bos);
        byte[] data = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        IOUtils.closeStream(is);
        IOUtils.closeStream(bos);
        return bis;
    }

    public static byte[] read2Byte(InputStream is) {
        int read = -1;
        int total = -1;
        byte[] data = null;
        if (is != null) {
            try {
                total = is.available();
                data = new byte[total];
                read = is.read(data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return data;
    }
}

