/*
 * Decompiled with CFR 0.152.
 */
package cn.ieclipse.util;

import cn.ieclipse.util.FileUtils;
import cn.ieclipse.util.IOUtils;
import cn.ieclipse.util.LimitArrayList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;

public class FileStorage {
    private static final String cr = System.getProperty("line.separator");
    private boolean persistent;
    private String path;
    private LimitArrayList<String> queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStorage(int size, String path) {
        this.queue = new LimitArrayList(size);
        this.path = path;
        BufferedReader br = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charset.forName("utf-8")));
                Iterator itr = br.lines().iterator();
                while (itr.hasNext()) {
                    this.queue.add((String)itr.next());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                IOUtils.close(br);
            }
        }
    }

    public synchronized String read(int line) throws IOException {
        return (String)this.queue.get(line);
    }

    public synchronized boolean append(String content) {
        return this.queue.add(content);
    }

    public synchronized int getLines() {
        return this.queue.size();
    }

    public synchronized List<String> getLast(int count) {
        int size = this.getLines();
        if (size <= count) {
            return this.queue;
        }
        return this.queue.subList(size - count, size - 1);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public synchronized boolean flush() {
        try {
            File f = new File(this.path);
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            if (!f.exists()) {
                FileUtils.mkFile(f, true);
            }
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), Charset.forName("utf-8")));
            for (int i = 0; i < this.queue.size(); ++i) {
                if (i > 0) {
                    bw.newLine();
                }
                String line = (String)this.queue.get(i);
                bw.write(line);
                bw.flush();
            }
            IOUtils.close(bw);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized void release() {
        File f;
        if (this.queue != null) {
            this.queue.clear();
        }
        if ((f = new File(this.path)).exists()) {
            f.delete();
        }
    }

    public static void main(String[] args) throws Exception {
        FileStorage fs = new FileStorage(3, "test.txt");
        fs.append("\u4e2d\u6587abc\u54c8\u54c8");
        String line = fs.read(0);
        System.out.println("lines:" + line);
        fs.flush();
    }
}

