/*
 * Decompiled with CFR 0.152.
 */
package cn.ieclipse.smartim.robot;

import cn.ieclipse.smartim.robot.IRobot;
import cn.ieclipse.util.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.Expose;
import java.io.Serializable;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class TuringRobot
implements IRobot {
    public static final String URL = "http://www.tuling123.com/openapi/api";
    public static final String TURING_API_V2 = "http://openapi.tuling123.com/openapi/api/v2";
    public static int TIMEOUT = 3;
    private String name;
    private OkHttpClient client;
    private Gson gson = new Gson();

    public TuringRobot(String name, int timeout, Proxy proxy) {
        this.name = name;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (timeout > 0) {
            builder.connectTimeout((long)timeout, TimeUnit.SECONDS);
        } else {
            builder.connectTimeout((long)TIMEOUT, TimeUnit.SECONDS);
        }
        if (proxy != null) {
            builder.proxy(proxy);
        }
        this.client = builder.build();
    }

    public void setRobotName(String name) {
        this.name = name;
    }

    @Override
    public String getRobotName() {
        return this.name;
    }

    @Override
    public String getRobotAnswer(String question, Map<String, Object> params) throws Exception {
        try {
            if (params == null) {
                return null;
            }
            OkHttpClient client = this.client;
            String body = new Gson().toJson(params);
            Request request = new Request.Builder().url(TURING_API_V2).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body)).build();
            String result = client.newCall(request).execute().body().string();
            JsonObject obj = new JsonParser().parse(result).getAsJsonObject();
            if (obj != null && obj.has("results")) {
                JsonElement ele = obj.get("results");
                JsonObject ret = null;
                if (ele instanceof JsonObject) {
                    ret = ele.getAsJsonObject();
                } else if (ele instanceof JsonArray) {
                    ret = ele.getAsJsonArray().get(0).getAsJsonObject();
                }
                if (ret != null && ret.has("values")) {
                    String type = ret.get("resultType").getAsString();
                    ret = ret.getAsJsonObject("values");
                    Response response = (Response)this.gson.fromJson((JsonElement)ret, Response.class);
                    response.type = type;
                    if ("text".equals(type)) {
                        return response.text;
                    }
                    if ("image".equals(type)) {
                        return response.image;
                    }
                    if ("url".equals(type)) {
                        return response.url;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static class Response
    implements Serializable {
        @Expose(deserialize=false, serialize=false)
        public String type;
        public String text;
        public String image;
        public String url;
    }

    public static class TuringRequestV2Builder {
        public int reqType = 0;
        public String text;
        public String apiKey;
        public String userId;
        public String groupId;
        public String userIdName;
        public String city;
        public String province;
        public String street;

        public TuringRequestV2Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public TuringRequestV2Builder setText(String text) {
            this.text = text.length() > 128 ? text.substring(0, 128) : text;
            return this;
        }

        public TuringRequestV2Builder setUserInfo(String userId, String userName, String groupId) {
            this.userId = userId;
            this.userIdName = userName;
            this.groupId = groupId;
            return this;
        }

        public TuringRequestV2Builder setLocation(String city, String province, String street) {
            this.city = city;
            this.province = province;
            this.street = street;
            return this;
        }

        public Map<String, Object> build() {
            if (StringUtils.isEmpty(this.text)) {
                return null;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("reqType", this.reqType);
            HashMap perception = new HashMap();
            params.put("perception", perception);
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("text", this.text);
            perception.put("inputText", input);
            HashMap<String, String> location = new HashMap<String, String>();
            if (!StringUtils.isEmpty(this.city)) {
                location.put("city", this.city);
            }
            if (!StringUtils.isEmpty(this.province)) {
                location.put("province", this.province);
            }
            if (!StringUtils.isEmpty(this.street)) {
                location.put("street", this.street);
            }
            if (!location.isEmpty()) {
                HashMap<String, HashMap<String, String>> self = new HashMap<String, HashMap<String, String>>();
                self.put("location", location);
                perception.put("selfInfo", self);
            }
            location = new HashMap();
            if (!StringUtils.isEmpty(this.userId)) {
                location.put("userId", this.userId);
            }
            if (!StringUtils.isEmpty(this.userIdName)) {
                location.put("userIdName", this.userIdName);
            }
            if (!StringUtils.isEmpty(this.groupId)) {
                location.put("groupId", this.groupId);
            }
            location.put("apiKey", this.apiKey);
            params.put("userInfo", location);
            return params;
        }
    }
}

