/*
 * Decompiled with CFR 0.152.
 */
package cn.ieclipse.smartim.callback.impl;

import cn.ieclipse.smartim.callback.LoginCallback;
import cn.ieclipse.util.ScaleIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class DefaultLoginCallback
implements LoginCallback {
    QRCodeFrame qrCodeFrame;
    String tip;
    String title;

    public void setTitle(String title, String tip) {
        this.title = title;
        this.tip = tip;
    }

    private void initQrCodeFrame(String path) {
        if (null != this.qrCodeFrame) {
            this.qrCodeFrame.dispose();
        }
        this.qrCodeFrame = new QRCodeFrame(path, this.title);
        this.qrCodeFrame.setTip(this.tip);
    }

    @Override
    public void onQrcode(final String path) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultLoginCallback.this.initQrCodeFrame(path);
                }
                catch (Exception e) {
                    System.err.println("\u663e\u793a\u4e8c\u7ef4\u7801\u5931\u8d25" + e.toString());
                }
            }
        });
    }

    @Override
    public void onLogin(final boolean success, final Exception e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (success) {
                    if (DefaultLoginCallback.this.qrCodeFrame != null) {
                        DefaultLoginCallback.this.qrCodeFrame.setTip("\u767b\u5f55\u6210\u529f");
                        DefaultLoginCallback.this.qrCodeFrame.setVisible(false);
                        DefaultLoginCallback.this.qrCodeFrame.dispose();
                    }
                } else {
                    if (DefaultLoginCallback.this.qrCodeFrame == null) {
                        DefaultLoginCallback.this.qrCodeFrame = new QRCodeFrame(null, DefaultLoginCallback.this.title);
                    }
                    DefaultLoginCallback.this.qrCodeFrame.setError(e.toString());
                }
                DefaultLoginCallback.this.onLoginFinish(success, e);
            }
        });
    }

    protected void onLoginFinish(boolean success, Exception e) {
    }

    public static class QRCodeFrame
    extends JFrame {
        private JPanel contentPane;
        private JTextArea tfError;
        private JLabel tfTip;
        private String title;
        private String error;
        private String tip;

        public QRCodeFrame(String filePath, String title) {
            this.setBackground(Color.WHITE);
            this.setResizable(true);
            this.setTitle(title);
            this.setDefaultCloseOperation(2);
            this.contentPane = new JPanel();
            this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setContentPane(this.contentPane);
            this.contentPane.setLayout(new BorderLayout());
            ImageIcon temp = new ImageIcon(filePath, filePath);
            if (temp.getImage() != null) {
                temp.getImage().flush();
            }
            final ScaleIcon icon = new ScaleIcon(new ImageIcon(filePath, filePath));
            JPanel qrcodePanel = new JPanel(){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    int x = 0;
                    int y = 0;
                    if (this.getWidth() > 0 && this.getWidth() > icon.getIconWidth()) {
                        x = (this.getWidth() - icon.getIconWidth()) / 2;
                    }
                    if (this.getHeight() > 0 && this.getHeight() > icon.getIconHeight()) {
                        y = (this.getHeight() - icon.getIconHeight()) / 2;
                    }
                    icon.paintIcon(this, g, x, y);
                }
            };
            qrcodePanel.setToolTipText(filePath);
            qrcodePanel.setPreferredSize(new Dimension(192, 192));
            qrcodePanel.setOpaque(true);
            this.tfTip = new JLabel(this.tip == null ? title : this.tip);
            this.tfTip.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 18));
            this.tfTip.setHorizontalAlignment(0);
            this.tfTip.setOpaque(true);
            this.tfTip.setBackground(new Color(102, 153, 255));
            this.tfError = new JTextArea();
            this.tfError.setEditable(false);
            this.tfError.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.tfError.setCaretColor(Color.RED);
            this.tfError.setForeground(Color.RED);
            this.tfError.setLineWrap(true);
            this.contentPane.add((Component)this.tfTip, "North");
            this.contentPane.add((Component)qrcodePanel, "Center");
            this.contentPane.add((Component)this.tfError, "South");
            this.setMaximumSize(new Dimension(600, 600));
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.pack();
        }

        public void setError(String string) {
            if (this.tfError != null) {
                this.tfError.setText(string);
            }
        }

        @Override
        public void setTitle(String title) {
            super.setTitle(title);
        }

        public void setTip(String tip) {
            this.tip = tip;
            if (this.tfTip != null) {
                this.tfTip.setText(tip);
            }
        }

        public static void main(String[] args) {
            new QRCodeFrame("../example/output/wechat.jpg", "\u5fae\u4fe1\u767b\u5f55");
        }
    }
}

