/*
 * Decompiled with CFR 0.152.
 */
package cn.ieclipse.smartim;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.joran.spi.JoranException;
import cn.ieclipse.smartim.SmartClient;
import cn.ieclipse.smartim.callback.LoginCallback;
import cn.ieclipse.smartim.callback.ModificationCallback;
import cn.ieclipse.smartim.callback.ReceiveCallback;
import cn.ieclipse.smartim.callback.SendCallback;
import cn.ieclipse.smartim.handler.MessageInterceptor;
import cn.ieclipse.smartim.model.impl.AbstractFrom;
import cn.ieclipse.smartim.model.impl.AbstractMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public abstract class AbstractSmartClient
implements SmartClient {
    protected ReceiveCallback receiveCallback;
    protected List<ReceiveCallback> receiveCallbacks = new ArrayList<ReceiveCallback>();
    protected List<MessageInterceptor> interceptors = new ArrayList<MessageInterceptor>();
    protected SendCallback sendCallback;
    protected ModificationCallback modificationCallback;
    protected LoginCallback loginCallback;
    protected boolean isLogin = false;
    protected boolean pollStarted = false;
    protected boolean isClose = false;
    protected String name = "";
    protected File workDir;

    @Override
    public boolean isClose() {
        return this.isClose;
    }

    @Override
    public boolean isLogin() {
        return this.isLogin;
    }

    @Override
    public void setWorkDir(File path) {
        if (path == null) {
            throw new IllegalArgumentException("Work directory is null");
        }
        if (!path.exists()) {
            path.mkdirs();
        }
        this.workDir = path;
        System.setProperty("log.home", path.getAbsolutePath());
        ILoggerFactory fac = LoggerFactory.getILoggerFactory();
        if (fac != null && fac instanceof LoggerContext) {
            LoggerContext lc = (LoggerContext)fac;
            lc.getStatusManager().clear();
            lc.reset();
            lc.putProperty("log.home", path.getAbsolutePath());
            ContextInitializer ci = new ContextInitializer(lc);
            try {
                ci.autoConfig();
            }
            catch (JoranException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setSendCallback(SendCallback callback) {
        this.sendCallback = callback;
    }

    @Override
    public void setReceiveCallback(ReceiveCallback callback) {
        this.receiveCallback = callback;
    }

    @Override
    public void setLoginCallback(LoginCallback callback) {
        this.loginCallback = callback;
    }

    @Override
    public void addReceiveCallback(ReceiveCallback callback) {
        if (callback != this.receiveCallback && !this.receiveCallbacks.contains(callback)) {
            this.receiveCallbacks.add(callback);
        }
    }

    @Override
    public void addMessageInterceptor(MessageInterceptor interceptor) {
        if (!this.interceptors.contains(interceptor)) {
            this.interceptors.add(interceptor);
        }
    }

    @Override
    public void setModificationCallbacdk(ModificationCallback callback) {
        this.modificationCallback = callback;
    }

    public void removeMessageInterceptor(MessageInterceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    protected void notifyReceive(AbstractMessage msg, AbstractFrom from) {
        if (this.receiveCallback != null) {
            this.receiveCallback.onReceiveMessage(msg, from);
        }
        if (this.receiveCallbacks != null) {
            for (ReceiveCallback callback : this.receiveCallbacks) {
                if (callback == null) continue;
                callback.onReceiveMessage(msg, from);
            }
        }
    }

    protected void notifySend(int type, String targetId, CharSequence message, Exception e) {
        if (this.sendCallback != null) {
            this.sendCallback.onSendResult(type, targetId, message, e == null, e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getWorkDir(String name) {
        if (name == null || name.trim().length() == 0) {
            return this.workDir;
        }
        return new File(this.workDir, name);
    }
}

