/*
 * Decompiled with CFR 0.152.
 */
package com.scienjus.smartqq.handler.msg;

import cn.ieclipse.smartim.handler.MessageHandler;
import cn.ieclipse.smartim.model.IMessage;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.scienjus.smartqq.model.DiscussMessage;
import com.scienjus.smartqq.model.Font;
import com.scienjus.smartqq.model.FriendMessage;
import com.scienjus.smartqq.model.GroupMessage;
import com.scienjus.smartqq.model.QQMessage;

public abstract class AbstractMessageHandler
implements MessageHandler<QQMessage> {
    protected Gson gson = new Gson();
    protected JsonParser jsonParser = new JsonParser();

    public IMessage handle(String json) {
        JsonObject result = this.jsonParser.parse(json).getAsJsonObject();
        return this.handle(result);
    }

    protected void handleCommon(QQMessage message, JsonObject result) {
        int start;
        message.setRaw(result.toString());
        JsonArray cont = result.getAsJsonArray("content");
        String fontJson = cont.get(0).getAsJsonArray().get(1).toString();
        QQMessage m = message;
        m.setFont((Font)new Gson().fromJson(fontJson, Font.class));
        m.setTime(result.get("time").getAsLong());
        int size = cont.size();
        StringBuilder contentBuilder = new StringBuilder();
        int i = start = 1;
        while (i < size) {
            JsonElement e = cont.get(i);
            if (e instanceof JsonPrimitive) {
                String s = e.getAsString();
                if (s.startsWith("@")) {
                    m.addAt(e.getAsString());
                } else if (s.equals("")) {
                    contentBuilder.append(" ");
                }
                contentBuilder.append(s);
            } else {
                if (e instanceof JsonArray) {
                    JsonArray array = (JsonArray)e;
                    int j = 0;
                    while (j < array.size()) {
                        JsonObject ej;
                        JsonElement temp = array.get(j);
                        if (temp instanceof JsonObject && (ej = (JsonObject)temp).has("face")) {
                            m.setFace(ej.get("face").getAsInt());
                        }
                        ++j;
                    }
                }
                contentBuilder.append(e.toString());
            }
            ++i;
        }
        m.setContent(contentBuilder.toString());
        m.setRaw(result.toString());
        if (m instanceof DiscussMessage) {
            DiscussMessage dm = (DiscussMessage)m;
            dm.setDiscussId(result.get("did").getAsLong());
            dm.setUserId(result.get("send_uin").getAsLong());
        } else if (m instanceof GroupMessage) {
            GroupMessage gm = (GroupMessage)m;
            gm.setGroupId(result.get("group_code").getAsLong());
            gm.setUserId(result.get("send_uin").getAsLong());
        } else if (m instanceof FriendMessage) {
            m.setUserId(result.get("from_uin").getAsLong());
        }
    }

    protected JsonObject serializeCommon(QQMessage message) {
        JsonObject result = new JsonObject();
        return result;
    }
}

