/*
 * Decompiled with CFR 0.152.
 */
package com.scienjus.smartqq.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.scienjus.smartqq.handler.AbstractContactHandler;
import com.scienjus.smartqq.model.Category;
import com.scienjus.smartqq.model.Friend;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FriendHandler
extends AbstractContactHandler<Friend> {
    public Friend handle(JsonObject result) {
        return (Friend)this.gson.fromJson((JsonElement)result, Friend.class);
    }

    public List<Friend> handle(JsonArray array) {
        return null;
    }

    public Map<Long, Friend> handleFriendList(JsonObject result) {
        TreeMap<Long, Friend> friendMap = new TreeMap<Long, Friend>();
        JsonArray info = result.getAsJsonArray("info");
        int i = 0;
        while (info != null && i < info.size()) {
            JsonObject item = info.get(i).getAsJsonObject();
            Friend friend = this.handle(item);
            friendMap.put(friend.getUserId(), friend);
            ++i;
        }
        JsonArray marknames = result.getAsJsonArray("marknames");
        int i2 = 0;
        while (marknames != null && i2 < marknames.size()) {
            JsonObject item = marknames.get(i2).getAsJsonObject();
            ((Friend)friendMap.get(item.get("uin").getAsLong())).setMarkname(item.get("markname").getAsString());
            ++i2;
        }
        JsonArray vipinfo = result.getAsJsonArray("vipinfo");
        int i3 = 0;
        while (vipinfo != null && i3 < vipinfo.size()) {
            JsonObject item = vipinfo.get(i3).getAsJsonObject();
            Friend friend = (Friend)friendMap.get(item.get("u").getAsLong());
            friend.setVip(item.get("is_vip").getAsInt() == 1);
            friend.setVipLevel(item.get("vip_level").getAsInt());
            ++i3;
        }
        return friendMap;
    }

    public Category handleCategory(JsonObject result) {
        return (Category)this.gson.fromJson((JsonElement)result, Category.class);
    }

    public List<Category> handleCategoryList(JsonObject result) {
        Map<Long, Friend> friendMap = this.handleFriendList(result);
        TreeMap<Integer, Category> categoryMap = new TreeMap<Integer, Category>();
        JsonArray categories = result.getAsJsonArray("categories");
        categoryMap.put(0, Category.defaultCategory());
        int i = 0;
        while (categories != null && i < categories.size()) {
            JsonObject item = categories.get(i).getAsJsonObject();
            Category category = this.handleCategory(item);
            categoryMap.put(category.getIndex(), category);
            ++i;
        }
        JsonArray friends = result.getAsJsonArray("friends");
        int i2 = 0;
        while (friends != null && i2 < friends.size()) {
            JsonObject item = friends.get(i2).getAsJsonObject();
            Friend friend = friendMap.get(item.get("uin").getAsLong());
            int catId = item.get("categories").getAsInt();
            Category category = (Category)categoryMap.get(catId);
            if (category == null) {
                category = Category.unknownCategory(catId);
                categoryMap.put(category.getIndex(), category);
            }
            category.addFriend(friend);
            ++i2;
        }
        return new ArrayList<Category>(categoryMap.values());
    }
}

