/*
 * Decompiled with CFR 0.152.
 */
package com.scienjus.smartqq.client;

import cn.ieclipse.smartim.AbstractSmartClient;
import cn.ieclipse.smartim.callback.ReceiveCallback;
import cn.ieclipse.smartim.exception.LogicException;
import cn.ieclipse.smartim.model.IContact;
import cn.ieclipse.smartim.model.IMessage;
import cn.ieclipse.smartim.model.impl.AbstractContact;
import cn.ieclipse.smartim.model.impl.AbstractFrom;
import cn.ieclipse.smartim.model.impl.AbstractMessage;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.scienjus.smartqq.client.SmartQQApi;
import com.scienjus.smartqq.handler.DiscussHandler;
import com.scienjus.smartqq.handler.DiscussInfoHandler;
import com.scienjus.smartqq.handler.FriendHandler;
import com.scienjus.smartqq.handler.FriendStatusHandler;
import com.scienjus.smartqq.handler.GroupHandler;
import com.scienjus.smartqq.handler.GroupInfoHandler;
import com.scienjus.smartqq.handler.RecentHandler;
import com.scienjus.smartqq.handler.UserInfoHandler;
import com.scienjus.smartqq.handler.msg.DiscussMessageHandler;
import com.scienjus.smartqq.handler.msg.FriendMessageHandler;
import com.scienjus.smartqq.handler.msg.GroupMessageHandler;
import com.scienjus.smartqq.model.Category;
import com.scienjus.smartqq.model.Discuss;
import com.scienjus.smartqq.model.DiscussFrom;
import com.scienjus.smartqq.model.DiscussInfo;
import com.scienjus.smartqq.model.DiscussMessage;
import com.scienjus.smartqq.model.DiscussUser;
import com.scienjus.smartqq.model.Font;
import com.scienjus.smartqq.model.Friend;
import com.scienjus.smartqq.model.FriendFrom;
import com.scienjus.smartqq.model.FriendMessage;
import com.scienjus.smartqq.model.FriendStatus;
import com.scienjus.smartqq.model.Group;
import com.scienjus.smartqq.model.GroupFrom;
import com.scienjus.smartqq.model.GroupInfo;
import com.scienjus.smartqq.model.GroupMessage;
import com.scienjus.smartqq.model.GroupUser;
import com.scienjus.smartqq.model.QQContact;
import com.scienjus.smartqq.model.QQMessage;
import com.scienjus.smartqq.model.Recent;
import com.scienjus.smartqq.model.UserInfo;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartQQClient
extends AbstractSmartClient {
    public static boolean DEBUG = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartQQClient.class);
    private SmartQQApi api;
    private FriendMessageHandler friendMessageHandler = new FriendMessageHandler();
    private GroupMessageHandler groupMessageHandler = new GroupMessageHandler();
    private DiscussMessageHandler discussMessageHandler = new DiscussMessageHandler();
    private UserInfoHandler userInfoHandler = new UserInfoHandler();
    private GroupInfoHandler groupInfoHandler = new GroupInfoHandler();
    private DiscussInfoHandler discussInfoHandler = new DiscussInfoHandler();
    private FriendHandler friendHandler = new FriendHandler();
    private GroupHandler groupHandler = new GroupHandler();
    private DiscussHandler discussHandler = new DiscussHandler();
    public List<Recent> recents;
    public List<QQContact> recents2;
    public List<Group> groups;
    public List<Friend> temps;
    public List<Discuss> discusses;
    public List<Category> categories;
    public Map<Long, GroupInfo> ginfos;
    public Map<Long, DiscussInfo> dinfos;
    public UserInfo account;

    public SmartQQClient(Proxy proxy) {
        this.name = "SmartQQ";
        this.api = new SmartQQApi(proxy);
    }

    public SmartQQClient() {
        this(null);
    }

    public void start() {
        if (this.receiveCallback != null && this.isLogin() && !this.pollStarted) {
            this.pollStarted = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (SmartQQClient.this.pollStarted) {
                        try {
                            JsonArray array = SmartQQClient.this.api.pollMessage();
                            SmartQQClient.this.handleMessage(array);
                            continue;
                        }
                        catch (IOException e) {
                            if (e.getCause() instanceof SocketTimeoutException) continue;
                            LOGGER.debug(e.getMessage());
                            continue;
                        }
                        catch (Exception e) {
                            int code;
                            LOGGER.error(e.getMessage(), (Throwable)e);
                            if (!(e instanceof LogicException) || (code = ((LogicException)e).getCode()) != 103 && code != 100100 && code != 100001) continue;
                            SmartQQClient.this.close();
                            if (SmartQQClient.this.receiveCallback == null) continue;
                            SmartQQClient.this.receiveCallback.onReceiveError((Throwable)e);
                            continue;
                        }
                        break;
                    }
                    return;
                }
            }).start();
        }
    }

    public QQMessage handleMessage(JsonObject message) {
        String type = message.get("poll_type").getAsString();
        if ("message".equals(type)) {
            FriendMessage m = this.friendMessageHandler.handle(message.getAsJsonObject("value"));
            return m;
        }
        if ("group_message".equals(type)) {
            GroupMessage m = this.groupMessageHandler.handle(message.getAsJsonObject("value"));
            return m;
        }
        if ("discu_message".equals(type)) {
            DiscussMessage m = this.discussMessageHandler.handle(message.getAsJsonObject("value"));
            return m;
        }
        return null;
    }

    private void handleMessage(JsonArray array) {
        int i = 0;
        while (array != null && i < array.size()) {
            JsonObject message = (JsonObject)array.get(i);
            QQMessage m = this.handleMessage(message);
            if (m != null) {
                AbstractFrom from = this.parseFrom(m);
                if (from != null && from.getContact() != null) {
                    Recent r = new Recent();
                    long uin = Long.parseLong(from.getContact().getUin());
                    r.setUin(uin);
                    if (from instanceof FriendFrom) {
                        r.setType(0);
                    } else if (from instanceof GroupFrom) {
                        r.setType(1);
                    } else if (from instanceof DiscussFrom) {
                        r.setType(2);
                    }
                    if (!this.getRecentList().contains(r)) {
                        this.getRecentList().add(0, r);
                        IContact n = this.getRecentTarget(r);
                        if (n != null && n instanceof QQContact) {
                            this.getRecents2().add(0, (QQContact)n);
                        }
                    }
                }
                this.notifyReceive(m, from);
            }
            ++i;
        }
    }

    public void login() {
        block6: {
            try {
                String path = this.api.getQRCode();
                if (this.loginCallback != null) {
                    this.loginCallback.onQrcode(path);
                }
                this.api.login();
                this.isLogin = true;
                if (this.loginCallback != null) {
                    try {
                        this.loginCallback.onLogin(this.isLogin, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("\u767b\u5f55\u5931\u8d25", (Throwable)e);
                if (this.loginCallback == null) break block6;
                this.loginCallback.onLogin(false, e);
            }
        }
    }

    public void setWorkDir(File path) {
        super.setWorkDir(path);
        this.api.setWorkDir(path);
    }

    public void init() throws Exception {
        block7: {
            List<Discuss> td;
            List<Group> tg;
            List<Category> tc;
            UserInfo t = this.userInfoHandler.handle(this.api.getAccountInfo());
            if (t != null) {
                this.account = t;
            }
            if (!this.isEmpty(tc = this.friendHandler.handleCategoryList(this.api.getFriendListWithCategory()))) {
                this.categories = tc;
            }
            if (!this.isEmpty(tg = this.groupHandler.handle(this.api.getGroupList()))) {
                this.groups = tg;
            }
            if (!this.isEmpty(td = this.discussHandler.handle(this.api.getDiscussList()))) {
                this.discusses = td;
            }
            try {
                List<Recent> tr = new RecentHandler().handle(this.api.getRecentList());
                if (!this.isEmpty(tr)) {
                    this.recents = tr;
                }
            }
            catch (LogicException e) {
                if (e.getCode() != 1202) break block7;
                this.recents = new ArrayList<Recent>();
            }
        }
        this.recents2 = this.parseRecents(this.recents);
    }

    public List<Category> getFriendListWithCategory() {
        return this.categories;
    }

    public List<Group> getGroupList() {
        return this.groups;
    }

    public List<Discuss> getDiscussList() {
        return this.discusses;
    }

    public UserInfo getFriendInfo(long friendId) {
        try {
            return this.userInfoHandler.handle(this.api.getFriendInfo(friendId));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Recent> getRecentList() {
        return this.recents;
    }

    public List<QQContact> getRecents2() {
        return this.recents2;
    }

    public long getQQById(long friendId) {
        try {
            return this.api.getQQById(friendId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public List<FriendStatus> getFriendStatus() {
        try {
            return new FriendStatusHandler().handle(this.api.getFriendStatus());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GroupInfo getGroupInfo(long groupCode) {
        try {
            LOGGER.info(String.format("\u83b7\u53d6\u7fa4(code=%s)\u4fe1\u606f", groupCode));
            return this.groupInfoHandler.handle(this.api.getGroupInfo(groupCode));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DiscussInfo getDiscussInfo(long discussId) {
        try {
            LOGGER.info(String.format("\u83b7\u53d6\u8ba8\u8bba\u7ec4(code=%s)\u4fe1\u606f", discussId));
            return this.discussInfoHandler.handle(this.api.getDiscussInfo(discussId));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveAuthInfo() {
        this.api.saveAuthInfo();
    }

    public void readAuthInfo(String file) {
        this.api.readAuthInfo();
    }

    public void close() {
        try {
            this.isLogin = false;
            this.pollStarted = false;
            this.isClose = true;
            this.api.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.clear(this.categories);
        this.clear(this.groups);
        this.clear(this.discusses);
        this.clear(this.ginfos);
        this.clear(this.dinfos);
    }

    public boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public void clear(Collection<?> c) {
        if (!this.isEmpty(c)) {
            c.clear();
        }
    }

    public boolean isEmpty(Map<?, ?> c) {
        return c == null || c.isEmpty();
    }

    public void clear(Map<?, ?> c) {
        if (!this.isEmpty(c)) {
            c.clear();
        }
    }

    public UserInfo getAccount() {
        return this.account;
    }

    public Recent getRecent(int type, long uin) {
        Recent r2;
        List<Recent> list = this.getRecentList();
        int idx = -1;
        for (Recent r2 : list) {
            ++idx;
            if (r2.getType() != type || r2.getUin() != uin) continue;
            return r2;
        }
        r2 = new Recent();
        r2.setType(type);
        r2.setUin(uin);
        list.add(0, r2);
        return r2;
    }

    public Friend getFriend(long uin) {
        if (this.categories != null) {
            for (Category c : this.categories) {
                List<Friend> list = c.getFriends();
                for (Friend f : list) {
                    if (f.getUserId() != uin) continue;
                    return f;
                }
            }
        }
        if (this.temps != null) {
            for (Friend f : this.temps) {
                if (f.getUserId() != uin) continue;
                return f;
            }
        }
        return null;
    }

    public Group getGroup(long uin) {
        if (this.isEmpty(this.groups)) {
            try {
                this.groups = this.groupHandler.handle(this.api.getGroupList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.groups != null) {
            for (Group g : this.groups) {
                if (g.id != uin) continue;
                return g;
            }
        }
        return null;
    }

    public Discuss getDiscuss(long uin) {
        if (this.isEmpty(this.discusses)) {
            try {
                this.discusses = this.discussHandler.handle(this.api.getDiscussList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.discusses != null) {
            for (Discuss g : this.discusses) {
                if (g.id != uin) continue;
                return g;
            }
        }
        return null;
    }

    public GroupInfo getGroupInfo(Group group) {
        GroupInfo info = null;
        if (this.ginfos != null) {
            info = this.ginfos.get(group.id);
        }
        if (info == null) {
            try {
                LOGGER.info(String.format("\u83b7\u53d6\u7fa4%s(code=%s)\u4fe1\u606f", group, group.code));
                info = this.getGroupInfo(group.code);
                if (this.modificationCallback != null) {
                    this.modificationCallback.onContactChanged((IContact)info);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.ginfos == null) {
                this.ginfos = new HashMap<Long, GroupInfo>();
            }
            this.ginfos.put(group.id, info);
        }
        return info;
    }

    public GroupUser getGroupUser(GroupMessage m) {
        Group g = this.getGroup(m.getGroupId());
        GroupInfo info = this.getGroupInfo(g);
        if (info != null && info.getUsers() != null) {
            for (GroupUser u : info.getUsers()) {
                if (!u.getUin().equals(String.valueOf(m.getUserId()))) continue;
                return u;
            }
        }
        return null;
    }

    public DiscussInfo getDiscussInfo(Discuss discuss) {
        DiscussInfo info = null;
        if (this.dinfos != null) {
            info = this.dinfos.get(discuss.id);
        }
        if (info == null) {
            try {
                LOGGER.info(String.format("\u83b7\u53d6\u8ba8\u8bba\u7ec4%s(code=%s)\u4fe1\u606f", discuss, discuss.id));
                info = this.getDiscussInfo(discuss.id);
                if (this.modificationCallback != null) {
                    this.modificationCallback.onContactChanged((IContact)info);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.dinfos == null) {
                this.dinfos = new HashMap<Long, DiscussInfo>();
            }
            this.dinfos.put(discuss.id, info);
        }
        return info;
    }

    public DiscussUser getDiscussUser(DiscussMessage m) {
        Discuss g = this.getDiscuss(m.getDiscussId());
        DiscussInfo info = this.getDiscussInfo(g);
        if (info != null && info.getUsers() != null) {
            for (DiscussUser u : info.getUsers()) {
                if (!u.getUin().equals(String.valueOf(m.getUserId()))) continue;
                return u;
            }
        }
        return null;
    }

    public AbstractFrom parseFrom(QQMessage m) {
        if (m != null) {
            if (m instanceof FriendMessage) {
                return this.parseFrom((FriendMessage)m);
            }
            if (m instanceof GroupMessage) {
                return this.parseFrom((GroupMessage)m);
            }
            if (m instanceof DiscussMessage) {
                return this.parseFrom((DiscussMessage)m);
            }
        }
        return null;
    }

    public FriendFrom parseFrom(FriendMessage friendMessage) {
        FriendFrom from = new FriendFrom();
        Friend f = this.getFriend(friendMessage.getUserId());
        if (f == null) {
            f = new Friend();
            f.setUserId(friendMessage.getUserId());
            f.setMarkname("\u672a\u77e5\u7528\u6237" + f.getUserId());
            if (this.temps == null) {
                this.temps = new ArrayList<Friend>();
            }
            this.temps.add(f);
            from.setNewbie(true);
        }
        from.setFriend(f);
        return from;
    }

    public GroupFrom parseFrom(GroupMessage message) {
        GroupUser gu;
        GroupFrom from = new GroupFrom();
        Group g = this.getGroup(message.getGroupId());
        boolean newGroup = false;
        if (g == null) {
            g = new Group();
            g.id = message.getGroupId();
            newGroup = true;
        }
        GroupInfo info = null;
        if (this.ginfos == null) {
            try {
                info = this.getGroupInfo(g.code);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.ginfos = new HashMap<Long, GroupInfo>();
            this.ginfos.put(g.id, info);
        } else {
            info = this.getGroupInfo(g);
        }
        if (newGroup) {
            g.name = info.getName();
        }
        if ((gu = info.getGroupUser(message.getUserId())) == null) {
            try {
                info = this.getGroupInfo(g.code);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (info != null) {
                this.ginfos.put(g.id, info);
                gu = info.getGroupUser(message.getUserId());
                if (gu == null) {
                    gu = new GroupUser();
                    gu.setUin(message.getUserId());
                    gu.setCard(String.valueOf(message.getUserId()));
                    info.getUsers().add(gu);
                    gu.setUnknown(true);
                } else {
                    from.setNewbie(true);
                }
            }
        }
        from.setGroupUser(gu);
        from.setGroup(info);
        if (newGroup && this.modificationCallback != null) {
            this.modificationCallback.onContactChanged((IContact)g);
        }
        return from;
    }

    public DiscussFrom parseFrom(DiscussMessage message) {
        DiscussUser gu;
        DiscussFrom from = new DiscussFrom();
        Discuss g = this.getDiscuss(message.getDiscussId());
        boolean newGroup = false;
        if (g == null) {
            g = new Discuss();
            g.id = message.getDiscussId();
            newGroup = true;
        }
        DiscussInfo info = null;
        if (this.dinfos == null) {
            try {
                info = this.getDiscussInfo(g.id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.dinfos = new HashMap<Long, DiscussInfo>();
            this.dinfos.put(g.id, info);
        } else {
            info = this.getDiscussInfo(g);
        }
        if (newGroup) {
            g.name = info.getName();
        }
        if ((gu = info.getDiscussUser(message.getUserId())) == null) {
            try {
                info = this.getDiscussInfo(g.id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (info != null) {
                this.dinfos.put(g.id, info);
                gu = info.getDiscussUser(message.getUserId());
                if (gu == null) {
                    gu = new DiscussUser();
                    gu.uin = message.getUserId();
                    gu.nick = String.valueOf(message.getUserId());
                    info.getUsers().add(gu);
                    gu.setUnknown(true);
                } else {
                    from.setNewbie(true);
                }
            }
        }
        from.setDiscussUser(gu);
        from.setDiscuss(info);
        if (newGroup && this.modificationCallback != null) {
            this.modificationCallback.onContactChanged((IContact)g);
        }
        return from;
    }

    public List<QQContact> parseRecents(List<Recent> list) {
        ArrayList<QQContact> ret = new ArrayList<QQContact>();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                IContact c = this.getRecentTarget(list.get(i));
                if (c != null && c instanceof QQContact) {
                    ret.add((QQContact)c);
                }
                ++i;
            }
        }
        return ret;
    }

    public IContact getRecentTarget(Recent r) {
        if (r.getType() == 0) {
            Friend f = this.getFriend(r.getUin());
            if (f == null) {
                f = new Friend();
                f.setUserId(r.getUin());
                f.setMarkname("unknown " + r.getUin());
                f.setUnknown(true);
            }
            return f;
        }
        if (r.getType() == 1) {
            Group g = this.getGroup(r.getUin());
            return g;
        }
        if (r.getType() == 2) {
            Discuss d = this.getDiscuss(r.getUin());
            return d;
        }
        return null;
    }

    public static void setDebug(boolean debug) {
        DEBUG = debug;
        SmartQQApi.DEBUG = debug;
    }

    public static String getName(Object obj) {
        String name = null;
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Friend) {
            Friend f = (Friend)obj;
            name = f.getMarkname();
            if (name == null || name.isEmpty()) {
                name = f.getNickname();
            }
            if (name == null || name.isEmpty()) {
                name = String.valueOf(f.getUserId());
            }
        } else if (obj instanceof Group) {
            Group g = (Group)obj;
            name = g.getName();
        } else if (obj instanceof Discuss) {
            Discuss d = (Discuss)obj;
            name = d.getName();
        } else if (obj instanceof GroupUser) {
            GroupUser gu = (GroupUser)((Object)obj);
            name = gu.getCard();
            if (name == null || name.isEmpty()) {
                name = gu.getNick();
            }
            if (name == null || name.isEmpty()) {
                name = String.valueOf(gu.getUin());
            }
        } else if (obj instanceof DiscussUser) {
            DiscussUser gu = (DiscussUser)((Object)obj);
            name = gu.getName();
            if (name == null || name.isEmpty()) {
                name = String.valueOf(gu.getUin());
            }
        } else if (obj instanceof Category) {
            name = ((Category)obj).getName();
        }
        return name;
    }

    public int sendMessage(IMessage msg, IContact target) {
        if (target instanceof AbstractContact) {
            ((AbstractContact)target).setLastMessage(msg);
        }
        Long uin = Long.parseLong(target.getUin());
        String content = ((QQMessage)msg).getContent();
        if (target instanceof Friend || target instanceof UserInfo) {
            this.sendMessageToFriend(uin, content);
        } else if (target instanceof Group || target instanceof GroupInfo) {
            this.sendMessageToGroup(uin, content);
        } else if (target instanceof Discuss || target instanceof DiscussInfo) {
            this.sendMessageToDiscuss(uin, content);
        }
        return 0;
    }

    public void sendMessageToGroup(long groupId, String msg) {
        try {
            this.api.sendMessageToGroup(groupId, msg);
            this.notifySend(1, String.valueOf(groupId), msg, null);
        }
        catch (Exception e) {
            this.notifySend(1, String.valueOf(groupId), msg, e);
        }
    }

    public void sendMessageToDiscuss(long discussId, String msg) {
        try {
            this.api.sendMessageToDiscuss(discussId, msg);
            this.notifySend(2, String.valueOf(discussId), msg, null);
        }
        catch (Exception e) {
            this.notifySend(2, String.valueOf(discussId), msg, e);
        }
    }

    public void sendMessageToFriend(long friendId, String msg) {
        try {
            this.api.sendMessageToFriend(friendId, msg);
            this.notifySend(0, String.valueOf(friendId), msg, null);
        }
        catch (Exception e) {
            this.notifySend(0, String.valueOf(friendId), msg, e);
        }
    }

    protected void notifySend(int type, String targetId, CharSequence message, Exception e) {
        Exception ex = e;
        if (e instanceof LogicException && ((LogicException)((Object)e)).getCode() == 1202) {
            ex = null;
        }
        super.notifySend(type, targetId, message, ex);
    }

    public QQMessage createMessage(String msg, IContact target) {
        long uin = Long.parseLong(target.getUin());
        if (target instanceof Friend || target instanceof UserInfo) {
            FriendMessage ret = new FriendMessage();
            ret.setContent(msg);
            ret.setTime(System.currentTimeMillis() / 1000L);
            ret.setFont(Font.DEFAULT_FONT);
            ret.setUserId(this.getAccount().getId());
            return ret;
        }
        if (target instanceof Group || target instanceof GroupInfo) {
            GroupMessage ret = new GroupMessage();
            ret.setContent(msg);
            ret.setTime(System.currentTimeMillis());
            ret.setFont(Font.DEFAULT_FONT);
            ret.setUserId(this.getAccount().getId());
            ret.setGroupId(uin);
            return ret;
        }
        if (target instanceof Discuss || target instanceof DiscussInfo) {
            DiscussMessage ret = new DiscussMessage();
            ret.setContent(msg);
            ret.setTime(System.currentTimeMillis());
            ret.setFont(Font.DEFAULT_FONT);
            ret.setUserId(this.getAccount().getId());
            ret.setDiscussId(uin);
            return ret;
        }
        return null;
    }

    public int broadcast(String msg, Object ... targets) {
        int ret = 0;
        if (targets != null) {
            Object[] objectArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                Object target = objectArray[n2];
                if (target != null) {
                    try {
                        if (target instanceof Friend) {
                            this.api.sendMessageToFriend(((Friend)target).getUserId(), msg);
                        } else if (target instanceof Group) {
                            this.api.sendMessageToGroup(((Group)target).id, msg);
                        } else if (target instanceof Discuss) {
                            this.api.sendMessageToDiscuss(((Discuss)target).id, msg);
                        }
                        ++ret;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        SmartQQClient client = new SmartQQClient();
        client.setReceiveCallback(new ReceiveCallback(){

            public void onReceiveMessage(AbstractMessage message, AbstractFrom from) {
                QQMessage m = (QQMessage)message;
                String date = new SimpleDateFormat("HH:mm:ss").format(m.getTime());
                String content = String.format("%s %s %s", date, from.getName(), m.getContent());
                System.out.println(content);
                if (from.isNewbie()) {
                    System.out.println("new friend");
                }
            }

            public void onReceiveError(Throwable e) {
                e.printStackTrace();
            }
        });
        client.login();
        while (!client.isLogin()) {
            Thread.sleep(1000L);
        }
        client.init();
        client.start();
    }
}

