/*
 * Decompiled with CFR 0.152.
 */
package com.scienjus.smartqq.client;

import cn.ieclipse.smartim.exception.HttpException;
import cn.ieclipse.smartim.exception.LogicException;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.scienjus.smartqq.client.CookieManager;
import com.scienjus.smartqq.constant.ApiURL;
import com.scienjus.smartqq.handler.AbstractContactHandler;
import com.scienjus.smartqq.model.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.Call;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartQQApi
implements Closeable {
    public static boolean DEBUG = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartQQApi.class);
    private static int retryTimesOnFailed = 3;
    private static long MESSAGE_ID = 43690001L;
    private static final long Client_ID = 53999199L;
    private static final long RETRY_TIMES = 5L;
    private OkHttpClient client;
    private CookieManager cookieJar = new CookieManager();
    private String qrsig;
    private File workDir;
    private String ptwebqq;
    private String vfwebqq;
    private long uin;
    private String psessionid;

    public void setWorkDir(File dir) {
        if (dir == null) {
            throw new NullPointerException("Work dir is null");
        }
        this.workDir = dir;
    }

    public SmartQQApi(Proxy proxy) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.cookieJar((CookieJar)this.cookieJar);
        builder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        if (proxy != null) {
            builder.proxy(proxy);
        }
        this.client = builder.build();
    }

    public void login() throws Exception {
        String url = this.verifyQRCode();
        this.getPtwebqq(url);
        this.getVfwebqq();
        this.getUinAndPsessionid();
        this.getFriendStatus();
    }

    public String getQRCode() {
        String filePath;
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u4e8c\u7ef4\u7801");
        try {
            File file = new File(this.workDir, "smartqq.jpg");
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            filePath = file.getAbsolutePath();
            Response response = this.get(ApiURL.GET_QR_CODE, new Object[0]);
            if (response.isSuccessful()) {
                int len;
                InputStream is = response.body().byteStream();
                FileOutputStream fos = new FileOutputStream(file);
                byte[] buffer = new byte[8192];
                while ((len = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                }
                is.close();
                fos.close();
                Cookie c = this.cookieJar.getFirstCookie("qrsig");
                if (c != null) {
                    this.qrsig = c.value();
                }
                LOGGER.info("\u4e8c\u7ef4\u7801\u5df2\u4fdd\u5b58\u5728 " + filePath + " \u6587\u4ef6\u4e2d\uff0c\u8bf7\u6253\u5f00\u624b\u673aQQ\u5e76\u626b\u63cf\u4e8c\u7ef4\u7801");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return filePath;
    }

    private static int hash33(String s) {
        int e = 0;
        int n = s.length();
        int i = 0;
        while (n > i) {
            e += (e << 5) + s.charAt(i);
            ++i;
        }
        return Integer.MAX_VALUE & e;
    }

    public String verifyQRCode() throws IOException {
        LOGGER.debug("\u7b49\u5f85\u626b\u63cf\u4e8c\u7ef4\u7801");
        int maxCount = 30;
        do {
            SmartQQApi.sleep(maxCount < 15 ? 3 : 1);
            Response response = this.get(ApiURL.VERIFY_QR_CODE, SmartQQApi.hash33(this.qrsig));
            String result = response.body().string();
            if (result.contains("\u6210\u529f")) {
                String[] stringArray = result.split("','");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String content = stringArray[n2];
                    if (content.startsWith("http")) {
                        LOGGER.info("\u6b63\u5728\u767b\u5f55\uff0c\u8bf7\u7a0d\u540e");
                        Cookie cookie = this.cookieJar.getFirstCookie("ptwebqq");
                        if (cookie != null) {
                            this.ptwebqq = cookie.value();
                        }
                        return content;
                    }
                    ++n2;
                }
            } else {
                if (!result.contains("\u5df2\u5931\u6548")) continue;
                LOGGER.info("\u4e8c\u7ef4\u7801\u5df2\u5931\u6548\uff0c\u5c1d\u8bd5\u91cd\u65b0\u83b7\u53d6\u4e8c\u7ef4\u7801");
                throw new RuntimeException("\u4e8c\u7ef4\u7801\u5df2\u5931\u6548");
            }
        } while (--maxCount > 0);
        throw new RuntimeException("\u9a8c\u8bc1\u4e8c\u7ef4\u7801\u8d85\u65f6");
    }

    private void getPtwebqq(String url) throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6ptwebqq");
        Response response = this.get(ApiURL.GET_PTWEBQQ, url);
        int retryTimes4Vfwebqq = retryTimesOnFailed;
        while (response.code() == 404 && retryTimes4Vfwebqq > 0) {
            response.close();
            response = this.get(ApiURL.GET_PTWEBQQ, url);
            --retryTimes4Vfwebqq;
        }
        this.ptwebqq = this.cookieJar.getFirstCookie("ptwebqq").value();
    }

    private void getVfwebqq() throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6vfwebqq");
        Response response = this.get(ApiURL.GET_VFWEBQQ, this.ptwebqq);
        int retryTimes4Vfwebqq = retryTimesOnFailed;
        while (response.code() == 404 && retryTimes4Vfwebqq > 0) {
            response.close();
            response = this.get(ApiURL.GET_VFWEBQQ, this.ptwebqq);
            --retryTimes4Vfwebqq;
        }
        this.vfwebqq = SmartQQApi.getJsonObjectResult(response).get("vfwebqq").getAsString();
    }

    private void getUinAndPsessionid() throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6uin\u548cpsessionid");
        JsonObject r = new JsonObject();
        r.addProperty("ptwebqq", this.ptwebqq);
        r.addProperty("clientid", (Number)53999199L);
        r.addProperty("psessionid", "");
        r.addProperty("status", "online");
        Response response = this.post(ApiURL.GET_UIN_AND_PSESSIONID, r);
        JsonObject result = SmartQQApi.getJsonObjectResult(response);
        this.psessionid = result.get("psessionid").getAsString();
        this.uin = result.get("uin").getAsLong();
    }

    public JsonArray getGroupList() throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u7fa4\u5217\u8868");
        JsonObject r = new JsonObject();
        r.addProperty("vfwebqq", this.vfwebqq);
        r.addProperty("hash", this.hash());
        Response response = this.post(ApiURL.GET_GROUP_LIST, r);
        int retryTimes4Vfwebqq = retryTimesOnFailed;
        while (response.code() == 404 && retryTimes4Vfwebqq > 0) {
            response.close();
            response = this.post(ApiURL.GET_GROUP_LIST, r);
            --retryTimes4Vfwebqq;
        }
        JsonObject result = SmartQQApi.getJsonObjectResult(response);
        return result.getAsJsonArray("gnamelist");
    }

    public JsonArray pollMessage() throws Exception {
        JsonObject r = new JsonObject();
        r.addProperty("ptwebqq", this.ptwebqq);
        r.addProperty("clientid", (Number)53999199L);
        r.addProperty("psessionid", this.psessionid);
        r.addProperty("key", "");
        Response response = this.post(ApiURL.POLL_MESSAGE, r);
        JsonArray array = SmartQQApi.getJsonArrayResult(response);
        return array;
    }

    private void addSendParam(JsonObject r, String msg) {
        r.addProperty("content", new Gson().toJson(Arrays.asList(msg, Arrays.asList("font", Font.DEFAULT_FONT))));
        r.addProperty("face", (Number)573);
        r.addProperty("clientid", (Number)53999199L);
        r.addProperty("msg_id", (Number)MESSAGE_ID++);
        r.addProperty("psessionid", this.psessionid);
    }

    public void sendMessageToGroup(long groupId, String msg) throws Exception {
        LOGGER.debug("\u5f00\u59cb\u53d1\u9001\u7fa4\u6d88\u606f");
        JsonObject r = new JsonObject();
        r.addProperty("group_uin", (Number)groupId);
        this.addSendParam(r, msg);
        Response response = this.postWithRetry(ApiURL.SEND_MESSAGE_TO_GROUP, r);
        SmartQQApi.checkSendMsgResult(response);
    }

    public void sendMessageToDiscuss(long discussId, String msg) throws Exception {
        LOGGER.debug("\u5f00\u59cb\u53d1\u9001\u8ba8\u8bba\u7ec4\u6d88\u606f");
        JsonObject r = new JsonObject();
        r.addProperty("did", (Number)discussId);
        this.addSendParam(r, msg);
        Response response = this.postWithRetry(ApiURL.SEND_MESSAGE_TO_DISCUSS, r);
        SmartQQApi.checkSendMsgResult(response);
    }

    public void sendMessageToFriend(long friendId, String msg) throws Exception {
        LOGGER.debug("\u5f00\u59cb\u53d1\u9001\u6d88\u606f");
        JsonObject r = new JsonObject();
        r.addProperty("to", (Number)friendId);
        this.addSendParam(r, msg);
        Response response = this.postWithRetry(ApiURL.SEND_MESSAGE_TO_FRIEND, r);
        SmartQQApi.checkSendMsgResult(response);
    }

    public JsonArray getDiscussList() throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u8ba8\u8bba\u7ec4\u5217\u8868");
        Response response = this.get(ApiURL.GET_DISCUSS_LIST, this.psessionid, this.vfwebqq);
        return SmartQQApi.getJsonObjectResult(response).getAsJsonArray("dnamelist");
    }

    public JsonObject getFriendListWithCategory() throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u597d\u53cb\u5217\u8868");
        JsonObject r = new JsonObject();
        r.addProperty("vfwebqq", this.vfwebqq);
        r.addProperty("hash", this.hash());
        Response response = this.post(ApiURL.GET_FRIEND_LIST, r);
        JsonObject result = SmartQQApi.getJsonObjectResult(response);
        return result;
    }

    public JsonObject getFriendList() throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u597d\u53cb\u5217\u8868");
        JsonObject r = new JsonObject();
        r.addProperty("vfwebqq", this.vfwebqq);
        r.addProperty("hash", this.hash());
        Response response = this.post(ApiURL.GET_FRIEND_LIST, r);
        return SmartQQApi.getJsonObjectResult(response);
    }

    public JsonObject getAccountInfo() throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f");
        Response response = this.get(ApiURL.GET_ACCOUNT_INFO, new Object[0]);
        return SmartQQApi.getJsonObjectResult(response);
    }

    public JsonObject getFriendInfo(long friendId) throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u597d\u53cb\u4fe1\u606f");
        Response response = this.get(ApiURL.GET_FRIEND_INFO, friendId, this.vfwebqq, this.psessionid);
        return SmartQQApi.getJsonObjectResult(response);
    }

    public JsonArray getRecentList() throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u6700\u8fd1\u4f1a\u8bdd\u5217\u8868");
        JsonObject r = new JsonObject();
        r.addProperty("vfwebqq", this.vfwebqq);
        r.addProperty("clientid", (Number)53999199L);
        r.addProperty("psessionid", "");
        Response response = this.post(ApiURL.GET_RECENT_LIST, r);
        return SmartQQApi.getJsonArrayResult(response);
    }

    public long getQQById(long friendId) throws Exception {
        LOGGER.debug("\u5f00\u59cb\u83b7\u53d6QQ\u53f7");
        Response response = this.get(ApiURL.GET_QQ_BY_ID, friendId, this.vfwebqq);
        return SmartQQApi.getJsonObjectResult(response).get("account").getAsLong();
    }

    public JsonArray getFriendStatus() throws Exception {
        LOGGER.debug("\u5f00\u59cb\u83b7\u53d6\u597d\u53cb\u72b6\u6001");
        Response response = this.get(ApiURL.GET_FRIEND_STATUS, this.vfwebqq, this.psessionid);
        return SmartQQApi.getJsonArrayResult(response);
    }

    public JsonObject getGroupInfo(long groupCode) throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u7fa4\u8d44\u6599");
        Response response = this.get(ApiURL.GET_GROUP_INFO, groupCode, this.vfwebqq);
        JsonObject result = SmartQQApi.getJsonObjectResult(response);
        return result;
    }

    public JsonObject getDiscussInfo(long discussId) throws Exception {
        LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u8ba8\u8bba\u7ec4\u8d44\u6599");
        Response response = this.get(ApiURL.GET_DISCUSS_INFO, discussId, this.vfwebqq, this.psessionid);
        JsonObject result = SmartQQApi.getJsonObjectResult(response);
        return result;
    }

    private Response get(ApiURL url, Object ... params) throws IOException {
        Request.Builder builder = new Request.Builder().url(url.buildUrl(params)).addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36");
        if (url.getReferer() != null) {
            builder.addHeader("Referer", url.getReferer());
        }
        Request request = builder.tag(this.getClass()).build();
        Call call = this.client.newCall(request);
        return call.execute();
    }

    private Response post(ApiURL url, JsonObject r) throws IOException {
        FormBody body = new FormBody.Builder().add("r", r.toString()).build();
        Request.Builder builder = new Request.Builder().url(url.buildUrl(new Object[0])).addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36").addHeader("Origin", url.getOrigin()).post((RequestBody)body);
        if (url.getReferer() != null) {
            builder.addHeader("Referer", url.getReferer());
        }
        Request request = builder.tag(this.getClass()).build();
        Call call = this.client.newCall(request);
        return call.execute();
    }

    private Response postWithRetry(ApiURL url, JsonObject r) throws Exception {
        Response response;
        int times = 0;
        do {
            response = this.post(url, r);
        } while ((long)(++times) < 5L && response.code() != 200);
        return response;
    }

    private static JsonObject getJsonObjectResult(Response response) throws Exception {
        return SmartQQApi.getResponseJson(response).getAsJsonObject("result");
    }

    private static JsonArray getJsonArrayResult(Response response) throws Exception {
        return SmartQQApi.getResponseJson(response).getAsJsonArray("result");
    }

    private static void checkSendMsgResult(Response response) throws Exception {
        if (response.code() != 200) {
            String msg = String.format("\u53d1\u9001\u5931\u8d25\uff0cHttp\u8fd4\u56de\u7801[%d]", response.code());
            LOGGER.error(msg);
            throw new HttpException(response.code(), response.message());
        }
        JsonObject json = (JsonObject)new JsonParser().parse(response.body().string());
        Integer errCode = json.get("retcode").getAsInt();
        if (errCode == null || errCode != 0) {
            String msg = String.format("\u53d1\u9001\u5931\u8d25\uff0cApi\u8fd4\u56de\u7801[%d]", json.get("retcode").getAsInt());
            LOGGER.error(msg);
            throw new LogicException(json.get("retcode").getAsInt(), msg);
        }
        LOGGER.debug("\u53d1\u9001\u6210\u529f");
    }

    private static JsonObject getResponseJson(Response response) throws IOException {
        if (response.code() != 200) {
            throw new HttpException(response.code(), String.format("\u8bf7\u6c42\u5931\u8d25\uff0cHttp\u8fd4\u56de\u7801[%d]", response.code()));
        }
        JsonObject json = (JsonObject)new JsonParser().parse(response.body().string());
        Integer retCode = json.get("retcode").getAsInt();
        if (retCode != 0) {
            switch (retCode) {
                case 103: {
                    LOGGER.error("\u8bf7\u6c42\u5931\u8d25\uff0cApi\u8fd4\u56de\u7801[103]\u3002\u4f60\u9700\u8981\u8fdb\u5165http://w.qq.com\uff0c\u68c0\u67e5\u662f\u5426\u80fd\u6b63\u5e38\u63a5\u6536\u6d88\u606f\u3002\u5982\u679c\u53ef\u4ee5\u7684\u8bdd\u70b9\u51fb[\u8bbe\u7f6e]->[\u9000\u51fa\u767b\u5f55]\u540e\u67e5\u770b\u662f\u5426\u6062\u590d\u6b63\u5e38");
                    break;
                }
                case 100100: {
                    LOGGER.error("\u8bf7\u6c42\u5931\u8d25\uff0cApi\u8fd4\u56de\u7801[100100]");
                    break;
                }
                default: {
                    LOGGER.error(String.format("\u8bf7\u6c42\u5931\u8d25\uff0cApi\u8fd4\u56de\u7801[%d]", retCode));
                }
            }
            throw new LogicException(retCode.intValue(), String.format("\u8bf7\u6c42\u5931\u8d25\uff0cApi\u8fd4\u56de\u7801[%d]", retCode));
        }
        return json;
    }

    private String hash() {
        return SmartQQApi.hash(this.uin, this.ptwebqq);
    }

    private static void sleep(long seconds) {
        try {
            Thread.sleep(seconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String hash(long x, String K) {
        int[] N = new int[4];
        int T = 0;
        while (T < K.length()) {
            int n = T % 4;
            N[n] = N[n] ^ K.charAt(T);
            ++T;
        }
        String[] U = new String[]{"EC", "OK"};
        long[] V = new long[]{x >> 24 & 0xFFL ^ (long)U[0].charAt(0), x >> 16 & 0xFFL ^ (long)U[0].charAt(1), x >> 8 & 0xFFL ^ (long)U[1].charAt(0), x & 0xFFL ^ (long)U[1].charAt(1)};
        long[] U1 = new long[8];
        int T2 = 0;
        while (T2 < 8) {
            U1[T2] = T2 % 2 == 0 ? (long)N[T2 >> 1] : V[T2 >> 1];
            ++T2;
        }
        String[] N1 = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        String V1 = "";
        long[] lArray = U1;
        int n = U1.length;
        int n2 = 0;
        while (n2 < n) {
            long aU1 = lArray[n2];
            V1 = String.valueOf(V1) + N1[(int)(aU1 >> 4 & 0xFL)];
            V1 = String.valueOf(V1) + N1[(int)(aU1 & 0xFL)];
            ++n2;
        }
        return V1;
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.dispatcher().cancelAll();
        }
    }

    public void saveAuthInfo() {
        File f = new File(this.workDir, "auth.txt");
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            BufferedWriter output = new BufferedWriter(new FileWriter(f));
            output.write(this.ptwebqq);
            output.newLine();
            output.write(this.vfwebqq);
            output.newLine();
            output.write(String.valueOf(this.uin));
            output.newLine();
            output.write(this.psessionid);
            output.newLine();
            output.write(new Gson().toJson(this.cookieJar.getCookies()));
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readAuthInfo() {
        try {
            File f = new File(this.workDir, "auth.txt");
            BufferedReader input = new BufferedReader(new FileReader(f));
            this.ptwebqq = input.readLine();
            this.vfwebqq = input.readLine();
            this.uin = Long.valueOf(input.readLine());
            this.psessionid = input.readLine();
            String json = input.readLine();
            this.cookieJar.setCookies((List)new Gson().fromJson(json, (Type)AbstractContactHandler.type(List.class, new Type[]{Cookie.class})));
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

