/*
 * Decompiled with CFR 0.152.
 */
package com.scienjus.smartqq.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class CookieManager
implements CookieJar {
    private List<Cookie> cookies;
    private CookieSort sorter = new CookieSort();

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>();
        }
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                Cookie old = this.getFirstCookie(cookie.name());
                if (old != null && (old.value() == null || old.value().equals(""))) {
                    this.cookies.remove(old);
                }
                this.cookies.add(cookie);
            }
        }
    }

    public List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList<Cookie> matched = new ArrayList<Cookie>();
        if (this.cookies != null) {
            for (Cookie c : this.cookies) {
                if (!c.matches(url)) continue;
                matched.add(c);
            }
        }
        Collections.sort(matched, this.sorter);
        return matched;
    }

    public Cookie getFirstCookie(String name) {
        if (this.cookies != null) {
            for (Cookie c : this.cookies) {
                if (!c.name().equals(name)) continue;
                return c;
            }
        }
        return null;
    }

    public void remove(String name) {
        if (this.cookies != null) {
            ArrayList<Cookie> removes = new ArrayList<Cookie>();
            for (Cookie c : this.cookies) {
                if (!c.name().equals(name)) continue;
                removes.add(c);
            }
            for (Cookie c : removes) {
                this.cookies.remove(c);
            }
        }
    }

    private class CookieSort
    implements Comparator<Cookie> {
        private CookieSort() {
        }

        @Override
        public int compare(Cookie o1, Cookie o2) {
            return o1.name().compareTo(o2.name());
        }
    }
}

