/*
 * Decompiled with CFR 0.152.
 */
package com.scienjus.smartqq;

import com.google.gson.Gson;
import com.qiniu.common.Zone;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.scienjus.smartqq.client.CookieManager;
import java.io.File;
import java.io.Serializable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.Call;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class QNUploader {
    public static String API_URL = "http://api.ieclipse.cn/smartqq/upload/";
    public static String API_GET_TOKEN = String.valueOf(API_URL) + "token";
    public static String API_CALLBACK = String.valueOf(API_URL) + "callback";
    private OkHttpClient client;
    CookieManager cookieJar = new CookieManager();

    public QNUploader() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.cookieJar((CookieJar)this.cookieJar);
        builder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        this.client = builder.build();
    }

    public AuthInfo getToken(String qq, String ak, String sk, String bucket, String key) throws Exception {
        FormBody body = new FormBody.Builder().add("key", key).add("bucket", bucket).add("qq", qq).build();
        Request.Builder builder = new Request.Builder().url(API_GET_TOKEN).addHeader("accessKey", ak).addHeader("secretKey", sk).post((RequestBody)body);
        Request request = builder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        AuthResponse info = null;
        String json = response.body().string();
        System.out.println(json);
        if (response.code() == 200) {
            info = (AuthResponse)new Gson().fromJson(json, AuthResponse.class);
        }
        if (info == null) {
            throw new RuntimeException(response.message());
        }
        if (info.code != 0 || info.data == null) {
            throw new RuntimeException(info.msg);
        }
        return info.data;
    }

    public UploadInfo upload(String qq, File file, String ak, String sk, String bucket, Zone zone) throws Exception {
        String key = String.format("%s/%s", qq, file.getName());
        AuthInfo authInfo = this.getToken(qq, ak, sk, bucket, key);
        System.out.println(authInfo);
        if (authInfo.limit > 0L && file.length() > authInfo.limit) {
            throw new RuntimeException("\u4eca\u65e5\u4e0a\u4f20\u6d41\u91cf\u4e0d\u8db3\uff0c\u5269\u4f59\u6d41\u91cf\uff1a" + authInfo.limit);
        }
        Configuration cfg = new Configuration(zone == null ? Zone.autoZone() : zone);
        UploadManager uploadManager = new UploadManager(cfg);
        com.qiniu.http.Response response = uploadManager.put(file.getAbsolutePath(), key, authInfo.token);
        if (!response.isOK()) {
            throw new RuntimeException(String.valueOf(response.error) + "(code=" + response.statusCode + ")");
        }
        UploadInfo putRet = (UploadInfo)new Gson().fromJson(response.bodyString(), UploadInfo.class);
        if (authInfo.domain != null && !authInfo.domain.isEmpty()) {
            putRet.domain = authInfo.domain;
        }
        if (authInfo.limit > 0L) {
            this.callback(qq, putRet);
        }
        return putRet;
    }

    private void callback(String qq, UploadInfo info) {
        try {
            FormBody body = new FormBody.Builder().add("qq", qq).add("fsize", String.valueOf(info.fsize)).add("key", info.key).build();
            Request.Builder builder = new Request.Builder().url(API_CALLBACK).post((RequestBody)body);
            Request request = builder.build();
            Call call = this.client.newCall(request);
            call.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class AuthInfo
    implements Serializable {
        public String token;
        public String domain;
        public int days;
        public long limit;

        public String toString() {
            return String.format("domain:%s, days:%d, limit:%s, token:%s", this.domain, this.days, this.limit, this.token);
        }
    }

    public static class AuthResponse
    implements Serializable {
        public int code;
        public String msg;
        public AuthInfo data;
    }

    public static class UploadInfo {
        public String key;
        public String hash;
        public String bucket;
        public long fsize;
        public String domain;

        public String getUrl() {
            return String.valueOf(this.domain) + "/" + this.key;
        }

        public String getUrl(String domain, boolean ts) {
            String url = this.domain;
            if (domain != null && !domain.isEmpty()) {
                url = domain;
            }
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                url = "http://" + url;
            }
            url = url.endsWith("/") ? String.valueOf(url) + this.key : String.valueOf(url) + "/" + this.key;
            if (ts) {
                url = String.valueOf(url) + "?ts=" + System.currentTimeMillis();
            }
            return url;
        }

        public String toString() {
            return String.format("key:%s,hash=%s,bucket=%s,fsize=%s", this.key, this.hash, this.bucket, this.fsize);
        }
    }
}

