/**
 * CloudRef API
 * REST API of the CloudRef system.
 *
 * OpenAPI spec version: 1.0
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/* tslint:disable:no-unused-variable member-ordering */

import { Inject, Injectable, Optional }                      from '@angular/core';
import { Http, Headers, URLSearchParams }                    from '@angular/http';
import { RequestMethod, RequestOptions, RequestOptionsArgs } from '@angular/http';
import { Response, ResponseContentType }                     from '@angular/http';

import { Observable }                                        from 'rxjs/Observable';
import 'rxjs/add/operator/map';

import * as models                                           from '../model/models';
import { BASE_PATH, COLLECTION_FORMATS }                     from '../variables';
import { Configuration }                                     from '../configuration';


@Injectable()
export class DefaultApi {

    protected basePath = location.protocol + '//' + location.hostname + ':' + (location.port === '4200' ? '8080' : location.port);

    public defaultHeaders: Headers = new Headers();
    public configuration: Configuration = new Configuration();

    constructor(protected http: Http, @Optional()@Inject(BASE_PATH) basePath: string, @Optional() configuration: Configuration) {
        if (basePath) {
            this.basePath = basePath;
        }
        if (configuration) {
            this.configuration = configuration;
        }
    }

    /**
     *
     * @param bibtexkey
     * @param id
     */
    public deleteComment(bibtexkey: string, id: number, extraHttpRequestParams?: any): Observable<{}> {
        return this.deleteCommentWithHttpInfo(bibtexkey, id, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     */
    public getPdfComments(bibtexkey: string, extraHttpRequestParams?: any): Observable<Array<models.Comment>> {
        return this.getPdfCommentsWithHttpInfo(bibtexkey, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     */
    public getPdfFile(bibtexkey: string, extraHttpRequestParams?: any): Observable<{}> {
        return this.getPdfFileWithHttpInfo(bibtexkey, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return new Blob([response.blob()], { type: 'application/pdf' }) || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     */
    public getReference(bibtexkey: string, extraHttpRequestParams?: any): Observable<models.BibTeXEntry> {
        return this.getReferenceWithHttpInfo(bibtexkey, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     */
    public getReferences(extraHttpRequestParams?: any): Observable<Array<models.Reference>> {
        return this.getReferencesWithHttpInfo(extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     * @param id
     */
    public getSuggestion(bibtexkey: string, id: number, extraHttpRequestParams?: any): Observable<models.BibTeXEntry> {
        return this.getSuggestionWithHttpInfo(bibtexkey, id, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     */
    public getSuggestions(bibtexkey: string, extraHttpRequestParams?: any): Observable<Array<{ [key: string]: string; }>> {
        return this.getSuggestionsWithHttpInfo(bibtexkey, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     */
    public loginUser(extraHttpRequestParams?: any): Observable<string> {
        return this.loginUserWithHttpInfo(extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     * @param id
     * @param body
     */
    public mergeSuggestion(bibtexkey: string, id: number, body: models.MergeInstruction, extraHttpRequestParams?: any): Observable<{}> {
        return this.mergeSuggestionWithHttpInfo(bibtexkey, id, body, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     * @param body
     */
    public rateReference(bibtexkey: string, body: models.Rating, extraHttpRequestParams?: any): Observable<models.ResponseRatingReference> {
        return this.rateReferenceWithHttpInfo(bibtexkey, body, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     * @param id
     * @param body
     */
    public rateSuggestion(bibtexkey: string, id: number, body: models.Rating, extraHttpRequestParams?: any): Observable<models.ResponseRatingSuggestion> {
        return this.rateSuggestionWithHttpInfo(bibtexkey, id, body, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param body
     * @param bibtexkey
     */
    public saveComment(body: models.Comment, bibtexkey: string, extraHttpRequestParams?: any): Observable<{}> {
        return this.saveCommentWithHttpInfo(body, bibtexkey, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else if (response.status === 201) {
                    return response.url;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     * @param file
     */
    public savePdfFile(bibtexkey: string, file: any, extraHttpRequestParams?: any): Observable<{}> {
        return this.savePdfFileWithHttpInfo(bibtexkey, file, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     * @param body
     */
    public saveReference(bibtexkey: string, body: models.BibTeXEntry, extraHttpRequestParams?: any): Observable<{}> {
        return this.saveReferenceWithHttpInfo(bibtexkey, body, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } if (response.status === 201) {
                    return response.url;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param file
     */
    public saveReferences(file: any, extraHttpRequestParams?: any): Observable<{}> {
        return this.saveReferencesWithHttpInfo(file, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else if (response.status === 201)  {
                  return response.url;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     * @param body
     */
    public saveSuggestion(bibtexkey: string, body: models.BibTeXEntry, extraHttpRequestParams?: any): Observable<{}> {
        return this.saveSuggestionWithHttpInfo(bibtexkey, body, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } if (response.status === 201) {
                    return response.url;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param username
     * @param body
     */
    public saveUser(username: string, body: models.User, extraHttpRequestParams?: any): Observable<{}> {
        return this.saveUserWithHttpInfo(username, body, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param body
     * @param bibtexkey
     * @param id
     */
    public updateComment(body: models.Comment, bibtexkey: string, id: number, extraHttpRequestParams?: any): Observable<{}> {
        return this.updateCommentWithHttpInfo(body, bibtexkey, id, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }

    /**
     *
     * @param bibtexkey
     * @param id
     * @param body
     */
    public updateSuggestion(bibtexkey: string, id: number, body: models.BibTeXEntry, extraHttpRequestParams?: any): Observable<{}> {
        return this.updateSuggestionWithHttpInfo(bibtexkey, id, body, extraHttpRequestParams)
            .map((response: Response) => {
                if (response.status === 204) {
                    return undefined;
                } else {
                    return response.json() || {};
                }
            });
    }


    /**
     *
     *
     * @param bibtexkey
     * @param id
     */
    public deleteCommentWithHttpInfo(bibtexkey: string, id: number, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/pdf/comments/${id}'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey))
                    .replace('${' + 'id' + '}', String(id));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling deleteComment.');
        }
        // verify required parameter 'id' is not null or undefined
        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling deleteComment.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Delete,
            headers: headers,
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     */
    public getPdfCommentsWithHttpInfo(bibtexkey: string, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/pdf/comments'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling getPdfComments.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/json'
        ];

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Get,
            headers: headers,
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     */
    public getPdfFileWithHttpInfo(bibtexkey: string, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/pdf'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling getPdfFile.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/octet-stream'
        ];

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Get,
            headers: headers,
            search: queryParameters,
            withCredentials: this.configuration.withCredentials,
            responseType: ResponseContentType.Blob,
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     */
    public getReferenceWithHttpInfo(bibtexkey: string, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling getReference.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/json'
        ];

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Get,
            headers: headers,
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     */
    public getReferencesWithHttpInfo(extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references';

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // to determine the Content-Type header
        let consumes: string[] = [
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/json'
        ];

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Get,
            headers: headers,
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     * @param id
     */
    public getSuggestionWithHttpInfo(bibtexkey: string, id: number, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/suggestions/${id}'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey))
                    .replace('${' + 'id' + '}', String(id));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling getSuggestion.');
        }
        // verify required parameter 'id' is not null or undefined
        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling getSuggestion.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/json'
        ];

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Get,
            headers: headers,
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     */
    public getSuggestionsWithHttpInfo(bibtexkey: string, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/suggestions'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling getSuggestions.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/json'
        ];

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Get,
            headers: headers,
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     */
    public loginUserWithHttpInfo(extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/login';

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // to determine the Content-Type header
        let consumes: string[] = [
        ];

        // to determine the Accept header
        let produces: string[] = [
            'application/json'
        ];

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Get,
            headers: headers,
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     * @param id
     * @param body
     */
    public mergeSuggestionWithHttpInfo(bibtexkey: string, id: number, body: models.MergeInstruction, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/suggestions/${id}/merge'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey))
                    .replace('${' + 'id' + '}', String(id));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling mergeSuggestion.');
        }
        // verify required parameter 'id' is not null or undefined
        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling mergeSuggestion.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling mergeSuggestion.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        headers.set('Content-Type', 'application/json');

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Post,
            headers: headers,
            body: body == null ? '' : JSON.stringify(body), // https://github.com/angular/angular/issues/10612
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     * @param body
     */
    public rateReferenceWithHttpInfo(bibtexkey: string, body: models.Rating, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/rating'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling rateReference.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling rateReference.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        headers.set('Content-Type', 'application/json');

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Post,
            headers: headers,
            body: body == null ? '' : JSON.stringify(body), // https://github.com/angular/angular/issues/10612
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     * @param id
     * @param body
     */
    public rateSuggestionWithHttpInfo(bibtexkey: string, id: number, body: models.Rating, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/suggestions/${id}/rating'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey))
                    .replace('${' + 'id' + '}', String(id));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling rateSuggestion.');
        }
        // verify required parameter 'id' is not null or undefined
        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling rateSuggestion.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling rateSuggestion.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        headers.set('Content-Type', 'application/json');

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Post,
            headers: headers,
            body: body == null ? '' : JSON.stringify(body), // https://github.com/angular/angular/issues/10612
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param body
     * @param bibtexkey
     */
    public saveCommentWithHttpInfo(body: models.Comment, bibtexkey: string, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/pdf/comments'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling saveComment.');
        }
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling saveComment.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        headers.set('Content-Type', 'application/json');

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Post,
            headers: headers,
            body: body == null ? '' : JSON.stringify(body), // https://github.com/angular/angular/issues/10612
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     * @param file
     */
    public savePdfFileWithHttpInfo(bibtexkey: string, file: any, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/pdf'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey));

        let queryParameters = new URLSearchParams();

        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling savePdfFile.');
        }
        // verify required parameter 'file' is not null or undefined
        if (file === null || file === undefined) {
            throw new Error('Required parameter file was null or undefined when calling savePdfFile.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'multipart/form-data'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        //headers.set('Content-Type', 'application/x-www-form-urlencoded');

        const input = new FormData();
        if (file !== undefined) {
            input.append('file', file);
        }

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Put,
            body: input,
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     * @param body
     */
    public saveReferenceWithHttpInfo(bibtexkey: string, body: models.BibTeXEntry, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling saveReference.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling saveReference.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        headers.set('Content-Type', 'application/json');

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Put,
            headers: headers,
            body: body == null ? '' : JSON.stringify(body), // https://github.com/angular/angular/issues/10612
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param file
     */
    public saveReferencesWithHttpInfo(file: any, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references';

        let queryParameters = new URLSearchParams();

        // verify required parameter 'file' is not null or undefined
        if (file === null || file === undefined) {
            throw new Error('Required parameter file was null or undefined when calling savePdfFile.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'multipart/form-data'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        //headers.set('Content-Type', 'application/x-www-form-urlencoded');

        const input = new FormData();
        if (file !== undefined) {
            input.append('file', file);
        }

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Post,
            body: input,
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     * @param body
     */
    public saveSuggestionWithHttpInfo(bibtexkey: string, body: models.BibTeXEntry, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/suggestions'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling saveSuggestion.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling saveSuggestion.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        headers.set('Content-Type', 'application/json');

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Post,
            headers: headers,
            body: body == null ? '' : JSON.stringify(body), // https://github.com/angular/angular/issues/10612
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param username
     * @param body
     */
    public saveUserWithHttpInfo(username: string, body: models.User, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/users/${username}'
                    .replace('${' + 'username' + '}', String(username));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'username' is not null or undefined
        if (username === null || username === undefined) {
            throw new Error('Required parameter username was null or undefined when calling saveUser.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling saveUser.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        headers.set('Content-Type', 'application/json');

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Put,
            headers: headers,
            body: body == null ? '' : JSON.stringify(body), // https://github.com/angular/angular/issues/10612
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param body
     * @param bibtexkey
     * @param id
     */
    public updateCommentWithHttpInfo(body: models.Comment, bibtexkey: string, id: number, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/pdf/comments/${id}'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey))
                    .replace('${' + 'id' + '}', String(id));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling updateComment.');
        }
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling updateComment.');
        }
        // verify required parameter 'id' is not null or undefined
        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling updateComment.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        headers.set('Content-Type', 'application/json');

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Put,
            headers: headers,
            body: body == null ? '' : JSON.stringify(body), // https://github.com/angular/angular/issues/10612
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

    /**
     *
     *
     * @param bibtexkey
     * @param id
     * @param body
     */
    public updateSuggestionWithHttpInfo(bibtexkey: string, id: number, body: models.BibTeXEntry, extraHttpRequestParams?: any): Observable<Response> {
        const path = this.basePath + '/references/${bibtexkey}/suggestions/${id}'
                    .replace('${' + 'bibtexkey' + '}', String(bibtexkey))
                    .replace('${' + 'id' + '}', String(id));

        let queryParameters = new URLSearchParams();
        let headers = new Headers(this.defaultHeaders.toJSON()); // https://github.com/angular/angular/issues/6845
        // verify required parameter 'bibtexkey' is not null or undefined
        if (bibtexkey === null || bibtexkey === undefined) {
            throw new Error('Required parameter bibtexkey was null or undefined when calling updateSuggestion.');
        }
        // verify required parameter 'id' is not null or undefined
        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling updateSuggestion.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling updateSuggestion.');
        }
        // to determine the Content-Type header
        let consumes: string[] = [
            'application/json'
        ];

        // to determine the Accept header
        let produces: string[] = [
        ];

        headers.set('Content-Type', 'application/json');

        let requestOptions: RequestOptionsArgs = new RequestOptions({
            method: RequestMethod.Put,
            headers: headers,
            body: body == null ? '' : JSON.stringify(body), // https://github.com/angular/angular/issues/10612
            search: queryParameters,
            withCredentials:this.configuration.withCredentials
        });
        // https://github.com/swagger-api/swagger-codegen/issues/4037
        if (extraHttpRequestParams) {
            requestOptions = (<any>Object).assign(requestOptions, extraHttpRequestParams);
        }

        return this.http.request(path, requestOptions);
    }

}
