# Invoice Excretion using LLM

Welcome to my Streamlit app designed for invoice extraction utilizing OpenAI's API. This versatile tool offers two distinct output models for enhanced flexibility and accuracy in extracting invoice data.

### Powered by

![Python](https://img.shields.io/badge/Python-FFD43B?style=for-the-badge&logo=python&logoColor=blue)
![Langchain](https://img.shields.io/badge/%F0%9F%A6%9C%EF%B8%8F%F0%9F%94%97%20LangChain-black?style=for-the-badge)
![Streamlit](https://img.shields.io/badge/Streamlit-FF4B4B?style=for-the-badge&logo=Streamlit&logoColor=white)
![OpenAI](https://img.shields.io/badge/OpenAI-black?style=for-the-badge)

### Key Features

- Supports extraction of data from `PDF` files
- Utilizes `function calling` with LLM to enhance accuracy
- Offers two output options: `JSON` and `CSV`

### How to Use?

1. **Set Up Your OpenAI API Key:** Paste your OpenAI API key into the designated section in the sidebar. This key is essential for accessing OpenAI's language models. Please note that the application does not store this key anywhere else and only uses it for calling APIs.

2. **Upload File:** Upload your PDF invoice, select the desired output type, and press the "Extract" button to begin the extraction process.

#### Want to Run Locally?

- Follow the instructions outlined on [GitHub](https://github.com/Ja-yy/Invoice-excreter-bot-llm).
