﻿using System.Collections.Generic;
using System.Text.Json.Serialization;

namespace Forge.OpenAI.Models.FineTuningJob
{

    /// <summary>
    /// https://platform.openai.com/docs/api-reference/fine-tuning/object#fine-tuning/object-integrations
    /// </summary>
    public class FineTuningJobWeightAndBias
    {

        /// <summary>
        /// The name of the project that the new run will be created under.
        /// </summary>
        /// <value>
        /// The project.
        /// </value>
        [JsonPropertyName("project")]
        public string Project { get; set; }

        /// <summary>
        /// A display name to set for the run. If not set, we will use the Job ID as the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        [JsonPropertyName("name")]
        public string Name { get; set; }

        /// <summary>
        /// The entity to use for the run. 
        /// This allows you to set the team or username of the WandB user that you would like associated with the run. 
        /// If not set, the default entity for the registered WandB API key is used.
        /// </summary>
        /// <value>
        /// The entity.
        /// </value>
        [JsonPropertyName("entity")]
        public string Entity { get; set; }

        /// <summary>
        /// A list of tags to be attached to the newly created run. 
        /// These tags are passed through directly to WandB. 
        /// Some default tags are generated by OpenAI: "openai/finetune", "openai/{base-model}", "openai/{ftjob-abcdef}".
        /// </summary>
        /// <value>
        /// The tags.
        /// </value>
        [JsonPropertyName("tags")]
        public IReadOnlyList<string> Tags { get; set; }

    }

}
